/*
 * Copyright (C) 2006-2008 the VideoLAN team
 *
 * This file is part of VLMa.
 * 
 * VLMa is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 * 
 * VLMa is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with VLMa. If not, see <http://www.gnu.org/licenses/>.
 *
 */

package org.videolan.vlma.common.medias;

import org.videolan.vlma.common.programs.IVlProgram;

/**
 * A media contains at least one program and can tell whether it belongs to the 
 * same media group.
 * 
 * @author SylV
 * @version 1.0
 */
public interface IVlMedia extends Comparable<IVlMedia> {

    /**
     * Gives the media name.
     * 
     * @return the media name
     */
    public String getName();

    /**
     * Gives the program associated with the media.
     * 
     * @return the program
     */
    public IVlProgram getProgram();

    /**
     * Sets the program associated with the media.
     * 
     * @param program the program
     */
    public void setProgram(IVlProgram program);

    /**
     * Returns true if and only if the given media belongs to the same group.
     * 
     * @param media the media to compare to
     * @return true if both media belong to the same group, false otherwise
     */
    public boolean sameGroup(IVlMedia media);

    /**
     * Returns true if and only if the media belongs to the given media group.
     * 
     * @param group the group
     * @return true if the media belongs to the group, false otherwise
     */
    public boolean belongsToGroup(VlMediaGroup group);

    /**
     * Compares two media instances.
     * 
     * @param o the object to compare to
     * @return true if objects are the same, false otherwise
     */
    public boolean equals(Object o);
}
