/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.impl.core.loading;

import org.ietf.uri.ResourceConnection;
import org.ietf.uri.event.ProgressEvent;
import org.ietf.uri.event.ProgressListener;
import org.web3d.browser.BrowserCore;
import org.web3d.browser.BrowserCoreListener;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.nodes.VRMLScene;
import org.xj3d.core.loading.ContentLoadManager;
import org.xj3d.core.loading.ScriptLoader;

public class FramerateThrottle
extends Thread
implements ProgressListener,
BrowserCoreListener {
    private static final String NAME = "Xj3D Framerate Throttle";
    private static final int FRAME_CYCLE_MINIMUM_STARTUP = 1000;
    private int FRAME_CYCLE_MINIMUM_NOLOADING = 0;
    private static final int FRAME_CYCLE_MINIMUM_LOADING = 60;
    private ScriptLoader scriptLoader;
    private ContentLoadManager loadManager;
    private static final int WAIT_TIME = 50;
    private static final int LOAD_WAIT = 3;
    private int noActivity;
    private BrowserCore universe;
    private ErrorReporter errorReporter;
    private boolean doRun;
    private boolean mainFileLoading;
    private boolean initialLoadDone;
    private static final boolean displayLoadTime = false;
    private int lastTotal;
    private int lastTotalTimes;
    private boolean reportedError;
    private long startTime;

    public FramerateThrottle(BrowserCore browserCore, ErrorReporter errorReporter) {
        super(NAME);
        ResourceConnection.addGlobalProgressListener(this);
        this.universe = browserCore;
        this.errorReporter = errorReporter == null ? DefaultErrorReporter.getDefaultReporter() : errorReporter;
        this.universe.addCoreListener(this);
        this.doRun = true;
        this.start();
    }

    public void browserInitialized(VRMLScene vRMLScene) {
        this.mainFileLoading = false;
        this.initialLoadDone = false;
        this.startTime = System.currentTimeMillis();
    }

    public void urlLoadFailed(String string) {
    }

    public void browserShutdown() {
    }

    public void browserDisposed() {
        ResourceConnection.removeGlobalProgressListener(this);
        this.doRun = false;
    }

    public void connectionEstablished(ProgressEvent progressEvent) {
        this.noActivity = 3;
    }

    public void handshakeInProgress(ProgressEvent progressEvent) {
    }

    public void downloadStarted(ProgressEvent progressEvent) {
    }

    public void downloadUpdate(ProgressEvent progressEvent) {
        this.noActivity = 3;
    }

    public void downloadEnded(ProgressEvent progressEvent) {
    }

    public void downloadError(ProgressEvent progressEvent) {
    }

    public void run() {
        this.startTime = System.currentTimeMillis();
        while (this.doRun) {
            int n = 0;
            int n2 = 0;
            if (this.scriptLoader != null) {
                n = this.scriptLoader.getNumberInProgress();
            }
            if (this.loadManager != null) {
                n2 = this.loadManager.getNumberInProgress();
            }
            int n3 = n2 + n;
            if (this.mainFileLoading) {
                this.universe.setMinimumFrameInterval(1000, false);
            } else if (n3 > 0) {
                if (n3 == this.lastTotal) {
                    ++this.lastTotalTimes;
                    if (this.lastTotalTimes > 40 && !this.reportedError) {
                        this.reportedError = true;
                        this.initialLoadDone = true;
                        this.errorReporter.warningReport("Stuck on same queue count: scripts: " + n + " textures: " + n2 + " stopping throttle.", null);
                        this.universe.setMinimumFrameInterval(this.FRAME_CYCLE_MINIMUM_NOLOADING, false);
                    }
                } else {
                    this.lastTotalTimes = 0;
                    if (this.initialLoadDone) {
                        this.universe.setMinimumFrameInterval(60, false);
                    } else {
                        this.universe.setMinimumFrameInterval(1000, false);
                    }
                }
                this.lastTotal = n3;
            } else if (this.noActivity > 0) {
                this.universe.setMinimumFrameInterval(60, false);
                --this.noActivity;
            } else {
                this.universe.setMinimumFrameInterval(this.FRAME_CYCLE_MINIMUM_NOLOADING, false);
                this.initialLoadDone = true;
            }
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {}
        }
    }

    public boolean isInitialLoadDone() {
        return this.initialLoadDone;
    }

    public void setMinimumNoLoading(int n) {
        this.FRAME_CYCLE_MINIMUM_NOLOADING = n;
    }

    public void startedLoading() {
        this.mainFileLoading = true;
    }

    public void setScriptLoader(ScriptLoader scriptLoader) {
        this.scriptLoader = scriptLoader;
    }

    public void setLoadManager(ContentLoadManager contentLoadManager) {
        this.loadManager = contentLoadManager;
    }

    public void shutdown() {
        this.doRun = false;
    }
}

