/*
 * Sentinella
 * http://sentinella.sourceforge.net/
 * Copyright (c) 2009-2013 Carlos Olmedo Escobar <carlos.olmedo.e@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include "Sleep.h"
#include <QDBusInterface>

Sleep::Sleep(const bool isKDE, const Solid::PowerManagement::SleepState state) :
	AbstractThreadedAction(), isKDE(isKDE), state(state) {

}

void Sleep::run() {
	QDBusInterface* interface;
	if (isKDE) {
		interface = new QDBusInterface("org.kde.Solid.PowerManagement", "/org/freedesktop/PowerManagement", "org.freedesktop.PowerManagement");
		if (state == Solid::PowerManagement::SuspendState)
			interface->call("Suspend");
		else if (state == Solid::PowerManagement::HibernateState)
			interface->call("Hibernate");
	} else {
		interface = new QDBusInterface("org.freedesktop.login1",
				"/org/freedesktop/login1", "org.freedesktop.login1.Manager",
				 QDBusConnection::systemBus());
		if (interface->isValid()) {
			interface->call(state == Solid::PowerManagement::SuspendState ? 
                                        "Suspend" : "Hibernate", false);
		} else {
			interface = new QDBusInterface("org.freedesktop.UPower", "/org/freedesktop/UPower",
						       "org.freedesktop.UPower", QDBusConnection::systemBus());
			interface->call(state == Solid::PowerManagement::SuspendState ? "Suspend" : "Hibernate");
		}
	}
	delete interface;
}
