// Copyright (C) 1999-2012
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __colorbarrgb_h__
#define __colorbarrgb_h__

#include "colorbarbase.h"

class Filter;

class ColorbarRGB : public virtual ColorbarBase {
 protected:
  int channel;
  float bias[3];
  float contrast[3];

 private:
  void psHorz(Filter&, int, int);
  void psVert(Filter&, int, int);

protected:
  void reset();
  int calcContrastBias(int, float, float);

#ifdef _MACOSX
  void macosx(float, int, int, const Vector&, const Vector&);
#endif

#ifdef _WIN32
  void win32(float, int, int, const Vector&, const Vector&);
#endif

public:
  ColorbarRGB(Tcl_Interp*, Tk_Canvas, Tk_Item*);

  // SubCommandFunctions

  void adjustCmd(float, float);
  void getBiasCmd();
  void getColorbarCmd();
  void getColormapCmd();
  void getColormapNameCmd(int);
  void getColormapFileNameCmd(int);
  void getContrastCmd();
  void getCurrentFileNameCmd();
  void getCurrentIDCmd();
  void getCurrentNameCmd();
  void setColorbarCmd(float, float, float, float, float, float, int);
  void getRGBChannelCmd();
  void setRGBChannelCmd(const char*);
};

#endif
