### WARNING: This file is auto-generated by our OpenAPI spec. Do not
### edit it manually.

require_relative '../../resource_includes/response_helper'

module Asana
  module Resources
    class ProjectBriefsBase < Resource

      def self.inherited(base)
        Registry.register(base)
      end

      class << self
        # Create a project brief
        #
        # project_gid - [str]  (required) Globally unique identifier for the project.
        # options - [Hash] the request I/O options
        # > opt_fields - [list[str]]  Defines fields to return. Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below. The id of included objects will always be returned, regardless of the field options.
        # > opt_pretty - [bool]  Provides “pretty” output. Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
        # data - [Hash] the attributes to POST
        def create_project_brief(client, project_gid: required("project_gid"), options: {}, **data)
          path = "/projects/{project_gid}/project_briefs"
          path["{project_gid}"] = project_gid
          parse(client.post(path, body: data, options: options)).first
        end

        # Delete a project brief
        #
        # project_brief_gid - [str]  (required) Globally unique identifier for the project brief.
        # options - [Hash] the request I/O options
        # > opt_fields - [list[str]]  Defines fields to return. Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below. The id of included objects will always be returned, regardless of the field options.
        # > opt_pretty - [bool]  Provides “pretty” output. Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
        def delete_project_brief(client, project_brief_gid: required("project_brief_gid"), options: {})
          path = "/project_briefs/{project_brief_gid}"
          path["{project_brief_gid}"] = project_brief_gid
          parse(client.delete(path, options: options)).first
        end

        # Get a project brief
        #
        # project_brief_gid - [str]  (required) Globally unique identifier for the project brief.
        # options - [Hash] the request I/O options
        # > opt_fields - [list[str]]  Defines fields to return. Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below. The id of included objects will always be returned, regardless of the field options.
        # > opt_pretty - [bool]  Provides “pretty” output. Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
        def get_project_brief(client, project_brief_gid: required("project_brief_gid"), options: {})
          path = "/project_briefs/{project_brief_gid}"
          path["{project_brief_gid}"] = project_brief_gid
          parse(client.get(path, options: options)).first
        end

        # Update a project brief
        #
        # project_brief_gid - [str]  (required) Globally unique identifier for the project brief.
        # options - [Hash] the request I/O options
        # > opt_fields - [list[str]]  Defines fields to return. Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below. The id of included objects will always be returned, regardless of the field options.
        # > opt_pretty - [bool]  Provides “pretty” output. Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
        # data - [Hash] the attributes to PUT
        def update_project_brief(client, project_brief_gid: required("project_brief_gid"), options: {}, **data)
          path = "/project_briefs/{project_brief_gid}"
          path["{project_brief_gid}"] = project_brief_gid
          parse(client.put(path, body: data, options: options)).first
        end

      end
    end
  end
end
