% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lincombo.R
\name{step_lincomb}
\alias{step_lincomb}
\title{Linear Combination Filter}
\usage{
step_lincomb(
  recipe,
  ...,
  role = NA,
  trained = FALSE,
  max_steps = 5,
  removals = NULL,
  skip = FALSE,
  id = rand_id("lincomb")
)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose variables
for this step. See \code{\link[=selections]{selections()}} for more details.}

\item{role}{Not used by this step since no new variables are
created.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{max_steps}{The number of times to apply the algorithm.}

\item{removals}{A character string that contains the names of
columns that should be removed. These values are not determined
until \code{\link[=prep.recipe]{prep.recipe()}} is called.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[=bake.recipe]{bake.recipe()}}? While all operations are baked
when \code{\link[=prep.recipe]{prep.recipe()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations.}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
An updated version of \code{recipe} with the new step added to the
sequence of any existing operations.
}
\description{
\code{step_lincomb} creates a \emph{specification} of a recipe
step that will potentially remove numeric variables that have
linear combinations between them.
}
\details{
This step finds exact linear combinations between two
or more variables and recommends which column(s) should be
removed to resolve the issue. This algorithm may need to be
applied multiple times (as defined by \code{max_steps}).

When you \code{\link[=tidy]{tidy()}} this step, a tibble with column \code{terms} (the columns
that will be removed) is returned.
}
\examples{
library(modeldata)
data(biomass)

biomass$new_1 <- with(biomass,
                      .1*carbon - .2*hydrogen + .6*sulfur)
biomass$new_2 <- with(biomass,
                      .5*carbon - .2*oxygen + .6*nitrogen)

biomass_tr <- biomass[biomass$dataset == "Training",]
biomass_te <- biomass[biomass$dataset == "Testing",]

rec <- recipe(HHV ~ carbon + hydrogen + oxygen + nitrogen +
                sulfur + new_1 + new_2,
              data = biomass_tr)

lincomb_filter <- rec \%>\%
  step_lincomb(all_numeric_predictors())

lincomb_filter_trained <- prep(lincomb_filter, training = biomass_tr)
lincomb_filter_trained

tidy(lincomb_filter, number = 1)
tidy(lincomb_filter_trained, number = 1)
}
\seealso{
Other variable filter steps: 
\code{\link{step_corr}()},
\code{\link{step_nzv}()},
\code{\link{step_rm}()},
\code{\link{step_select}()},
\code{\link{step_zv}()}
}
\author{
Max Kuhn, Kirk Mettler, and Jed Wing
}
\concept{variable filter steps}
