% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mold.R, R/blueprint-formula-default.R,
%   R/blueprint-recipe-default.R, R/blueprint-xy-default.R
\name{run-mold}
\alias{run-mold}
\alias{run_mold}
\alias{run_mold.default_formula_blueprint}
\alias{run_mold.default_recipe_blueprint}
\alias{run_mold.default_xy_blueprint}
\title{\code{mold()} according to a blueprint}
\usage{
run_mold(blueprint, ...)

\method{run_mold}{default_formula_blueprint}(blueprint, ..., data)

\method{run_mold}{default_recipe_blueprint}(blueprint, ..., data)

\method{run_mold}{default_xy_blueprint}(blueprint, ..., x, y)
}
\arguments{
\item{blueprint}{A preprocessing blueprint.}

\item{...}{Not used. Required for extensibility.}

\item{data}{A data frame or matrix containing the outcomes and predictors.}

\item{x}{A data frame or matrix containing the predictors.}

\item{y}{A data frame, matrix, or vector containing the outcomes.}
}
\value{
\code{run_mold()} methods return the object that is then immediately returned from
\code{mold()}. See the return value section of \code{\link[=mold]{mold()}} to understand what the
structure of the return value should look like.
}
\description{
This is a developer facing function that is \emph{only} used if you are creating
your own blueprint subclass. It is called from \code{\link[=mold]{mold()}} and dispatches off
the S3 class of the \code{blueprint}. This gives you an opportunity to mold the
data in a way that is specific to your blueprint.

\code{run_mold()} will be called with different arguments depending on the
interface to \code{mold()} that is used:
\itemize{
\item XY interface:
\itemize{
\item \code{run_mold(blueprint, x = x, y = y)}
}
\item Formula interface:
\itemize{
\item \code{run_mold(blueprint, data = data)}
\item Additionally, the \code{blueprint} will have been updated to contain the
\code{formula}.
}
\item Recipe interface:
\itemize{
\item \code{run_mold(blueprint, data = data)}
\item Additionally, the \code{blueprint} will have been updated to contain the
\code{recipe}.
}
}

If you write a blueprint subclass for \code{\link[=new_xy_blueprint]{new_xy_blueprint()}},
\code{\link[=new_recipe_blueprint]{new_recipe_blueprint()}}, or \code{\link[=new_formula_blueprint]{new_formula_blueprint()}} then your \code{run_mold()}
method signature must match whichever interface listed above will be used.

If you write a completely new blueprint inheriting only from
\code{\link[=new_blueprint]{new_blueprint()}} and write a new \code{\link[=mold]{mold()}} method (because you aren't using
an xy, formula, or recipe interface), then you will have full control over
how \code{run_mold()} will be called.
}
\examples{
bp <- default_xy_blueprint()

outcomes <- mtcars["mpg"]
predictors <- mtcars
predictors$mpg <- NULL

run_mold(bp, x = predictors, y = outcomes)
}
