# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .arm_base_model_py3 import ARMBaseModel


class User(ARMBaseModel):
    """Represents a user who has access to one or more shares on the Data Box
    Edge/Gateway device.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :param encrypted_password: The password details.
    :type encrypted_password:
     ~azure.mgmt.edgegateway.models.AsymmetricEncryptedSecret
    :param share_access_rights: List of shares that the user has rights on.
     This field should not be specified during user creation.
    :type share_access_rights:
     list[~azure.mgmt.edgegateway.models.ShareAccessRight]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'encrypted_password': {'key': 'properties.encryptedPassword', 'type': 'AsymmetricEncryptedSecret'},
        'share_access_rights': {'key': 'properties.shareAccessRights', 'type': '[ShareAccessRight]'},
    }

    def __init__(self, *, encrypted_password=None, share_access_rights=None, **kwargs) -> None:
        super(User, self).__init__(**kwargs)
        self.encrypted_password = encrypted_password
        self.share_access_rights = share_access_rights
