# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.containerservice import ContainerServiceClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestContainerServiceContainerServicesOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ContainerServiceClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list(self, resource_group):
        response = self.client.container_services.list(
            api_version="2017-07-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_create_or_update(self, resource_group):
        response = self.client.container_services.begin_create_or_update(
            resource_group_name=resource_group.name,
            container_service_name="str",
            parameters={
                "location": "str",
                "agentPoolProfiles": [
                    {
                        "name": "str",
                        "vmSize": "str",
                        "count": 1,
                        "dnsPrefix": "str",
                        "fqdn": "str",
                        "osDiskSizeGB": 0,
                        "osType": "Linux",
                        "ports": [0],
                        "storageProfile": "str",
                        "vnetSubnetID": "str",
                    }
                ],
                "customProfile": {"orchestrator": "str"},
                "diagnosticsProfile": {"vmDiagnostics": {"enabled": bool, "storageUri": "str"}},
                "id": "str",
                "linuxProfile": {"adminUsername": "str", "ssh": {"publicKeys": [{"keyData": "str"}]}},
                "masterProfile": {
                    "dnsPrefix": "str",
                    "vmSize": "str",
                    "count": 1,
                    "firstConsecutiveStaticIP": "10.240.255.5",
                    "fqdn": "str",
                    "osDiskSizeGB": 0,
                    "storageProfile": "str",
                    "vnetSubnetID": "str",
                },
                "name": "str",
                "orchestratorProfile": {"orchestratorType": "str", "orchestratorVersion": "str"},
                "provisioningState": "str",
                "servicePrincipalProfile": {
                    "clientId": "str",
                    "keyVaultSecretRef": {"secretName": "str", "vaultID": "str", "version": "str"},
                    "secret": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
                "windowsProfile": {"adminPassword": "str", "adminUsername": "str"},
            },
            api_version="2017-07-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_get(self, resource_group):
        response = self.client.container_services.get(
            resource_group_name=resource_group.name,
            container_service_name="str",
            api_version="2017-07-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_delete(self, resource_group):
        response = self.client.container_services.begin_delete(
            resource_group_name=resource_group.name,
            container_service_name="str",
            api_version="2017-07-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list_by_resource_group(self, resource_group):
        response = self.client.container_services.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2017-07-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
