<?php

declare(strict_types=1);

namespace ProxyManagerTest\ProxyGenerator;

use ProxyManager\Proxy\VirtualProxyInterface;
use ProxyManager\ProxyGenerator\LazyLoadingValueHolderGenerator;
use ProxyManager\ProxyGenerator\ProxyGeneratorInterface;

/**
 * Tests for {@see \ProxyManager\ProxyGenerator\LazyLoadingValueHolderGenerator}
 *
 * @covers \ProxyManager\ProxyGenerator\LazyLoadingValueHolderGenerator
 * @group Coverage
 */
final class LazyLoadingValueHolderGeneratorTest extends AbstractProxyGeneratorTest
{
    protected function getProxyGenerator(): ProxyGeneratorInterface
    {
        return new LazyLoadingValueHolderGenerator();
    }

    /**
     * {@inheritDoc}
     */
    protected function getExpectedImplementedInterfaces(): array
    {
        return [VirtualProxyInterface::class];
    }
}
