// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _OSD_Host_HeaderFile
#define _OSD_Host_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineAlloc.hxx>
#include <Standard_Macro.hxx>

#include <TCollection_AsciiString.hxx>
#include <OSD_Error.hxx>
#include <OSD_SysType.hxx>
#include <Standard_Integer.hxx>
#include <OSD_OEMType.hxx>
#include <Standard_Boolean.hxx>
class Standard_ConstructionError;
class Standard_NullObject;
class OSD_OSDError;
class TCollection_AsciiString;


//! Carries information about a Host
//! System version ,host name, nodename ...
class OSD_Host 
{
public:

  DEFINE_STANDARD_ALLOC

  
  //! Initializes current host by default.
  Standard_EXPORT OSD_Host();
  
  //! Returns system name and version
  Standard_EXPORT   TCollection_AsciiString SystemVersion() ;
  
  //! Returns the system type (UNIX System V, UNIX BSD, MS-DOS...)
  Standard_EXPORT   OSD_SysType SystemId()  const;
  
  //! Returns host name.
  Standard_EXPORT   TCollection_AsciiString HostName() ;
  
  //! Returns available memory in Kilobytes.
  Standard_EXPORT   Standard_Integer AvailableMemory() ;
  
  //! Returns Internet address of current host.
  Standard_EXPORT   TCollection_AsciiString InternetAddress() ;
  
  //! Returns type of current machine.
  Standard_EXPORT   OSD_OEMType MachineType() ;
  
  //! Returns TRUE if an error occurs
  Standard_EXPORT   Standard_Boolean Failed()  const;
  
  //! Resets error counter to zero
  Standard_EXPORT   void Reset() ;
  
  //! Raises OSD_Error
  Standard_EXPORT   void Perror() ;
  
  //! Returns error number if 'Failed' is TRUE.
  Standard_EXPORT   Standard_Integer Error()  const;




protected:





private:



  TCollection_AsciiString myName;
  OSD_Error myError;


};







#endif // _OSD_Host_HeaderFile
