/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.service.component;

import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import javax.servlet.ServletConfig;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.RunData;
import org.chefproject.core.ResourceProperties;
import org.chefproject.core.ResourcePropertiesEdit;
import org.chefproject.core.ToolRegistration;
import org.chefproject.core.component.BaseResourcePropertiesEdit;
import org.chefproject.service.generic.GenericServerConfigurationService;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ChefJetspeedConfigurationService
extends TurbineBaseService
implements GenericServerConfigurationService {
    public void init(ServletConfig config) throws InitializationException {
        super.init(config);
        Log.info("chef", this + ".init(ServletConfig):");
    }

    public void init(RunData data) throws InitializationException {
        super.init(data);
        Log.debug("chef", this + ".init(RunData)");
    }

    public void init() throws InitializationException {
        super.init();
        Log.info("chef", this + ".init()");
    }

    public void shutdown() {
        Log.info("chef", this + ".shutdown()");
        super.shutdown();
    }

    public String getServerId() {
        return this.getString("server.id", "localhost");
    }

    public String getServerName() {
        return this.getString("server.name", "localhost");
    }

    public String getServerUrl() {
        String port = this.getString("server.port", "");
        return this.getString("server.transport", "http") + "://" + this.getServerName() + port + "/" + this.getString("server.path.chef", "chef");
    }

    public String getAccessUrl() {
        return this.getServerUrl() + "/access";
    }

    public String getPortalUrl() {
        return this.getServerUrl() + "/portal";
    }

    public String getLoggedOutUrl() {
        return this.getString("loggedOut.url", this.getPortalUrl());
    }

    public String getString(String name, String dflt) {
        return JetspeedResources.getString((String)name, (String)dflt);
    }

    public boolean getBoolean(String name, boolean dflt) {
        return JetspeedResources.getBoolean((String)name, (boolean)dflt);
    }

    public ToolRegistration getToolRegistration(String id) {
        List tools = this.getToolRegistrations();
        Iterator iTools = tools.iterator();
        while (iTools.hasNext()) {
            ToolRegistration tool = (ToolRegistration)iTools.next();
            if (!id.equals(tool.getId())) continue;
            return tool;
        }
        return null;
    }

    public List getToolRegistrations() {
        Vector<BaseToolRegistration> rv = new Vector<BaseToolRegistration>();
        BaseToolRegistration reg = new BaseToolRegistration("chef.iframe", "Custom Web Page", "Web page that you have added, which can be accessed from a menubar button.");
        reg.m_defaultConfiguration.addProperty("source", "");
        reg.m_defaultConfiguration.addProperty("height", "400px");
        reg.m_defaultConfiguration.addProperty("special", "");
        reg.addCategory("CTNG-course");
        reg.addCategory("CTNG-dissertation");
        reg.addCategory("CTNG-project");
        reg.addCategory("CTNG-workshop");
        rv.add(reg);
        reg = new BaseToolRegistration("chef.memory", "Admin: Memory / Cache Tool", "An administration tool to view the JVM memory and reset the system caches.");
        rv.add(reg);
        reg = new BaseToolRegistration("chef.sites", "Admin: Sites Editor", "An administration tool to edit Sites.");
        rv.add(reg);
        reg = new BaseToolRegistration("chef.realms", "Admin: Realms Editor", "An administration tool to edit Realms.");
        rv.add(reg);
        reg = new BaseToolRegistration("chef.archive", "Admin: Archive Tool", "An administration tool to Archive and Import Sites.");
        rv.add(reg);
        reg = new BaseToolRegistration("chef.users", "Admin: User Editor", "An administration tool to edit Users.");
        rv.add(reg);
        reg = new BaseToolRegistration("chef.synoptic.chat", "Recent Chat Messages", "Display recent chat messages, updated as messages arrive");
        reg.m_defaultConfiguration.addProperty("days", "10");
        reg.m_defaultConfiguration.addProperty("items", "3");
        reg.m_defaultConfiguration.addProperty("length", "50");
        reg.m_defaultConfiguration.addProperty("show-subject", "false");
        reg.m_defaultConfiguration.addProperty("message-service", "org.chefproject.service.generic.GenericChatService");
        reg.m_defaultConfiguration.addProperty("channel", "");
        rv.add(reg);
        reg = new BaseToolRegistration("chef.synoptic.discussion", "Recent Discussion Items", "Display recent discussion items, updated as items arrive");
        reg.m_defaultConfiguration.addProperty("days", "10");
        reg.m_defaultConfiguration.addProperty("items", "3");
        reg.m_defaultConfiguration.addProperty("length", "50");
        reg.m_defaultConfiguration.addProperty("show-subject", "true");
        reg.m_defaultConfiguration.addProperty("message-service", "org.chefproject.service.generic.GenericDiscussionService");
        reg.m_defaultConfiguration.addProperty("channel", "");
        rv.add(reg);
        reg = new BaseToolRegistration("chef.synoptic.announcement", "Recent Announcements", "Display recent announcements, updated as messages arrive");
        reg.m_defaultConfiguration.addProperty("days", "10");
        reg.m_defaultConfiguration.addProperty("items", "3");
        reg.m_defaultConfiguration.addProperty("length", "50");
        reg.m_defaultConfiguration.addProperty("show-subject", "true");
        reg.m_defaultConfiguration.addProperty("message-service", "org.chefproject.service.generic.GenericAnnouncementService");
        reg.m_defaultConfiguration.addProperty("channel", "");
        rv.add(reg);
        reg = new BaseToolRegistration("chef.motd", "Message Of The Day", "Display the system mesage of the day");
        reg.m_defaultConfiguration.addProperty("days", "100");
        reg.m_defaultConfiguration.addProperty("items", "1");
        reg.m_defaultConfiguration.addProperty("length", "50000");
        reg.m_defaultConfiguration.addProperty("show-subject", "false");
        reg.m_defaultConfiguration.addProperty("channel", "/announcement/channel/!site/motd");
        reg.m_defaultConfiguration.addProperty("message-service", "org.chefproject.service.generic.GenericAnnouncementService");
        rv.add(reg);
        reg = new BaseToolRegistration("chef.chat", "Chat", "For real-time conversations in written form.");
        reg.m_defaultConfiguration.addProperty("display-date", "true");
        reg.m_defaultConfiguration.addProperty("display-time", "true");
        reg.m_defaultConfiguration.addProperty("display-user", "true");
        reg.m_defaultConfiguration.addProperty("sound-alert", "true");
        reg.m_defaultConfiguration.addProperty("filter-type", "SelectMessagesByTime");
        reg.m_defaultConfiguration.addProperty("filter-param", "3");
        reg.m_defaultConfiguration.addProperty("channel", "");
        reg.addCategory("CTNG-course");
        reg.addCategory("CTNG-dissertation");
        reg.addCategory("CTNG-project");
        reg.addCategory("CTNG-workshop");
        rv.add(reg);
        reg = new BaseToolRegistration("chef.mailbox", "Email Archive", "Repository for email sent to the worksite email address.");
        reg.m_defaultConfiguration.addProperty("channel", "");
        reg.addCategory("CTNG-course");
        reg.addCategory("CTNG-dissertation");
        reg.addCategory("CTNG-project");
        reg.addCategory("CTNG-workshop");
        rv.add(reg);
        reg = new BaseToolRegistration("chef.resources", "Resources", "For posting documents, URLs to other websites, etc., on the worksite.");
        reg.m_defaultConfiguration.addProperty("resources_mode", "resources");
        reg.m_defaultConfiguration.addProperty("home", "");
        reg.addCategory("CTNG-course");
        reg.addCategory("CTNG-dissertation");
        reg.addCategory("CTNG-project");
        reg.addCategory("CTNG-workshop");
        rv.add(reg);
        reg = new BaseToolRegistration("chef.dropbox", "Drop Box", "Private file area for sharing files between instructors and students.");
        reg.m_defaultConfiguration.addProperty("resources_mode", "dropbox");
        reg.addCategory("CTNG-course");
        reg.addCategory("CTNG-dissertation");
        reg.addCategory("CTNG-project");
        reg.addCategory("CTNG-workshop");
        rv.add(reg);
        reg = new BaseToolRegistration("chef.sitesetup", "Site Setup Wizard", "Modify your sites and create new ones.");
        reg.addCategory("CTNG-workshop");
        rv.add(reg);
        reg = new BaseToolRegistration("chef.schedule", "Schedule", "Online schedule for listing deadlines, events, etc.");
        reg.m_defaultConfiguration.addProperty("calendar", "");
        reg.addCategory("CTNG-course");
        reg.addCategory("CTNG-dissertation");
        reg.addCategory("CTNG-project");
        reg.addCategory("CTNG-workshop");
        rv.add(reg);
        reg = new BaseToolRegistration("chef.announcements", "Announcements", "For posting current, time-critical information on the worksite.");
        reg.m_defaultConfiguration.addProperty("channel", "");
        reg.addCategory("CTNG-course");
        reg.addCategory("CTNG-dissertation");
        reg.addCategory("CTNG-project");
        reg.addCategory("CTNG-workshop");
        rv.add(reg);
        reg = new BaseToolRegistration("chef.discussion", "Discussion (flat)", "For conversations in written form.");
        reg.m_defaultConfiguration.addProperty("category", "false");
        reg.m_defaultConfiguration.addProperty("channel", "");
        rv.add(reg);
        reg = new BaseToolRegistration("chef.assignment", "Assignments", "For assignments that you create, submit, and grade online.");
        reg.addCategory("CTNG-course");
        rv.add(reg);
        reg = new BaseToolRegistration("chef.dissertation", "Dissertation Checklist", "The Dissertation tool.");
        reg.addCategory("CTNG-dissertation");
        rv.add(reg);
        reg = new BaseToolRegistration("chef.membership", "Membership", "View and modify your membership in sites you may join.");
        rv.add(reg);
        reg = new BaseToolRegistration("chef.presence", "Admin: On-Line", "See who's on-line and what they are doing.");
        rv.add(reg);
        reg = new BaseToolRegistration("chef.threadeddiscussion", "Discussion", "For conversations in written form.");
        reg.m_defaultConfiguration.addProperty("category", "false");
        reg.m_defaultConfiguration.addProperty("channel", "");
        reg.addCategory("CTNG-course");
        reg.addCategory("CTNG-dissertation");
        reg.addCategory("CTNG-project");
        reg.addCategory("CTNG-workshop");
        rv.add(reg);
        reg = new BaseToolRegistration("chef.news", "News", "Read topical news from online news sources.");
        reg.m_defaultConfiguration.addProperty("channel-url", "");
        reg.addCategory("CTNG-course");
        reg.addCategory("CTNG-dissertation");
        reg.addCategory("CTNG-project");
        reg.addCategory("CTNG-workshop");
        rv.add(reg);
        reg = new BaseToolRegistration("chef.contactSupport", "Contact Support Form", "For sending comments or questions to support staff.");
        rv.add(reg);
        return rv;
    }

    public List getLocks() {
        Vector<String> rv = new Vector<String>();
        rv.add("annc.new");
        rv.add("annc.read");
        rv.add("annc.revise.any");
        rv.add("annc.revise.own");
        rv.add("annc.delete.any");
        rv.add("annc.delete.own");
        rv.add("annc.read.draft");
        rv.add("asn.read");
        rv.add("asn.new");
        rv.add("asn.revise");
        rv.add("asn.delete");
        rv.add("asn.submit");
        rv.add("calendar.read");
        rv.add("calendar.new");
        rv.add("calendar.delete");
        rv.add("calendar.revise");
        rv.add("chat.new");
        rv.add("chat.read");
        rv.add("chat.revise.any");
        rv.add("chat.revise.own");
        rv.add("chat.delete.any");
        rv.add("chat.delete.own");
        rv.add("content.read");
        rv.add("content.new");
        rv.add("content.revise");
        rv.add("content.delete");
        rv.add("disc.new");
        rv.add("disc.read");
        rv.add("disc.revise.any");
        rv.add("disc.revise.own");
        rv.add("disc.delete.any");
        rv.add("disc.delete.own");
        rv.add("disc.read.draft");
        rv.add("disc.new.topic");
        rv.add("dis.dis.read");
        rv.add("dis.dis.add");
        rv.add("dis.dis.del");
        rv.add("dis.dis.upd");
        rv.add("dis.path.upd");
        rv.add("dis.path.add");
        rv.add("dis.path.read");
        rv.add("dis.path.del");
        rv.add("dis.status.read");
        rv.add("dis.status.upd");
        rv.add("dis.status.add");
        rv.add("dis.status.del");
        rv.add("dis.step.read");
        rv.add("dis.step.add");
        rv.add("dis.step.del");
        rv.add("dis.step.upd");
        rv.add("mail.new");
        rv.add("mail.read");
        rv.add("mail.revise.any");
        rv.add("mail.revise.own");
        rv.add("mail.delete.any");
        rv.add("mail.delete.own");
        rv.add("site.visit");
        rv.add("site.visit.unp");
        rv.add("site.upd");
        rv.add("site.add");
        rv.add("site.del");
        rv.add("user.add");
        rv.add("user.del");
        rv.add("user.upd.any");
        rv.add("user.upd.own");
        rv.add("dropbox.own");
        rv.add("news.new");
        rv.add("news.read");
        rv.add("news.revise.any");
        rv.add("news.revise.own");
        rv.add("news.delete.any");
        rv.add("news.delete.own");
        return rv;
    }

    public class BaseToolRegistration
    implements ToolRegistration {
        protected String m_id = null;
        protected ResourcePropertiesEdit m_properties = null;
        protected ResourcePropertiesEdit m_defaultConfiguration = null;

        public BaseToolRegistration(String id, String title, String description) {
            this.m_id = id;
            this.m_properties = new BaseResourcePropertiesEdit();
            this.m_defaultConfiguration = new BaseResourcePropertiesEdit();
            this.m_properties.addProperty("CHEF:tool-title", title);
            this.m_properties.addProperty("CHEF:tool-description", description);
            this.m_properties.addPropertyToList("CHEF:tool-category", "CHEF");
        }

        public void addCategory(String category) {
            this.m_properties.addPropertyToList("CHEF:tool-category", category);
        }

        public String getId() {
            return this.m_id;
        }

        public String getUrl() {
            return this.m_id;
        }

        public String getReference() {
            return this.m_id;
        }

        public ResourceProperties getProperties() {
            return this.m_properties;
        }

        public Element toXml(Document doc, Stack stack) {
            return null;
        }

        public String getTitle() {
            return this.m_properties.getProperty("CHEF:tool-title");
        }

        public String getDescription() {
            return this.m_properties.getProperty("CHEF:tool-description");
        }

        public List getCategories() {
            return this.m_properties.getPropertyList("CHEF:tool-category");
        }

        public ResourceProperties getDefaultConfiguration() {
            return this.m_defaultConfiguration;
        }

        public int compareTo(Object obj) {
            if (!(obj instanceof ToolRegistration)) {
                throw new ClassCastException();
            }
            if (obj == this) {
                return 0;
            }
            int compare = this.getTitle().compareTo(((ToolRegistration)obj).getTitle());
            return compare;
        }
    }
}

