# Nginx Snippets

## Description
This NGINX Snippets package is catered by Thomas Ward <teward@ubuntu.com> and others.

The idea is to provide snippets which can be installed alongside NGINX configurations in 
the `/etc/nginx/snippets` directory, which can be included in configuration files.

## Included Snippets and Related `conf.d` items:

Currently, the repository is set up to contain the following:

 - TLS configuration snippets (under `/etc/nginx/snippets/tls`)
   - `tls-modern.conf` - configurations based on Mozilla TLS Generator for Modern TLS security
   - `tls-intermediate.conf` - configurations based on Mozilla TLS Generator for Intermediate
   - `tls-intermediate-nodhe.conf` - configurations based on Mozilla TLS Generator for Intermediate
     TLS security, but without DHE-only ciphers, thus not needing a dhparam option.

 - `common-proxy-pass-headers.conf` - configuration of common proxy_pass related headers commonly used with
   reverse proxies
   - Uses map definitions from `conf.d/http-upgrade_req-connection_map.conf` 

## Contributing

Contributions to this repository of commonly-used snippets is welcome. They must be provided as pull requests 
against this repository complete with descriptions off what they contain, why they should be included in this 
repository / package, and how they benefit other users as part of this package.

## Debian Guidelines

This package is a `3.0 (native)` formatted package, and thus a Debian native package.  It is INTENDED to be 
used alongside the `nginx` binaries in Debian to provide useful snippets for easy inclusion into NGINX 
configuration files, and is not intended to be used outside of the Debian-flavored NGINX packaging and 
configuration setup.

The initial version of this will be `1.0`, any additional changes should have a minor version increase.

## Primary Maintainer

The primary maintaner of this package is Thomas Ward <teward@ubuntu.com>. All contributions are welcome and 
will be reviewed.

## License

Except where otherwise specified, all components of this repository are licensed under the GNU General Public 
License 3.0.