# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.writer import Writer


class OBJWriter(Writer):
    r"""
    OBJWriter - write wavefront obj file
    
    Superclass: Writer
    
    OBJWriter writes wavefront obj (.obj) files in ASCII form. OBJ
    files contain the geometry including lines, triangles and polygons.
    Normals and texture coordinates on points are also written if they
    exist. One can specify a texture passing a ImageData on port 1. If
    a texture is set, additionals .mtl and .png files are generated.
    Those files have the same name without obj extension. Alternatively,
    one can specify a texture_file_name pointing to an existing texture. In
    this case a .mtl file is generated pointing to the specified file.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkOBJWriter, obj, update, **traits)
    
    file_name = tvtk_base.vtk_file_name("", desc=\
        r"""
        Get/Set the file name of the OBJ file.
        """
    )

    def _file_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFileName,
                        self.file_name)

    texture_file_name = tvtk_base.vtk_file_name("", desc=\
        r"""
        Get/Set the path to an existing texture file for the OBJ. If this
        is set, the writer will generate mtllib, usemtl lines and a .mtl
        file that points to the existing texture file.
        """
    )

    def _texture_file_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetTextureFileName,
                        self.texture_file_name)

    def _get_input(self):
        return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input, desc=\
        r"""
        Set/get the input to this writer.
        """
    )

    def _get_input_geometry(self):
        return wrap_vtk(self._vtk_obj.GetInputGeometry())
    input_geometry = traits.Property(_get_input_geometry, desc=\
        r"""
        Get the inputs to this writer.
        """
    )

    def _get_input_texture(self):
        return wrap_vtk(self._vtk_obj.GetInputTexture())
    input_texture = traits.Property(_get_input_texture, desc=\
        r"""
        
        """
    )

    _updateable_traits_ = \
    (('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('file_name',
    'GetFileName'), ('texture_file_name', 'GetTextureFileName'),
    ('progress_text', 'GetProgressText'), ('object_name',
    'GetObjectName'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'file_name', 'object_name', 'progress_text',
    'texture_file_name'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(OBJWriter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit OBJWriter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['file_name', 'object_name', 'texture_file_name']),
            title='Edit OBJWriter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit OBJWriter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

