/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * Allows you to organize numeric values in a source data column into buckets of constant size.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ChartHistogramRule extends com.google.api.client.json.GenericJson {

  /**
   * The size of the buckets that are created. Must be positive.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double intervalSize;

  /**
   * The maximum value at which items are placed into buckets. Values greater than the maximum are
   * grouped into a single bucket. If omitted, it is determined by the maximum item value.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double maxValue;

  /**
   * The minimum value at which items are placed into buckets. Values that are less than the minimum
   * are grouped into a single bucket. If omitted, it is determined by the minimum item value.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double minValue;

  /**
   * The size of the buckets that are created. Must be positive.
   * @return value or {@code null} for none
   */
  public java.lang.Double getIntervalSize() {
    return intervalSize;
  }

  /**
   * The size of the buckets that are created. Must be positive.
   * @param intervalSize intervalSize or {@code null} for none
   */
  public ChartHistogramRule setIntervalSize(java.lang.Double intervalSize) {
    this.intervalSize = intervalSize;
    return this;
  }

  /**
   * The maximum value at which items are placed into buckets. Values greater than the maximum are
   * grouped into a single bucket. If omitted, it is determined by the maximum item value.
   * @return value or {@code null} for none
   */
  public java.lang.Double getMaxValue() {
    return maxValue;
  }

  /**
   * The maximum value at which items are placed into buckets. Values greater than the maximum are
   * grouped into a single bucket. If omitted, it is determined by the maximum item value.
   * @param maxValue maxValue or {@code null} for none
   */
  public ChartHistogramRule setMaxValue(java.lang.Double maxValue) {
    this.maxValue = maxValue;
    return this;
  }

  /**
   * The minimum value at which items are placed into buckets. Values that are less than the minimum
   * are grouped into a single bucket. If omitted, it is determined by the minimum item value.
   * @return value or {@code null} for none
   */
  public java.lang.Double getMinValue() {
    return minValue;
  }

  /**
   * The minimum value at which items are placed into buckets. Values that are less than the minimum
   * are grouped into a single bucket. If omitted, it is determined by the minimum item value.
   * @param minValue minValue or {@code null} for none
   */
  public ChartHistogramRule setMinValue(java.lang.Double minValue) {
    this.minValue = minValue;
    return this;
  }

  @Override
  public ChartHistogramRule set(String fieldName, Object value) {
    return (ChartHistogramRule) super.set(fieldName, value);
  }

  @Override
  public ChartHistogramRule clone() {
    return (ChartHistogramRule) super.clone();
  }

}
