/*
// $Id: //open/dev/farrago/src/org/eigenbase/rel/convert/TraitMatchingRule.java#10 $
// Package org.eigenbase is a class library of data management components.
// Copyright (C) 2006-2009 The Eigenbase Project
// Copyright (C) 2006-2009 SQLstream, Inc.
// Copyright (C) 2006-2009 LucidEra, Inc.
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 of the License, or (at your option)
// any later version approved by The Eigenbase Project.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
package org.eigenbase.rel.convert;

import org.eigenbase.rel.*;
import org.eigenbase.relopt.*;


/**
 * TraitMatchingRule adapts a converter rule, restricting it to fire only when
 * its input already matches the expected output trait. This can be used with
 * {@link org.eigenbase.relopt.hep.HepPlanner} in cases where alternate
 * implementations are available and it is desirable to minimize converters.
 *
 * @author John V. Sichi
 * @version $Id: //open/dev/farrago/src/org/eigenbase/rel/convert/TraitMatchingRule.java#10 $
 */
public class TraitMatchingRule
    extends RelOptRule
{
    //~ Instance fields --------------------------------------------------------

    private final ConverterRule converter;

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates a new TraitMatchingRule.
     *
     * @param converterRule rule to be restricted; rule must take a single
     * operand expecting a single input
     */
    public TraitMatchingRule(ConverterRule converterRule)
    {
        super(
            new RelOptRuleOperand(
                converterRule.getOperand().getMatchedClass(),
                new RelOptRuleOperand(
                    RelNode.class,
                    ANY)),
            "TraitMatchingRule: " + converterRule);
        assert (converterRule.getOperand().getChildOperands() == null);
        this.converter = converterRule;
    }

    //~ Methods ----------------------------------------------------------------

    // implement RelOptRule
    public CallingConvention getOutConvention()
    {
        return converter.getOutConvention();
    }

    public void onMatch(RelOptRuleCall call)
    {
        RelNode input = call.rels[1];
        if (input.getTraits().contains(converter.getOutTrait())) {
            converter.onMatch(call);
        }
    }
}

// End TraitMatchingRule.java
