# packages/lorsm/www/md/generalmd.tcl

ad_page_contract {
    Displays/Adds IMS Metadata General

    @author Ernie Ghiglione (ErnieG@mm.st)
    @creation-date 19 January 2004
    @cvs-id $Id: generalmd.tcl,v 1.4 2008/12/12 14:25:37 juanf Exp $

} {
    ims_md_id:integer
}

# set context & title
set context [list \
                [list   [export_vars -base "." ims_md_id] \
                        "[_ lorsm.IMS_Metadata_Editor]"]  \
                        "[_ lorsm.General_MD]"]

set title "[_ lorsm.General_MD]"

# General Title
template::list::create \
    -name d_gen_titles \
    -multirow d_gen_titles \
    -no_data "[_ lorsm.No_Titles_Available]" \
    -actions [list  "[_ lorsm.Add_Title]" \
                    [export_vars -base generalmd/general_title {ims_md_id}] \
                    "[_ lorsm.Add_another_title]"] \
    -html { style "width: 100%; align: right" } \
    -elements {
        title_l { label "" }
        title_s { label "" }
    }
db_multirow d_gen_titles select_ge_titles {} {
    set item_url [export_vars -base "item" { ims_md_id }]
}

# General Description
template::list::create \
    -name d_gen_desc \
    -multirow d_gen_desc \
    -no_data "[_ lorsm.lt_No_Description_Availa]" \
    -actions [list  "[_ lorsm.Add_Description]" \
                    [export_vars -base generalmd/general_desc {ims_md_id}] \
                    "[_ lorsm.lt_Add_another_Descripti]"] \
    -html { style "width: 100%; align: right;" } \
    -elements {
        descrip_l { label "" }
        descrip_s { label "" }
    }
db_multirow d_gen_desc select_ge_desc {}

# General Catalog-entry
template::list::create \
    -name d_gen_cata \
    -multirow d_gen_cata \
    -no_data "[_ lorsm.lt_No_Catalog_Entry_Avai]" \
    -actions [list  "[_ lorsm.Add_Catalog-Entry]" \
                    [export_vars -base generalmd/general_cata {ims_md_id}] \
                    "[_ lorsm.lt_Add_another_Catalog-E]"] \
    -html { style "width: 100%; align: right;" } \
    -elements {
        catalog { label "" }
        entry_l { label "" }
        entry_s { label "" }
    }
db_multirow d_gen_cata select_ge_cata {}



# General Language
template::list::create \
    -name d_gen_lang \
    -multirow d_gen_lang \
    -no_data "[_ lorsm.lt_No_Language_Available]" \
    -actions [list  "[_ lorsm.Add_Language]"  \
                    [export_vars -base generalmd/general_lang {ims_md_id}] \
                    "[_ lorsm.Add_another_Language]"] \
    -html { style "width: 100%; align:right;" } \
    -elements {
        language { label "" }
    }
db_multirow d_gen_lang select_ge_lang {}

# General Keywords
template::list::create \
    -name d_gen_key \
    -multirow d_gen_key \
    -no_data "[_ lorsm.lt_No_Keywords_Available]" \
    -actions [list  "[_ lorsm.Add_Keywords]" \
                    [export_vars -base generalmd/general_key {ims_md_id}] \
                    "[_ lorsm.Add_another_Keywords]"] \
    -html { style "width: 100%; align:right" } \
    -elements {
        keyword_l { label "" }
        keyword_s { label "" }
    }
db_multirow d_gen_key select_ge_key {}

# General Coverage
template::list::create \
    -name d_gen_cover \
    -multirow d_gen_cover \
    -no_data "[_ lorsm.lt_No_Coverage_Available]" \
    -actions [list  "[_ lorsm.Add_Coverage]" \
                    [export_vars -base generalmd/general_cover {ims_md_id}] \
                    "[_ lorsm.Add_another_Coverage]"] \
    -html { style "width: 100%; align:right;" } \
    -elements {
        cover_l { label "" }
        cover_s { label "" }
    }
db_multirow d_gen_cover select_ge_cover {}

# General Structure
template::list::create \
    -name d_gen_struc \
    -multirow d_gen_struc \
    -no_data "[_ lorsm.lt_No_Structure_Availabl]" \
    -actions [list  "[_ lorsm.Add_Structure]" \
                    [export_vars -base generalmd/general_struc {ims_md_id}] \
                    "[_ lorsm.lt_Add_another_Structure]"] \
    -html { style "width: 100%; align:right;" } \
    -elements {
        structure_s { label "" }
        structure_v { label "" }
    }
db_multirow d_gen_struc select_ge_struc {}


# General Aggregation level
template::list::create \
    -name d_gen_aggl \
    -multirow d_gen_aggl \
    -no_data "[_ lorsm.lt_No_Aggregation_Level_]" \
    -actions [list  "[_ lorsm.lt_Add_Aggregation_Level]" \
                    [export_vars -base generalmd/general_aggl {ims_md_id}] \
                    "[_ lorsm.lt_Add_another_Aggregati]"] \
    -html { style "width: 100%; align: right;" } \
    -elements {
        agg_level_s { label "" }
        agg_level_v { label "" }
    }
db_multirow d_gen_aggl select_ge_aggl {}
