/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 16:51:40 GMT 2018
 */

package uk.ac.sanger.artemis.util;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.System;
import org.evosuite.runtime.mock.java.io.MockFile;
import org.evosuite.runtime.mock.java.time.chrono.MockJapaneseDate;
import org.evosuite.runtime.mock.java.time.chrono.MockMinguoDate;
import org.evosuite.runtime.testdata.FileSystemHandling;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.util.Document;
import uk.ac.sanger.artemis.util.FileDocument;
import uk.ac.sanger.artemis.util.InputStreamProgressListener;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class FileDocument_ESTest extends FileDocument_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      MockFile mockFile0 = new MockFile("Method not implemented for: ");
      FileDocument fileDocument0 = new FileDocument(mockFile0);
      FileSystemHandling.shouldAllThrowIOExceptions();
      Document document0 = fileDocument0.getParent();
      assertNull(document0);
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      MockFile mockFile0 = new MockFile("", "");
      FileDocument fileDocument0 = new FileDocument(mockFile0);
      String string0 = fileDocument0.getName();
      assertEquals("", string0);
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      MockFile mockFile0 = new MockFile("K.gz", "K.gz");
      FileDocument fileDocument0 = new FileDocument(mockFile0);
      System.setCurrentTimeMillis((-247L));
      fileDocument0.getOutputStream();
      File file0 = fileDocument0.getFile();
      assertSame(file0, mockFile0);
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      MockFile mockFile0 = new MockFile("");
      FileDocument fileDocument0 = new FileDocument(mockFile0);
      File file0 = fileDocument0.getFile();
      assertEquals("", file0.toString());
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      MockFile mockFile0 = new MockFile(".gz", ".gz");
      FileDocument fileDocument0 = new FileDocument(mockFile0);
      fileDocument0.getWriter();
      File file0 = fileDocument0.getFile();
      assertFalse(file0.isDirectory());
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      MockFile mockFile0 = new MockFile("05[m)36;c|d");
      FileDocument fileDocument0 = new FileDocument(mockFile0);
      MockMinguoDate mockMinguoDate0 = new MockMinguoDate();
      fileDocument0.setLocation(mockMinguoDate0);
      // Undeclared exception!
      try { 
        fileDocument0.writable();
        fail("Expecting exception: ClassCastException");
      
      } catch(ClassCastException e) {
         //
         // org.evosuite.runtime.mock.java.time.chrono.MockMinguoDate cannot be cast to java.io.File
         //
         verifyException("uk.ac.sanger.artemis.util.FileDocument", e);
      }
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      MockFile mockFile0 = new MockFile(",", "");
      FileDocument fileDocument0 = new FileDocument(mockFile0);
      Object object0 = new Object();
      fileDocument0.setLocation(object0);
      // Undeclared exception!
      try { 
        fileDocument0.readable();
        fail("Expecting exception: ClassCastException");
      
      } catch(ClassCastException e) {
         //
         // java.lang.Object cannot be cast to java.io.File
         //
         verifyException("uk.ac.sanger.artemis.util.FileDocument", e);
      }
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      MockFile mockFile0 = new MockFile("", "");
      FileDocument fileDocument0 = new FileDocument(mockFile0);
      // Undeclared exception!
      try { 
        fileDocument0.getParent();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.io.File", e);
      }
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      MockFile mockFile0 = new MockFile("alt name cannot be null", "alt name cannot be null");
      FileDocument fileDocument0 = new FileDocument(mockFile0);
      MockJapaneseDate mockJapaneseDate0 = new MockJapaneseDate();
      fileDocument0.setLocation(mockJapaneseDate0);
      // Undeclared exception!
      try { 
        fileDocument0.getParent();
        fail("Expecting exception: ClassCastException");
      
      } catch(ClassCastException e) {
         //
         // org.evosuite.runtime.mock.java.time.chrono.MockJapaneseDate cannot be cast to java.io.File
         //
         verifyException("uk.ac.sanger.artemis.util.FileDocument", e);
      }
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      MockFile mockFile0 = new MockFile("The size must be non-negative", "3@B`|Z");
      FileDocument fileDocument0 = new FileDocument(mockFile0);
      fileDocument0.setLocation((Object) null);
      // Undeclared exception!
      try { 
        fileDocument0.getOutputStream();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.io.File", e);
      }
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      MockFile mockFile0 = new MockFile("l-% d3xAskEo94t['", ":'\"[twU,j6t~IO");
      FileDocument fileDocument0 = new FileDocument(mockFile0);
      fileDocument0.setLocation(":'\"[twU,j6t~IO");
      // Undeclared exception!
      try { 
        fileDocument0.getOutputStream();
        fail("Expecting exception: ClassCastException");
      
      } catch(ClassCastException e) {
         //
         // java.lang.String cannot be cast to java.io.File
         //
         verifyException("uk.ac.sanger.artemis.util.FileDocument", e);
      }
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      MockFile mockFile0 = new MockFile(".gz");
      FileSystemHandling.shouldAllThrowIOExceptions();
      FileDocument fileDocument0 = new FileDocument(mockFile0);
      try { 
        fileDocument0.getOutputStream();
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // Simulated IOException
         //
         verifyException("org.evosuite.runtime.vfs.VirtualFileSystem", e);
      }
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      MockFile mockFile0 = new MockFile("S2n~/2h`52XU8=>2mo");
      MockFile.createTempFile("S2n~/2h`52XU8=>2mo", "^#1'a4T/4Q`o5[<", (File) mockFile0);
      FileDocument fileDocument0 = new FileDocument(mockFile0);
      try { 
        fileDocument0.getOutputStream();
        fail("Expecting exception: FileNotFoundException");
      
      } catch(FileNotFoundException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("org.evosuite.runtime.mock.java.io.MockFileOutputStream", e);
      }
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      MockFile mockFile0 = new MockFile("E&r`NOLY4Gm/i3-<", "E&r`NOLY4Gm/i3-<");
      FileDocument fileDocument0 = new FileDocument(mockFile0);
      fileDocument0.setLocation(fileDocument0);
      // Undeclared exception!
      try { 
        fileDocument0.getName();
        fail("Expecting exception: ClassCastException");
      
      } catch(ClassCastException e) {
         //
         // uk.ac.sanger.artemis.util.FileDocument cannot be cast to java.io.File
         //
         verifyException("uk.ac.sanger.artemis.util.FileDocument", e);
      }
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      MockFile mockFile0 = new MockFile(".gz", ".gz");
      FileDocument fileDocument0 = new FileDocument(mockFile0);
      fileDocument0.getWriter();
      fileDocument0.addInputStreamProgressListener((InputStreamProgressListener) null);
      // Undeclared exception!
      try { 
        fileDocument0.getInputStream();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.util.ProgressInputStream", e);
      }
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      File file0 = MockFile.createTempFile("j)Ry4uZJEUJi5@s;.5", "j)Ry4uZJEUJi5@s;.5");
      FileDocument fileDocument0 = new FileDocument(file0);
      fileDocument0.setLocation("j)Ry4uZJEUJi5@s;.5");
      // Undeclared exception!
      try { 
        fileDocument0.getInputStream();
        fail("Expecting exception: ClassCastException");
      
      } catch(ClassCastException e) {
         //
         // java.lang.String cannot be cast to java.io.File
         //
         verifyException("uk.ac.sanger.artemis.util.FileDocument", e);
      }
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      MockFile mockFile0 = new MockFile(".gz", ".gz");
      FileDocument fileDocument0 = new FileDocument(mockFile0);
      fileDocument0.getWriter();
      FileSystemHandling.shouldAllThrowIOExceptions();
      try { 
        fileDocument0.getInputStream();
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // Simulated IOException
         //
         verifyException("org.evosuite.runtime.vfs.VirtualFileSystem", e);
      }
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      MockFile mockFile0 = new MockFile("");
      FileDocument fileDocument0 = new FileDocument(mockFile0);
      try { 
        fileDocument0.getInputStream();
        fail("Expecting exception: FileNotFoundException");
      
      } catch(FileNotFoundException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("org.evosuite.runtime.mock.java.io.MockFileInputStream", e);
      }
  }

  @Test(timeout = 4000)
  public void test18()  throws Throwable  {
      File file0 = MockFile.createTempFile("SB5..gz", "SB5..gz");
      FileDocument fileDocument0 = new FileDocument(file0);
      try { 
        fileDocument0.getInputStream();
        fail("Expecting exception: EOFException");
      
      } catch(EOFException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.util.zip.GZIPInputStream", e);
      }
  }

  @Test(timeout = 4000)
  public void test19()  throws Throwable  {
      MockFile mockFile0 = new MockFile("MZT$~\":U", "MZT$~\":U");
      FileDocument fileDocument0 = new FileDocument(mockFile0);
      Path path0 = mockFile0.toPath();
      fileDocument0.setLocation(path0);
      // Undeclared exception!
      try { 
        fileDocument0.getFile();
        fail("Expecting exception: ClassCastException");
      
      } catch(ClassCastException e) {
         //
         // sun.nio.fs.UnixPath cannot be cast to java.io.File
         //
         verifyException("uk.ac.sanger.artemis.util.FileDocument", e);
      }
  }

  @Test(timeout = 4000)
  public void test20()  throws Throwable  {
      MockFile mockFile0 = new MockFile(".gz");
      FileDocument fileDocument0 = new FileDocument(mockFile0);
      // Undeclared exception!
      try { 
        fileDocument0.append((String) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("org.evosuite.runtime.mock.java.io.MockFile", e);
      }
  }

  @Test(timeout = 4000)
  public void test21()  throws Throwable  {
      MockFile mockFile0 = new MockFile("", "");
      FileDocument fileDocument0 = new FileDocument(mockFile0);
      Object object0 = new Object();
      fileDocument0.setLocation(object0);
      // Undeclared exception!
      try { 
        fileDocument0.append("");
        fail("Expecting exception: ClassCastException");
      
      } catch(ClassCastException e) {
         //
         // java.lang.Object cannot be cast to java.io.File
         //
         verifyException("uk.ac.sanger.artemis.util.FileDocument", e);
      }
  }

  @Test(timeout = 4000)
  public void test22()  throws Throwable  {
      FileDocument fileDocument0 = null;
      try {
        fileDocument0 = new FileDocument((File) null);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - created a null Document
         //
         verifyException("uk.ac.sanger.artemis.util.Document", e);
      }
  }

  @Test(timeout = 4000)
  public void test23()  throws Throwable  {
      MockFile mockFile0 = new MockFile("1lb@a[iYp{g0gm");
      FileDocument fileDocument0 = new FileDocument(mockFile0);
      fileDocument0.getOutputStream();
      assertEquals(0L, mockFile0.length());
  }

  @Test(timeout = 4000)
  public void test24()  throws Throwable  {
      MockFile mockFile0 = new MockFile(".gz", ".gz");
      FileDocument fileDocument0 = new FileDocument(mockFile0);
      File file0 = fileDocument0.getFile();
      assertEquals(java.lang.System.getProperty("user.dir") + "/.gz/.gz", file0.toString());
  }

  @Test(timeout = 4000)
  public void test25()  throws Throwable  {
      MockFile mockFile0 = new MockFile(".gz", ".gz");
      FileDocument fileDocument0 = new FileDocument(mockFile0);
      fileDocument0.getWriter();
      InputStream inputStream0 = fileDocument0.getInputStream();
      assertNotNull(inputStream0);
  }

  @Test(timeout = 4000)
  public void test26()  throws Throwable  {
      MockFile mockFile0 = new MockFile("Method not implemented for: ");
      FileDocument fileDocument0 = new FileDocument(mockFile0);
      mockFile0.createNewFile();
      InputStream inputStream0 = fileDocument0.getInputStream();
      assertNotNull(inputStream0);
  }

  @Test(timeout = 4000)
  public void test27()  throws Throwable  {
      MockFile mockFile0 = new MockFile("K", "K");
      FileDocument fileDocument0 = new FileDocument(mockFile0);
      fileDocument0.getWriter();
      assertTrue(fileDocument0.writable());
      
      mockFile0.setWritable(false, false);
      boolean boolean0 = fileDocument0.writable();
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test28()  throws Throwable  {
      MockFile mockFile0 = new MockFile(".gz", ".gz");
      FileDocument fileDocument0 = new FileDocument(mockFile0);
      fileDocument0.getWriter();
      boolean boolean0 = fileDocument0.writable();
      assertEquals(10L, mockFile0.length());
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test29()  throws Throwable  {
      MockFile mockFile0 = new MockFile("K", "K");
      FileDocument fileDocument0 = new FileDocument(mockFile0);
      boolean boolean0 = fileDocument0.writable();
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test30()  throws Throwable  {
      MockFile mockFile0 = new MockFile("05[m)36;c|d");
      FileDocument fileDocument0 = new FileDocument(mockFile0);
      fileDocument0.getWriter();
      assertTrue(fileDocument0.readable());
      
      mockFile0.setReadable(false);
      boolean boolean0 = fileDocument0.readable();
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test31()  throws Throwable  {
      MockFile mockFile0 = new MockFile(".gz", ".gz");
      FileDocument fileDocument0 = new FileDocument(mockFile0);
      fileDocument0.getWriter();
      boolean boolean0 = fileDocument0.readable();
      assertEquals(10L, mockFile0.length());
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test32()  throws Throwable  {
      MockFile mockFile0 = new MockFile(".gz", ".gz");
      FileDocument fileDocument0 = new FileDocument(mockFile0);
      boolean boolean0 = fileDocument0.readable();
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test33()  throws Throwable  {
      MockFile mockFile0 = new MockFile("Method not implemented for: ");
      FileDocument fileDocument0 = new FileDocument(mockFile0);
      String string0 = fileDocument0.getName();
      assertEquals("Method not implemented for: ", string0);
  }

  @Test(timeout = 4000)
  public void test34()  throws Throwable  {
      MockFile mockFile0 = new MockFile("K.gz", "K.gz");
      FileDocument fileDocument0 = new FileDocument(mockFile0);
      Document document0 = fileDocument0.append("K.gz");
      assertFalse(document0.equals((Object)fileDocument0));
  }

  @Test(timeout = 4000)
  public void test35()  throws Throwable  {
      MockFile mockFile0 = new MockFile("Method not implemented for: ");
      FileDocument fileDocument0 = new FileDocument(mockFile0);
      Document document0 = fileDocument0.getParent();
      assertTrue(document0.writable());
  }
}
