// -----------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All rights reserved.
// -----------------------------------------------------------------------
using System;
using System.Diagnostics.CodeAnalysis;

// The following are untriaged violations, do not add to this list unless you hit a bug in Code Analysis. Any explicitly 
// suppressed violations should either be applied against the member or type itself, or if raised against a namespace, 
// resource or assembly, placed in SuppressMessages.cs.

// Code Analysis Bug: ValidateArgumentsOfPublicMethods should not fire on protected members
[module: SuppressMessage("Microsoft.Design", "CA1062:Validate arguments of public methods", MessageId = "0", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ComposablePartExportProvider.#GetExportsCore(System.ComponentModel.Composition.Primitives.ImportDefinition,System.ComponentModel.Composition.Hosting.AtomicComposition)")]
[module: SuppressMessage("Microsoft.Design", "CA1062:Validate arguments of public methods", MessageId = "0", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.AggregateExportProvider.#GetExportsCore(System.ComponentModel.Composition.Primitives.ImportDefinition,System.ComponentModel.Composition.Hosting.AtomicComposition)")]

// Code Analysis Bug: ValidateArgumentsOfPublicMethods should not fire on usage of Requires.NotNull
[module: SuppressMessage("Microsoft.Design", "CA1062:Validate arguments of public methods", MessageId = "0", Scope = "member", Target = "System.ComponentModel.Composition.AttributedModelServices.#AddExportedValue`1(System.ComponentModel.Composition.Hosting.CompositionBatch,System.String,!!0)")]
[module: SuppressMessage("Microsoft.Design", "CA1062:Validate arguments of public methods", MessageId = "0", Scope = "member", Target = "System.ComponentModel.Composition.AttributedModelServices.#AddPart(System.ComponentModel.Composition.Hosting.CompositionBatch,System.Object)")]
[module: SuppressMessage("Microsoft.Design", "CA1062:Validate arguments of public methods", MessageId = "0", Scope = "member", Target = "System.ComponentModel.Composition.AttributedModelServices.#ComposeExportedValue`1(System.ComponentModel.Composition.Hosting.CompositionContainer,System.String,!!0)")]
[module: SuppressMessage("Microsoft.Design", "CA1062:Validate arguments of public methods", MessageId = "0", Scope = "member", Target = "System.ComponentModel.Composition.AttributedModelServices.#ComposeExportedValue`1(System.ComponentModel.Composition.Hosting.CompositionContainer,!!0)")]
[module: SuppressMessage("Microsoft.Design", "CA1062:Validate arguments of public methods", MessageId = "0", Scope = "member", Target = "System.ComponentModel.Composition.AttributedModelServices.#ComposeParts(System.ComponentModel.Composition.Hosting.CompositionContainer,System.Object[])")]
[module: SuppressMessage("Microsoft.Design", "CA1062:Validate arguments of public methods", MessageId = "0", Scope = "member", Target = "System.ComponentModel.Composition.AttributedModelServices.#SatisfyImportsOnce(System.ComponentModel.Composition.ICompositionService,System.Object)")]
[module: SuppressMessage("Microsoft.Design", "CA1062:Validate arguments of public methods", MessageId = "0", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.CatalogExportProvider+CatalogChangeProxy.#GetExports(System.ComponentModel.Composition.Primitives.ImportDefinition)")]
[module: SuppressMessage("Microsoft.Design", "CA1062:Validate arguments of public methods", MessageId = "0", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.CatalogExportProvider.#SourceProvider")]
[module: SuppressMessage("Microsoft.Design", "CA1062:Validate arguments of public methods", MessageId = "0", Scope = "member", Target = "System.ComponentModel.Composition.Primitives.ComposablePartCatalog.#GetExports(System.ComponentModel.Composition.Primitives.ImportDefinition)")]
[module: SuppressMessage("Microsoft.Design", "CA1062:Validate arguments of public methods", MessageId = "0", Scope = "member", Target = "System.ComponentModel.Composition.Primitives.ComposablePartException.#GetObjectData(System.Runtime.Serialization.SerializationInfo,System.Runtime.Serialization.StreamingContext)")]
[module: SuppressMessage("Microsoft.Design", "CA1062:Validate arguments of public methods", MessageId = "0", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ComposablePartExportProvider.#Compose(System.ComponentModel.Composition.Hosting.CompositionBatch)")]
[module: SuppressMessage("Microsoft.Design", "CA1062:Validate arguments of public methods", MessageId = "0", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.CompositionContainer.#ReleaseExports(System.Collections.Generic.IEnumerable`1<System.ComponentModel.Composition.Primitives.Export>)")]
[module: SuppressMessage("Microsoft.Design", "CA1062:Validate arguments of public methods", MessageId = "0", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.CompositionContainer.#ReleaseExports`2(System.Collections.Generic.IEnumerable`1<System.Lazy`2<!!0,!!1>>)")]
[module: SuppressMessage("Microsoft.Design", "CA1062:Validate arguments of public methods", MessageId = "0", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.CompositionContainer.#ReleaseExports`1(System.Collections.Generic.IEnumerable`1<System.Lazy`1<!!0>>)")]
[module: SuppressMessage("Microsoft.Design", "CA1062:Validate arguments of public methods", MessageId = "0", Scope = "member", Target = "System.ComponentModel.Composition.CompositionError.#.ctor(System.Runtime.Serialization.SerializationInfo,System.Runtime.Serialization.StreamingContext)")]
[module: SuppressMessage("Microsoft.Design", "CA1062:Validate arguments of public methods", MessageId = "0", Scope = "member", Target = "System.ComponentModel.Composition.CompositionError.#GetObjectData(System.Runtime.Serialization.SerializationInfo,System.Runtime.Serialization.StreamingContext)")]
[module: SuppressMessage("Microsoft.Design", "CA1062:Validate arguments of public methods", MessageId = "0", Scope = "member", Target = "System.ComponentModel.Composition.CompositionException.#GetObjectData(System.Runtime.Serialization.SerializationInfo,System.Runtime.Serialization.StreamingContext)")]
[module: SuppressMessage("Microsoft.Design", "CA1062:Validate arguments of public methods", MessageId = "0", Scope = "member", Target = "System.ComponentModel.Composition.Primitives.ContractBasedImportDefinition.#IsConstraintSatisfiedBy(System.ComponentModel.Composition.Primitives.ExportDefinition)")]
[module: SuppressMessage("Microsoft.Design", "CA1062:Validate arguments of public methods", MessageId = "0", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ExportProvider.#GetExports(System.ComponentModel.Composition.Primitives.ImportDefinition,System.ComponentModel.Composition.Hosting.AtomicComposition)")]
[module: SuppressMessage("Microsoft.Design", "CA1062:Validate arguments of public methods", MessageId = "0", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ExportProvider.#OnExportsChanged(System.ComponentModel.Composition.Hosting.ExportsChangeEventArgs)")]
[module: SuppressMessage("Microsoft.Design", "CA1062:Validate arguments of public methods", MessageId = "0", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ExportProvider.#OnExportsChanging(System.ComponentModel.Composition.Hosting.ExportsChangeEventArgs)")]
[module: SuppressMessage("Microsoft.Design", "CA1062:Validate arguments of public methods", MessageId = "0", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ImportEngine.#.ctor(System.ComponentModel.Composition.Hosting.ExportProvider,System.Boolean)")]
[module: SuppressMessage("Microsoft.Design", "CA1062:Validate arguments of public methods", MessageId = "0", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.LazyMemberInfo.#.ctor(System.Reflection.MemberInfo)")]
[module: SuppressMessage("Microsoft.Design", "CA1062:Validate arguments of public methods", MessageId = "0", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ReflectionModelServices.#GetExportingMember(System.ComponentModel.Composition.Primitives.ExportDefinition)")]
[module: SuppressMessage("Microsoft.Design", "CA1062:Validate arguments of public methods", MessageId = "0", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ReflectionModelServices.#GetImportingMember(System.ComponentModel.Composition.Primitives.ImportDefinition)")]
[module: SuppressMessage("Microsoft.Design", "CA1062:Validate arguments of public methods", MessageId = "0", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ReflectionModelServices.#GetImportingParameter(System.ComponentModel.Composition.Primitives.ImportDefinition)")]
[module: SuppressMessage("Microsoft.Design", "CA1062:Validate arguments of public methods", MessageId = "0", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ReflectionModelServices.#GetPartType(System.ComponentModel.Composition.Primitives.ComposablePartDefinition)")]
[module: SuppressMessage("Microsoft.Design", "CA1062:Validate arguments of public methods", MessageId = "0", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ReflectionModelServices.#IsDisposalRequired(System.ComponentModel.Composition.Primitives.ComposablePartDefinition)")]
[module: SuppressMessage("Microsoft.Design", "CA1062:Validate arguments of public methods", MessageId = "0", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ReflectionModelServices.#IsImportingParameter(System.ComponentModel.Composition.Primitives.ImportDefinition)")]
[module: SuppressMessage("Microsoft.Design", "CA1062:Validate arguments of public methods", MessageId = "0", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.TypeCatalog.#GetExports(System.ComponentModel.Composition.Primitives.ImportDefinition)")]

// DevDiv 10: 583413 AsmMeta: No longer finds APTCA bit on assemblies 
[module: SuppressMessage("Microsoft.Security", "CA2117:AptcaTypesShouldOnlyExtendAptcaBaseTypes", Scope = "type", Target = "System.Lazy`2", Justification = "Razzle mscorlib is not APTCA")]
[module: SuppressMessage("Microsoft.Security", "CA2117:AptcaTypesShouldOnlyExtendAptcaBaseTypes", Scope = "type", Target = "System.ComponentModel.Composition.AttributedModelServices", Justification = "Razzle mscorlib is not APTCA")]
[module: SuppressMessage("Microsoft.Security", "CA2117:AptcaTypesShouldOnlyExtendAptcaBaseTypes", Scope = "type", Target = "System.ComponentModel.Composition.ChangeRejectedException", Justification = "Razzle mscorlib is not APTCA")]
[module: SuppressMessage("Microsoft.Security", "CA2117:AptcaTypesShouldOnlyExtendAptcaBaseTypes", Scope = "type", Target = "System.ComponentModel.Composition.CompositionContractMismatchException", Justification = "Razzle mscorlib is not APTCA")]
[module: SuppressMessage("Microsoft.Security", "CA2117:AptcaTypesShouldOnlyExtendAptcaBaseTypes", Scope = "type", Target = "System.ComponentModel.Composition.CompositionError", Justification = "Razzle mscorlib is not APTCA")]
[module: SuppressMessage("Microsoft.Security", "CA2117:AptcaTypesShouldOnlyExtendAptcaBaseTypes", Scope = "type", Target = "System.ComponentModel.Composition.CompositionException", Justification = "Razzle mscorlib is not APTCA")]
[module: SuppressMessage("Microsoft.Security", "CA2117:AptcaTypesShouldOnlyExtendAptcaBaseTypes", Scope = "type", Target = "System.ComponentModel.Composition.CreationPolicy", Justification = "Razzle mscorlib is not APTCA")]
[module: SuppressMessage("Microsoft.Security", "CA2117:AptcaTypesShouldOnlyExtendAptcaBaseTypes", Scope = "type", Target = "System.ComponentModel.Composition.ExportAttribute", Justification = "Razzle mscorlib is not APTCA")]
[module: SuppressMessage("Microsoft.Security", "CA2117:AptcaTypesShouldOnlyExtendAptcaBaseTypes", Scope = "type", Target = "System.ComponentModel.Composition.ExportMetadataAttribute", Justification = "Razzle mscorlib is not APTCA")]
[module: SuppressMessage("Microsoft.Security", "CA2117:AptcaTypesShouldOnlyExtendAptcaBaseTypes", Scope = "type", Target = "System.ComponentModel.Composition.ImportAttribute", Justification = "Razzle mscorlib is not APTCA")]
[module: SuppressMessage("Microsoft.Security", "CA2117:AptcaTypesShouldOnlyExtendAptcaBaseTypes", Scope = "type", Target = "System.ComponentModel.Composition.ImportCardinalityMismatchException", Justification = "Razzle mscorlib is not APTCA")]
[module: SuppressMessage("Microsoft.Security", "CA2117:AptcaTypesShouldOnlyExtendAptcaBaseTypes", Scope = "type", Target = "System.ComponentModel.Composition.ImportingConstructorAttribute", Justification = "Razzle mscorlib is not APTCA")]
[module: SuppressMessage("Microsoft.Security", "CA2117:AptcaTypesShouldOnlyExtendAptcaBaseTypes", Scope = "type", Target = "System.ComponentModel.Composition.ImportManyAttribute", Justification = "Razzle mscorlib is not APTCA")]
[module: SuppressMessage("Microsoft.Security", "CA2117:AptcaTypesShouldOnlyExtendAptcaBaseTypes", Scope = "type", Target = "System.ComponentModel.Composition.InheritedExportAttribute", Justification = "Razzle mscorlib is not APTCA")]
[module: SuppressMessage("Microsoft.Security", "CA2117:AptcaTypesShouldOnlyExtendAptcaBaseTypes", Scope = "type", Target = "System.ComponentModel.Composition.MetadataAttributeAttribute", Justification = "Razzle mscorlib is not APTCA")]
[module: SuppressMessage("Microsoft.Security", "CA2117:AptcaTypesShouldOnlyExtendAptcaBaseTypes", Scope = "type", Target = "System.ComponentModel.Composition.PartCreationPolicyAttribute", Justification = "Razzle mscorlib is not APTCA")]
[module: SuppressMessage("Microsoft.Security", "CA2117:AptcaTypesShouldOnlyExtendAptcaBaseTypes", Scope = "type", Target = "System.ComponentModel.Composition.PartMetadataAttribute", Justification = "Razzle mscorlib is not APTCA")]
[module: SuppressMessage("Microsoft.Security", "CA2117:AptcaTypesShouldOnlyExtendAptcaBaseTypes", Scope = "type", Target = "System.ComponentModel.Composition.PartNotDiscoverableAttribute", Justification = "Razzle mscorlib is not APTCA")]
[module: SuppressMessage("Microsoft.Security", "CA2117:AptcaTypesShouldOnlyExtendAptcaBaseTypes", Scope = "type", Target = "System.ComponentModel.Composition.Hosting.AdaptingExportProvider", Justification = "Razzle mscorlib is not APTCA")]
[module: SuppressMessage("Microsoft.Security", "CA2117:AptcaTypesShouldOnlyExtendAptcaBaseTypes", Scope = "type", Target = "System.ComponentModel.Composition.Hosting.AggregateCatalog", Justification = "Razzle mscorlib is not APTCA")]
[module: SuppressMessage("Microsoft.Security", "CA2117:AptcaTypesShouldOnlyExtendAptcaBaseTypes", Scope = "type", Target = "System.ComponentModel.Composition.Hosting.AggregateExportProvider", Justification = "Razzle mscorlib is not APTCA")]
[module: SuppressMessage("Microsoft.Security", "CA2117:AptcaTypesShouldOnlyExtendAptcaBaseTypes", Scope = "type", Target = "System.ComponentModel.Composition.Hosting.AssemblyCatalog", Justification = "Razzle mscorlib is not APTCA")]
[module: SuppressMessage("Microsoft.Security", "CA2117:AptcaTypesShouldOnlyExtendAptcaBaseTypes", Scope = "type", Target = "System.ComponentModel.Composition.Hosting.CatalogExportProvider", Justification = "Razzle mscorlib is not APTCA")]
[module: SuppressMessage("Microsoft.Security", "CA2117:AptcaTypesShouldOnlyExtendAptcaBaseTypes", Scope = "type", Target = "System.ComponentModel.Composition.Hosting.ComposablePartCatalogChangeEventArgs", Justification = "Razzle mscorlib is not APTCA")]
[module: SuppressMessage("Microsoft.Security", "CA2117:AptcaTypesShouldOnlyExtendAptcaBaseTypes", Scope = "type", Target = "System.ComponentModel.Composition.Hosting.ComposablePartExportProvider",                        Justification = "Razzle mscorlib is not APTCA")]
[module: SuppressMessage("Microsoft.Security", "CA2117:AptcaTypesShouldOnlyExtendAptcaBaseTypes", Scope = "type", Target = "System.ComponentModel.Composition.Hosting.CompositionBatch", Justification = "Razzle mscorlib is not APTCA")]
[module: SuppressMessage("Microsoft.Security", "CA2117:AptcaTypesShouldOnlyExtendAptcaBaseTypes", Scope = "type", Target = "System.ComponentModel.Composition.Hosting.CompositionConstants", Justification = "Razzle mscorlib is not APTCA")]
[module: SuppressMessage("Microsoft.Security", "CA2117:AptcaTypesShouldOnlyExtendAptcaBaseTypes", Scope = "type", Target = "System.ComponentModel.Composition.Hosting.CompositionContainer", Justification = "Razzle mscorlib is not APTCA")]
[module: SuppressMessage("Microsoft.Security", "CA2117:AptcaTypesShouldOnlyExtendAptcaBaseTypes", Scope = "type", Target = "System.ComponentModel.Composition.Hosting.AtomicComposition", Justification = "Razzle mscorlib is not APTCA")]
[module: SuppressMessage("Microsoft.Security", "CA2117:AptcaTypesShouldOnlyExtendAptcaBaseTypes", Scope = "type", Target = "System.ComponentModel.Composition.Hosting.DirectoryCatalog", Justification = "Razzle mscorlib is not APTCA")]
[module: SuppressMessage("Microsoft.Security", "CA2117:AptcaTypesShouldOnlyExtendAptcaBaseTypes", Scope = "type", Target = "System.ComponentModel.Composition.Primitives.ExportedDelegate", Justification = "Razzle mscorlib is not APTCA")]
[module: SuppressMessage("Microsoft.Security", "CA2117:AptcaTypesShouldOnlyExtendAptcaBaseTypes", Scope = "type", Target = "System.ComponentModel.Composition.Hosting.ExportProvider", Justification = "Razzle mscorlib is not APTCA")]
[module: SuppressMessage("Microsoft.Security", "CA2117:AptcaTypesShouldOnlyExtendAptcaBaseTypes", Scope = "type", Target = "System.ComponentModel.Composition.Hosting.ExportsChangeEventArgs", Justification = "Razzle mscorlib is not APTCA")]
[module: SuppressMessage("Microsoft.Security", "CA2117:AptcaTypesShouldOnlyExtendAptcaBaseTypes", Scope = "type", Target = "System.ComponentModel.Composition.Hosting.ImportEngine", Justification = "Razzle mscorlib is not APTCA")]
[module: SuppressMessage("Microsoft.Security", "CA2117:AptcaTypesShouldOnlyExtendAptcaBaseTypes", Scope = "type", Target = "System.ComponentModel.Composition.Hosting.TypeCatalog", Justification = "Razzle mscorlib is not APTCA")]
[module: SuppressMessage("Microsoft.Security", "CA2117:AptcaTypesShouldOnlyExtendAptcaBaseTypes", Scope = "type", Target = "System.ComponentModel.Composition.Primitives.Export", Justification = "Razzle mscorlib is not APTCA")]
[module: SuppressMessage("Microsoft.Security", "CA2117:AptcaTypesShouldOnlyExtendAptcaBaseTypes", Scope = "type", Target = "System.ComponentModel.Composition.Primitives.ExportDefinition", Justification = "Razzle mscorlib is not APTCA")]
[module: SuppressMessage("Microsoft.Security", "CA2117:AptcaTypesShouldOnlyExtendAptcaBaseTypes", Scope = "type", Target = "System.ComponentModel.Composition.Primitives.ComposablePart", Justification = "Razzle mscorlib is not APTCA")]
[module: SuppressMessage("Microsoft.Security", "CA2117:AptcaTypesShouldOnlyExtendAptcaBaseTypes", Scope = "type", Target = "System.ComponentModel.Composition.Primitives.ComposablePartCatalog", Justification = "Razzle mscorlib is not APTCA")]
[module: SuppressMessage("Microsoft.Security", "CA2117:AptcaTypesShouldOnlyExtendAptcaBaseTypes", Scope = "type", Target = "System.ComponentModel.Composition.Primitives.ComposablePartDefinition", Justification = "Razzle mscorlib is not APTCA")]
[module: SuppressMessage("Microsoft.Security", "CA2117:AptcaTypesShouldOnlyExtendAptcaBaseTypes", Scope = "type", Target = "System.ComponentModel.Composition.Primitives.ComposablePartException", Justification = "Razzle mscorlib is not APTCA")]
[module: SuppressMessage("Microsoft.Security", "CA2117:AptcaTypesShouldOnlyExtendAptcaBaseTypes", Scope = "type", Target = "System.ComponentModel.Composition.Primitives.ContractBasedImportDefinition", Justification = "Razzle mscorlib is not APTCA")]
[module: SuppressMessage("Microsoft.Security", "CA2117:AptcaTypesShouldOnlyExtendAptcaBaseTypes", Scope = "type", Target = "System.ComponentModel.Composition.Primitives.ImportCardinality", Justification = "Razzle mscorlib is not APTCA")]
[module: SuppressMessage("Microsoft.Security", "CA2117:AptcaTypesShouldOnlyExtendAptcaBaseTypes", Scope = "type", Target = "System.ComponentModel.Composition.Primitives.ImportDefinition", Justification = "Razzle mscorlib is not APTCA")]
[module: SuppressMessage("Microsoft.Security", "CA2117:AptcaTypesShouldOnlyExtendAptcaBaseTypes", Scope = "type", Target = "System.ComponentModel.Composition.ReflectionModel.LazyMemberInfo", Justification = "Razzle mscorlib is not APTCA")]
[module: SuppressMessage("Microsoft.Security", "CA2117:AptcaTypesShouldOnlyExtendAptcaBaseTypes", Scope = "type", Target = "System.ComponentModel.Composition.ReflectionModel.ReflectionModelServices", Justification = "Razzle mscorlib is not APTCA")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.AggregateCatalog.#.ctor(System.Collections.Generic.IEnumerable`1<System.ComponentModel.Composition.Primitives.ComposablePartCatalog>)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.AggregateCatalog.#Dispose(System.Boolean)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.AggregateCatalog.#GetExports(System.ComponentModel.Composition.Primitives.ImportDefinition)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.AggregateExportProvider.#.ctor(System.Collections.Generic.IEnumerable`1<System.ComponentModel.Composition.Hosting.ExportProvider>)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.AggregateExportProvider.#.ctor(System.ComponentModel.Composition.Hosting.ExportProvider[])")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.AggregateExportProvider.#Dispose()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.AggregateExportProvider.#Dispose(System.Boolean)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.AggregateExportProvider.#GetExportsCore(System.ComponentModel.Composition.Primitives.ImportDefinition,System.ComponentModel.Composition.Hosting.AtomicComposition)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.AssemblyCatalog.#.ctor(System.Reflection.Assembly,System.ComponentModel.Composition.Primitives.ICompositionElement)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.AssemblyCatalog.#Dispose(System.Boolean)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.AssemblyCatalog.#GetDisplayName()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.AssemblyCatalog.#InnerCatalog")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.AssemblyCatalog.#LoadAssembly(System.String)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.AssemblyCatalogDebuggerProxy.#.ctor(System.ComponentModel.Composition.Hosting.AssemblyCatalog)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.Assumes+InternalErrorException.#.ctor(System.Runtime.Serialization.SerializationInfo,System.Runtime.Serialization.StreamingContext)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.Assumes+InternalErrorException.#.ctor(System.String)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.Assumes.#NotNullOrEmpty(System.String)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.AtomicComposition.#AddCompleteAction(System.Action)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.AtomicComposition.#AddRevertAction(System.Action)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.AtomicComposition.#.ctor(System.ComponentModel.Composition.Hosting.AtomicComposition)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.AtomicComposition.#ContainsInnerAtomicComposition")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.AtomicComposition.#CopyComplete()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.AtomicComposition.#Dispose()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.AtomicComposition.#Dispose(System.Boolean)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.AtomicComposition.#FinalComplete()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.AtomicComposition.#SetValueInternal(System.Object,System.Object)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.AtomicComposition.#ThrowIfCompleteed()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.AtomicComposition.#ThrowIfContainsInnerAtomicComposition()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.AtomicComposition.#TryGetValueInternal`1(System.Object,System.Boolean,!!0&)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.AtomicCompositionExtensions.#AddCompleteActionAllowNull(System.ComponentModel.Composition.Hosting.AtomicComposition,System.Action)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.AtomicCompositionExtensions.#AddRevertActionAllowNull(System.ComponentModel.Composition.Hosting.AtomicComposition,System.Action)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.AttributedModel.AttributedExportDefinition.#Metadata")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.AttributedModel.AttributedModelDiscovery.#CreatePart(System.Object)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.AttributedModel.AttributedModelDiscovery.#GetImportDefinitionCreationInfo(System.ComponentModel.Composition.ReflectionModel.ReflectionItem,System.Reflection.ICustomAttributeProvider)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.AttributedModelServices.#AddExportedValue`1(System.ComponentModel.Composition.Hosting.CompositionBatch,System.String,!!0)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.AttributedModelServices.#AddExportedValue`1(System.ComponentModel.Composition.Hosting.CompositionBatch,!!0)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.AttributedModelServices.#ComposeParts(System.ComponentModel.Composition.Hosting.CompositionContainer,System.Object[])")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.AttributedModel.AttributedPartCreationInfo.#.ctor(System.Type,System.ComponentModel.Composition.PartCreationPolicyAttribute,System.Boolean,System.ComponentModel.Composition.Primitives.ICompositionElement)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.AttributedModel.AttributedPartCreationInfo.#GetConstructor()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.AttributedModel.AttributedPartCreationInfo.#GetExportDefinitions()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.AttributedModel.AttributedPartCreationInfo.#GetImportDefinitions()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.AttributedModel.AttributedPartCreationInfo.#GetLazyPartType()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.AttributedModel.AttributedPartCreationInfo.#HasExports()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.AttributedModel.AttributedPartCreationInfo.#IsDisposalRequired")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.AttributedModel.AttributedPartCreationInfo.#IsPartDiscoverable()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.AttributedModel.AttributedPartCreationInfo.#SelectPartConstructor(System.Type)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.AttributeServices.#GetAttributes`1(System.Reflection.ICustomAttributeProvider)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.AttributeServices.#GetAttributes`1(System.Reflection.ICustomAttributeProvider,System.Boolean)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.AttributeServices.#GetFirstAttribute`1(System.Reflection.ICustomAttributeProvider)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.AttributeServices.#GetFirstAttribute`1(System.Reflection.ICustomAttributeProvider,System.Boolean)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.AttributeServices.#IsAttributeDefined`1(System.Reflection.ICustomAttributeProvider)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.AttributeServices.#IsAttributeDefined`1(System.Reflection.ICustomAttributeProvider,System.Boolean)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.CatalogExportProvider+CatalogChangeProxy.#.ctor(System.ComponentModel.Composition.Primitives.ComposablePartCatalog,System.Collections.Generic.IEnumerable`1<System.ComponentModel.Composition.Primitives.ComposablePartDefinition>,System.Collections.Generic.IEnumerable`1<System.ComponentModel.Composition.Primitives.ComposablePartDefinition>)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.CatalogExportProvider+CatalogChangeProxy.#GetExports(System.ComponentModel.Composition.Primitives.ImportDefinition)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.CatalogExportProvider+CatalogChangeProxy.#Parts")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.CatalogExportProvider.#.ctor(System.ComponentModel.Composition.Primitives.ComposablePartCatalog,System.Boolean)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.CatalogExportProvider.#DetermineRejection(System.ComponentModel.Composition.Primitives.ComposablePartDefinition,System.ComponentModel.Composition.Hosting.AtomicComposition)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.CatalogExportProvider.#Dispose()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.CatalogExportProvider.#Dispose(System.Boolean)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.CatalogExportProvider.#EnsureCanRun()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.CatalogExportProvider.#EnsureCanSet`1(!!0)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.CatalogExportProvider.#EnsureRunning()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.CatalogExportProvider.#GetAtomicCompositionQuery(System.ComponentModel.Composition.Hosting.AtomicComposition)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.CatalogExportProvider.#GetComposablePart(System.ComponentModel.Composition.Primitives.ComposablePartDefinition,System.Boolean)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.CatalogExportProvider.#GetExportsCore(System.ComponentModel.Composition.Primitives.ImportDefinition,System.ComponentModel.Composition.Hosting.AtomicComposition)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.CatalogExportProvider.#GetSharedPart(System.ComponentModel.Composition.Primitives.ComposablePartDefinition)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.CatalogExportProvider.#IsRejected(System.ComponentModel.Composition.Primitives.ComposablePartDefinition,System.ComponentModel.Composition.Hosting.AtomicComposition)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.CatalogExportProvider.#OnCatalogChanging(System.Object,System.ComponentModel.Composition.Hosting.ComposablePartCatalogChangeEventArgs)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.CatalogExportProvider.#OnExportsChangingInternal(System.Object,System.ComponentModel.Composition.Hosting.ExportsChangeEventArgs)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.CatalogExportProvider.#ReleasePart(System.Object,System.ComponentModel.Composition.Primitives.ComposablePart,System.ComponentModel.Composition.Hosting.AtomicComposition)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.CatalogExportProvider.#SetConditionalReferenceForRecomposablePart(System.Object,System.ComponentModel.Composition.Primitives.ComposablePart)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.CatalogExportProvider.#SourceProvider")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.CatalogExportProvider.#UpdateAtomicCompositionQuery(System.ComponentModel.Composition.Hosting.AtomicComposition,System.Func`2<System.ComponentModel.Composition.Primitives.ComposablePartDefinition,System.Boolean>,System.ComponentModel.Composition.Hosting.CatalogExportProvider+AtomicCompositionQueryState)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.CatalogExportProvider.#UpdateRejections(System.Collections.Generic.IEnumerable`1<System.ComponentModel.Composition.Primitives.ExportDefinition>,System.ComponentModel.Composition.Hosting.AtomicComposition)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ChangeRejectedException.#Message")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.Collections.CollectionServices.#AsArray`1(System.Collections.Generic.IEnumerable`1<!!0>)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.Collections.CollectionServices+CollectionOfObject`1.#Add(System.Object)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.Collections.CollectionServices+CollectionOfObject`1.#Clear()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.Collections.CollectionServices+CollectionOfObject`1.#.ctor(System.Object)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.Collections.CollectionServices+CollectionOfObject`1.#IsReadOnly")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.Collections.CollectionServices+CollectionOfObjectList.#Add(System.Object)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.Collections.CollectionServices+CollectionOfObjectList.#Clear()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.Collections.CollectionServices+CollectionOfObjectList.#.ctor(System.Collections.IList)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.Collections.CollectionServices+CollectionOfObjectList.#IsReadOnly")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.Collections.CollectionServices.#ConcatAllowingNull`1(System.Collections.Generic.IEnumerable`1<!!0>,System.Collections.Generic.IEnumerable`1<!!0>)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.Collections.CollectionServices.#Copy`1(System.Collections.Generic.Stack`1<!!0>)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.Collections.CollectionServices.#FastAny`1(System.Collections.Generic.IEnumerable`1<!!0>)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.Collections.CollectionServices.#ForEach`1(System.Collections.Generic.IEnumerable`1<!!0>,System.Action`1<!!0>)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.Collections.CollectionServices.#GetCardinality`1(System.Collections.Generic.IEnumerable`1<!!0>)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.Collections.CollectionServices.#GetCollectionElementType(System.Type)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.Collections.CollectionServices.#GetCollectionWrapper(System.Type,System.Object)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.Collections.CollectionServices.#GetEnumerableElementType(System.Type)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.Collections.CollectionServices.#ToReadOnlyCollection`1(System.Collections.Generic.IEnumerable`1<!!0>)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.Collections.CollectionServices.#WhereNotNull`1(System.Collections.Generic.IEnumerable`1<!!0>)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Primitives.ComposablePart.#.ctor()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Primitives.ComposablePartCatalog.#.ctor()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Primitives.ComposablePartCatalog.#Dispose()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Primitives.ComposablePartCatalog.#GetExports(System.ComponentModel.Composition.Primitives.ImportDefinition)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ComposablePartCatalogChangeEventArgs.#.ctor(System.Collections.Generic.IEnumerable`1<System.ComponentModel.Composition.Primitives.ComposablePartDefinition>,System.Collections.Generic.IEnumerable`1<System.ComponentModel.Composition.Primitives.ComposablePartDefinition>,System.ComponentModel.Composition.Hosting.AtomicComposition)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ComposablePartCatalogCollection.#Add(System.ComponentModel.Composition.Primitives.ComposablePartCatalog)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ComposablePartCatalogCollection.#Changed")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ComposablePartCatalogCollection.#Changing")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ComposablePartCatalogCollection.#Clear()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ComposablePartCatalogCollection.#.ctor(System.Collections.Generic.IEnumerable`1<System.ComponentModel.Composition.Primitives.ComposablePartCatalog>,System.Action`1<System.ComponentModel.Composition.Hosting.ComposablePartCatalogChangeEventArgs>,System.Action`1<System.ComponentModel.Composition.Hosting.ComposablePartCatalogChangeEventArgs>)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ComposablePartCatalogCollection.#Contains(System.ComponentModel.Composition.Primitives.ComposablePartCatalog)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ComposablePartCatalogCollection.#CopyTo(System.ComponentModel.Composition.Primitives.ComposablePartCatalog[],System.Int32)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ComposablePartCatalogCollection.#Count")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ComposablePartCatalogCollection.#Dispose()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ComposablePartCatalogCollection.#Dispose(System.Boolean)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ComposablePartCatalogCollection.#GetEnumerator()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ComposablePartCatalogCollection.#HasChanged")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ComposablePartCatalogCollection.#OnChanged(System.Object,System.ComponentModel.Composition.Hosting.ComposablePartCatalogChangeEventArgs)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ComposablePartCatalogCollection.#OnChanging(System.Object,System.ComponentModel.Composition.Hosting.ComposablePartCatalogChangeEventArgs)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ComposablePartCatalogCollection.#OnContainedCatalogChanged(System.Object,System.ComponentModel.Composition.Hosting.ComposablePartCatalogChangeEventArgs)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ComposablePartCatalogCollection.#OnContainedCatalogChanging(System.Object,System.ComponentModel.Composition.Hosting.ComposablePartCatalogChangeEventArgs)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ComposablePartCatalogCollection.#RaiseChangedEvent(System.Lazy`1<System.Collections.Generic.IEnumerable`1<System.ComponentModel.Composition.Primitives.ComposablePartDefinition>>,System.Lazy`1<System.Collections.Generic.IEnumerable`1<System.ComponentModel.Composition.Primitives.ComposablePartDefinition>>)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ComposablePartCatalogCollection.#RaiseChangingEvent(System.Lazy`1<System.Collections.Generic.IEnumerable`1<System.ComponentModel.Composition.Primitives.ComposablePartDefinition>>,System.Lazy`1<System.Collections.Generic.IEnumerable`1<System.ComponentModel.Composition.Primitives.ComposablePartDefinition>>,System.ComponentModel.Composition.Hosting.AtomicComposition)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ComposablePartCatalogCollection.#Remove(System.ComponentModel.Composition.Primitives.ComposablePartCatalog)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ComposablePartCatalogCollection.#SubscribeToCatalogNotifications(System.ComponentModel.Composition.Primitives.ComposablePartCatalog)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ComposablePartCatalogCollection.#SubscribeToCatalogNotifications(System.Collections.Generic.IEnumerable`1<System.ComponentModel.Composition.Primitives.ComposablePartCatalog>)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ComposablePartCatalogCollection.#UnsubscribeFromCatalogNotifications(System.ComponentModel.Composition.Primitives.ComposablePartCatalog)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ComposablePartCatalogCollection.#UnsubscribeFromCatalogNotifications(System.Collections.Generic.IEnumerable`1<System.ComponentModel.Composition.Primitives.ComposablePartCatalog>)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Primitives.ComposablePartCatalogDebuggerProxy.#.ctor(System.ComponentModel.Composition.Primitives.ComposablePartCatalog)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Primitives.ComposablePartDefinition.#.ctor()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Primitives.ComposablePartException.#.ctor(System.ComponentModel.Composition.CompositionErrorId,System.String,System.ComponentModel.Composition.Primitives.ICompositionElement,System.Exception)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Primitives.ComposablePartException.#.ctor(System.Runtime.Serialization.SerializationInfo,System.Runtime.Serialization.StreamingContext)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Primitives.ComposablePartException.#GetObjectData(System.Runtime.Serialization.SerializationInfo,System.Runtime.Serialization.StreamingContext)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ComposablePartExportProvider.#.ctor(System.Boolean)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ComposablePartExportProvider.#Compose(System.ComponentModel.Composition.Hosting.CompositionBatch)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ComposablePartExportProvider.#CreateExport(System.ComponentModel.Composition.Primitives.ComposablePart,System.ComponentModel.Composition.Primitives.ExportDefinition)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ComposablePartExportProvider.#Dispose()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ComposablePartExportProvider.#Dispose(System.Boolean)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ComposablePartExportProvider.#EnsureCanRun()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ComposablePartExportProvider.#EnsureCanSet`1(!!0)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ComposablePartExportProvider.#EnsureRunning()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ComposablePartExportProvider.#GetExportsCore(System.ComponentModel.Composition.Primitives.ImportDefinition,System.ComponentModel.Composition.Hosting.AtomicComposition)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ComposablePartExportProvider.#GetUpdatedPartsList(System.ComponentModel.Composition.Hosting.CompositionBatch)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ComposablePartExportProvider.#Recompose(System.ComponentModel.Composition.Hosting.CompositionBatch,System.ComponentModel.Composition.Hosting.AtomicComposition)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ComposablePartExportProvider.#SourceProvider")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ComposablePartExportProvider.#ThrowIfDisposed()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.CompositionBatch.#AddPart(System.ComponentModel.Composition.Primitives.ComposablePart)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.CompositionBatch.#.ctor(System.Collections.Generic.IEnumerable`1<System.ComponentModel.Composition.Primitives.ComposablePart>,System.Collections.Generic.IEnumerable`1<System.ComponentModel.Composition.Primitives.ComposablePart>)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.CompositionBatch.#PartsToAdd")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.CompositionBatch.#PartsToRemove")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.CompositionBatch.#RemovePart(System.ComponentModel.Composition.Primitives.ComposablePart)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.CompositionBatch+SingleExportComposablePart.#ImportDefinitions")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.CompositionContainer.#.ctor(System.ComponentModel.Composition.Primitives.ComposablePartCatalog,System.Boolean,System.ComponentModel.Composition.Hosting.ExportProvider[])")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.CompositionContainer.#Dispose()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.CompositionContainer.#Dispose(System.Boolean)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.CompositionContainer.#ReleaseExport(System.ComponentModel.Composition.Primitives.Export)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.CompositionContainer.#ReleaseExport`1(System.Lazy`1<!!0>)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.CompositionContainer.#ReleaseExports(System.Collections.Generic.IEnumerable`1<System.ComponentModel.Composition.Primitives.Export>)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.CompositionContainer.#ReleaseExports`2(System.Collections.Generic.IEnumerable`1<System.Lazy`2<!!0,!!1>>)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.CompositionContainer.#ReleaseExports`1(System.Collections.Generic.IEnumerable`1<System.Lazy`1<!!0>>)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.CompositionContractMismatchException.#.ctor(System.Runtime.Serialization.SerializationInfo,System.Runtime.Serialization.StreamingContext)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.CompositionContractMismatchException.#.ctor(System.String,System.Exception)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Primitives.CompositionElement.#.ctor(System.Object)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Primitives.CompositionElementDebuggerProxy.#.ctor(System.ComponentModel.Composition.Primitives.CompositionElement)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Primitives.CompositionElementExtensions.#GetDisplayNameCore(System.Object)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.CompositionError.#.ctor(System.ComponentModel.Composition.CompositionErrorId,System.String,System.ComponentModel.Composition.Primitives.ICompositionElement,System.Exception)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.CompositionError.#.ctor(System.Runtime.Serialization.SerializationInfo,System.Runtime.Serialization.StreamingContext)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.CompositionError.#Create(System.ComponentModel.Composition.CompositionErrorId,System.ComponentModel.Composition.Primitives.ICompositionElement,System.Exception,System.String,System.Object[])")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.CompositionError.#GetObjectData(System.Runtime.Serialization.SerializationInfo,System.Runtime.Serialization.StreamingContext)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.CompositionErrorDebuggerProxy.#.ctor(System.ComponentModel.Composition.CompositionError)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.CompositionException.#BuildDefaultMessage()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.CompositionException.#CalculatePaths(System.ComponentModel.Composition.CompositionException)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.CompositionException.#.ctor(System.Runtime.Serialization.SerializationInfo,System.Runtime.Serialization.StreamingContext)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.CompositionException.#.ctor(System.String,System.Exception,System.Collections.Generic.IEnumerable`1<System.ComponentModel.Composition.CompositionError>)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.CompositionException.#GetObjectData(System.Runtime.Serialization.SerializationInfo,System.Runtime.Serialization.StreamingContext)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.CompositionException.#Message")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.CompositionException.#VisitCompositionException(System.ComponentModel.Composition.CompositionException,System.ComponentModel.Composition.CompositionException+VisitContext)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.CompositionException.#VisitError(System.ComponentModel.Composition.CompositionError,System.ComponentModel.Composition.CompositionException+VisitContext)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.CompositionException.#VisitException(System.Exception,System.ComponentModel.Composition.CompositionException+VisitContext)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.CompositionException.#WriteElementGraph(System.Text.StringBuilder,System.ComponentModel.Composition.Primitives.ICompositionElement)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.CompositionException.#WriteError(System.Text.StringBuilder,System.ComponentModel.Composition.CompositionError)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.CompositionException.#WriteHeader(System.Text.StringBuilder,System.Int32,System.Int32)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.CompositionException.#WritePath(System.Text.StringBuilder,System.Collections.Generic.IEnumerable`1<System.ComponentModel.Composition.CompositionError>,System.Int32)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.CompositionException.#WritePaths(System.Text.StringBuilder,System.Collections.Generic.IEnumerable`1<System.Collections.Generic.IEnumerable`1<System.ComponentModel.Composition.CompositionError>>)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.CompositionLock.#.cctor()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.CompositionLock.#.ctor(System.Boolean)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.CompositionLock+CompositionLockHolder.#.ctor(System.ComponentModel.Composition.Hosting.CompositionLock)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.CompositionLock+CompositionLockHolder.#Dispose()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.CompositionLock.#Dispose()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.CompositionLock+EmptyLockHolder.#.ctor()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.CompositionLock.#EnterCompositionLock()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.CompositionLock.#ExitCompositionLock()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.CompositionResult.#Errors")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.CompositionResult`1.#Errors")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.CompositionServices.#.cctor()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.CompositionServices.#GetContractNameFromExport(System.Reflection.MemberInfo,System.ComponentModel.Composition.ExportAttribute)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.CompositionServices.#GetContractNameFromImport(System.ComponentModel.Composition.IAttributedImport,System.ComponentModel.Composition.ReflectionModel.ImportType)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.CompositionServices.#GetContractTypeFromImport(System.ComponentModel.Composition.IAttributedImport,System.ComponentModel.Composition.ReflectionModel.ImportType)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.CompositionServices.#GetDefaultTypeFromMember(System.Reflection.MemberInfo)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.CompositionServices.#GetPartMetadataForType(System.Type,System.ComponentModel.Composition.CreationPolicy)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.CompositionServices.#GetRequiredMetadata(System.Type)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.CompositionServices.#GetTypeIdentityFromExport(System.Reflection.MemberInfo,System.ComponentModel.Composition.ExportAttribute)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.CompositionServices.#GetTypeIdentityFromImport(System.ComponentModel.Composition.IAttributedImport,System.ComponentModel.Composition.ReflectionModel.ImportType)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.CompositionServices.#IsRecomposable(System.ComponentModel.Composition.Primitives.ComposablePart)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.CompositionServices.#IsValidAttributeType(System.Type,System.Boolean)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.CompositionServices+MetadataList.#Add(System.Object,System.Type)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.CompositionServices+MetadataList.#InferArrayType(System.Type)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.CompositionServices+MetadataList.#.ctor()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.CompositionServices+MetadataList.#.cctor()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.CompositionServices+MetadataList.#ToArray()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.CompositionServices.#TryContributeMetadataValue(System.Collections.Generic.IDictionary`2<System.String,System.Object>,System.String,System.Object,System.Type,System.Boolean)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.CompositionServices.#TryExportMetadataForMember(System.Reflection.MemberInfo,System.Collections.Generic.IDictionary`2<System.String,System.Object>&)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.CompositionServices.#TryFire`1(System.EventHandler`1<!!0>,System.Object,!!0)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.CompositionServices.#TryInvoke(System.Action)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.CompositionServices.#TryInvoke`1(System.Func`1<!!0>)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Diagnostics.CompositionTrace.#AssemblyLoadFailed(System.ComponentModel.Composition.Hosting.DirectoryCatalog,System.String,System.Exception)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Diagnostics.CompositionTrace.#PartDefinitionRejected(System.ComponentModel.Composition.Primitives.ComposablePartDefinition,System.ComponentModel.Composition.ChangeRejectedException)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ConstraintServices.#AndAlso`1(System.Linq.Expressions.Expression`1<System.Func`2<!!0,System.Boolean>>,System.Linq.Expressions.Expression`1<System.Func`2<!!0,System.Boolean>>)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ConstraintServices.#.cctor()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ConstraintServices.#CreateConstraint(System.Collections.Generic.IEnumerable`1<System.Collections.Generic.KeyValuePair`2<System.String,System.Type>>)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ConstraintServices.#CreateConstraint(System.String,System.String,System.Collections.Generic.IEnumerable`1<System.Collections.Generic.KeyValuePair`2<System.String,System.Type>>,System.ComponentModel.Composition.CreationPolicy)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ConstraintServices.#CreateContractConstraintBody(System.String,System.Linq.Expressions.ParameterExpression)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ConstraintServices.#CreateCreationPolicyContraint(System.ComponentModel.Composition.CreationPolicy,System.Linq.Expressions.ParameterExpression)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ConstraintServices.#CreateMetadataConstraintBody(System.Collections.Generic.IEnumerable`1<System.Collections.Generic.KeyValuePair`2<System.String,System.Type>>,System.Linq.Expressions.ParameterExpression)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ConstraintServices.#CreateMetadataContainsKeyExpression(System.Linq.Expressions.ParameterExpression,System.String)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ConstraintServices.#CreateMetadataOfTypeExpression(System.Linq.Expressions.ParameterExpression,System.String,System.Type)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ConstraintServices.#CreateMetadataValueEqualsExpression(System.Linq.Expressions.ParameterExpression,System.Object,System.String)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ConstraintServices.#CreateTypeIdentityContraint(System.String,System.Linq.Expressions.ParameterExpression)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Primitives.ContractBasedImportDefinition.#.ctor()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Primitives.ContractBasedImportDefinition.#.ctor(System.String,System.String,System.Collections.Generic.IEnumerable`1<System.Collections.Generic.KeyValuePair`2<System.String,System.Type>>,System.ComponentModel.Composition.Primitives.ImportCardinality,System.Boolean,System.Boolean,System.ComponentModel.Composition.CreationPolicy)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Primitives.ContractBasedImportDefinition.#IsConstraintSatisfiedBy(System.ComponentModel.Composition.Primitives.ExportDefinition)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Primitives.ContractBasedImportDefinition.#MatchRequiredMatadata(System.ComponentModel.Composition.Primitives.ExportDefinition)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ContractNameServices.#FindArrayElementType(System.Type)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ContractNameServices.#FindGenericTypeName(System.String)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ContractNameServices.#GetGenericArity(System.Type)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ContractNameServices.#GetTypeIdentity(System.Type)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ContractNameServices.#GetTypeIdentityFromMethod(System.Reflection.MethodInfo)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ContractNameServices.#TypeIdentityCache")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ContractNameServices.#WriteArrayType(System.Text.StringBuilder,System.Type)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ContractNameServices.#WriteArrayTypeDimensions(System.Text.StringBuilder,System.Type)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ContractNameServices.#WriteByRefType(System.Text.StringBuilder,System.Type)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ContractNameServices.#WriteCustomModifiers(System.Text.StringBuilder,System.String,System.Type[])")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ContractNameServices.#WriteGenericType(System.Text.StringBuilder,System.Type,System.Boolean,System.Collections.Generic.Queue`1<System.Type>)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ContractNameServices.#WriteGenericTypeName(System.Text.StringBuilder,System.Type,System.Boolean,System.Collections.Generic.Queue`1<System.Type>)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ContractNameServices.#WriteNonGenericType(System.Text.StringBuilder,System.Type)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ContractNameServices.#WritePointerType(System.Text.StringBuilder,System.Type)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ContractNameServices.#WriteType(System.Text.StringBuilder,System.Type)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ContractNameServices.#WriteTypeArgumentsString(System.Text.StringBuilder,System.Int32,System.Boolean,System.Collections.Generic.Queue`1<System.Type>)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ContractNameServices.#WriteTypeWithNamespace(System.Text.StringBuilder,System.Type)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.ContractServices.#.ctor()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.ContractServices.#TryCast(System.Type,System.Object,System.Object&)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.DirectoryCatalog.#Changed")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.DirectoryCatalog.#Changing")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.DirectoryCatalog.#DiffChanges(System.String[],System.String[],System.Collections.Generic.List`1<System.Tuple`2<System.String,System.ComponentModel.Composition.Hosting.AssemblyCatalog>>&,System.Collections.Generic.List`1<System.Tuple`2<System.String,System.ComponentModel.Composition.Hosting.AssemblyCatalog>>&)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.DirectoryCatalog+DirectoryCatalogDebuggerProxy.#Assemblies")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.DirectoryCatalog+DirectoryCatalogDebuggerProxy.#.ctor(System.ComponentModel.Composition.Hosting.DirectoryCatalog)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.DirectoryCatalog.#Dispose(System.Boolean)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.DirectoryCatalog.#GetDisplayName()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.DirectoryCatalog.#GetExports(System.ComponentModel.Composition.Primitives.ImportDefinition)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.DirectoryCatalog.#GetFiles()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.DirectoryCatalog.#GetFullPath(System.String)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.DirectoryCatalog.#Initialize(System.String,System.String)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.DirectoryCatalog.#LoadedFiles")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.DirectoryCatalog.#OnChanged(System.ComponentModel.Composition.Hosting.ComposablePartCatalogChangeEventArgs)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.DirectoryCatalog.#OnChanging(System.ComponentModel.Composition.Hosting.ComposablePartCatalogChangeEventArgs)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.DirectoryCatalog.#Refresh()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.DisposableReflectionComposablePart.#System.IDisposable.Dispose()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.DisposableReflectionComposablePart.#ReleaseInstanceIfNecessary(System.Object)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ErrorBuilder.#CreateImportCardinalityMismatch(System.ComponentModel.Composition.ImportCardinalityMismatchException,System.ComponentModel.Composition.Primitives.ImportDefinition)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ExceptionBuilder.#CreateContainsNullElement(System.String)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ExceptionBuilder.#CreateDiscoveryException(System.String,System.String[])")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ExceptionBuilder.#CreateExportDefinitionNotOnThisComposablePart(System.String)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ExceptionBuilder.#CreateImportDefinitionNotOnThisComposablePart(System.String)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ExceptionBuilder.#CreateNotOverriddenByDerived(System.String)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ExceptionBuilder.#CreateObjectDisposed(System.Object)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ExceptionBuilder.#Format(System.String,System.String[])")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Primitives.Export.#.cctor()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Primitives.Export.#.ctor()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Primitives.Export.#.ctor(System.ComponentModel.Composition.Primitives.ExportDefinition,System.Func`1<System.Object>)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Primitives.Export.#GetExportedValueCore()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Primitives.Export.#Value")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ExportAttribute.#.ctor(System.String,System.Type)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Primitives.ExportDefinition.#.ctor()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Primitives.ExportDefinition.#.ctor(System.String,System.Collections.Generic.IDictionary`2<System.String,System.Object>)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Primitives.ExportedDelegate.#ConvertMethodInfoToFuncOrActionType(System.Reflection.MethodInfo)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Primitives.ExportedDelegate.#CreateDelegate(System.Type)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Primitives.ExportedDelegate.#.ctor()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Primitives.ExportedDelegate.#.cctor()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Primitives.ExportedDelegate.#.ctor(System.Object,System.Reflection.MethodInfo)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ExportingMember.#EnsureReadable()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ExportingMember.#.ctor(System.ComponentModel.Composition.Primitives.ExportDefinition,System.ComponentModel.Composition.ReflectionModel.ReflectionMember)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ExportingMember.#GetExportedValue(System.Object,System.Object)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ExportMetadataAttribute.#.ctor(System.String,System.Object)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ExportProvider.#BuildImportDefinition(System.Type,System.Type,System.String,System.ComponentModel.Composition.Primitives.ImportCardinality)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ExportProvider.#.ctor()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ExportProvider.#ExportsChanged")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ExportProvider.#ExportsChanging")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ExportProvider.#GetExportCore`2(System.String)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ExportProvider.#GetExportCore`1(System.String)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ExportProvider.#GetExportedValueCore`1(System.String,System.ComponentModel.Composition.Primitives.ImportCardinality)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ExportProvider.#GetExportedValuesCore`1(System.String)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ExportProvider.#GetExports(System.ComponentModel.Composition.Primitives.ImportDefinition,System.ComponentModel.Composition.Hosting.AtomicComposition)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ExportProvider.#GetExports(System.Type,System.Type,System.String)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ExportProvider.#GetExportsCore(System.Type,System.Type,System.String,System.ComponentModel.Composition.Primitives.ImportCardinality)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ExportProvider.#GetExportsCore`2(System.String)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ExportProvider.#GetExportsCore`1(System.String)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ExportProvider.#TryGetExportsCore(System.ComponentModel.Composition.Primitives.ImportDefinition,System.ComponentModel.Composition.Hosting.AtomicComposition,System.Collections.Generic.IEnumerable`1<System.ComponentModel.Composition.Primitives.Export>&)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ExportsChangeEventArgs.#ChangedContractNames")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ExportsChangeEventArgs.#.ctor(System.Collections.Generic.IEnumerable`1<System.ComponentModel.Composition.Primitives.ExportDefinition>,System.Collections.Generic.IEnumerable`1<System.ComponentModel.Composition.Primitives.ExportDefinition>,System.ComponentModel.Composition.Hosting.AtomicComposition)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ExportServices.#CreateSemiStronglyTypedExport`2(System.ComponentModel.Composition.Primitives.Export)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ExportServices.#CreateSemiStronglyTypedExportFactory(System.Type,System.Type)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ExportServices.#CreateStronglyTypedExportFactory(System.Type,System.Type)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ExportServices.#CreateStronglyTypedExportOfT`1(System.ComponentModel.Composition.Primitives.Export)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ExportServices.#CreateStronglyTypedExportOfTM`2(System.ComponentModel.Composition.Primitives.Export)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ExportServices+DisposableLazy`2.#System.IDisposable.Dispose()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ExportServices+DisposableLazy`1.#.ctor(System.Func`1<!0>,System.IDisposable)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ExportServices+DisposableLazy`1.#System.IDisposable.Dispose()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ExportServices.#.cctor()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ExportServices.#GetExportedValueFromLazy`1(System.ComponentModel.Composition.Primitives.Export)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ExportServices.#IsDefaultMetadataViewType(System.Type)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ExportServices.#IsDictionaryConstructorViewType(System.Type)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.GenerationServices.#AddItemToLocalDictionary(System.Reflection.Emit.ILGenerator,System.Reflection.Emit.LocalBuilder,System.Object,System.Object)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.GenerationServices.#AddLocalToLocalDictionary(System.Reflection.Emit.ILGenerator,System.Reflection.Emit.LocalBuilder,System.Object,System.Reflection.Emit.LocalBuilder)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.GenerationServices.#CreateGeneratorForPublicConstructor(System.Reflection.Emit.TypeBuilder,System.Type[])")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.GenerationServices.#.cctor()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.GenerationServices.#GetExceptionDataAndStoreInLocal(System.Reflection.Emit.ILGenerator,System.Reflection.Emit.LocalBuilder,System.Reflection.Emit.LocalBuilder)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.GenerationServices.#IsBoxingRequiredForValue(System.Object)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.GenerationServices.#LoadDouble(System.Reflection.Emit.ILGenerator,System.Double)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.GenerationServices.#LoadEnumerable(System.Reflection.Emit.ILGenerator,System.Collections.IEnumerable)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.GenerationServices.#LoadFloat(System.Reflection.Emit.ILGenerator,System.Single)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.GenerationServices.#LoadInt(System.Reflection.Emit.ILGenerator,System.Int32)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.GenerationServices.#LoadLong(System.Reflection.Emit.ILGenerator,System.Int64)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.GenerationServices.#LoadNull(System.Reflection.Emit.ILGenerator)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.GenerationServices.#LoadString(System.Reflection.Emit.ILGenerator,System.String)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.GenerationServices.#LoadTypeOf(System.Reflection.Emit.ILGenerator,System.Type)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.GenerationServices.#LoadValue(System.Reflection.Emit.ILGenerator,System.Object)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ImportAttribute.#.ctor(System.String,System.Type)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ImportCardinalityMismatchException.#.ctor(System.Runtime.Serialization.SerializationInfo,System.Runtime.Serialization.StreamingContext)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ImportCardinalityMismatchException.#.ctor(System.String,System.Exception)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Primitives.ImportDefinition.#.ctor()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Primitives.ImportDefinition.#.ctor(System.String,System.ComponentModel.Composition.Primitives.ImportCardinality,System.Boolean,System.Boolean)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Primitives.ImportDefinition.#IsConstraintSatisfiedBy(System.ComponentModel.Composition.Primitives.ExportDefinition)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Primitives.ImportDefinition.#ToString()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ImportEngine.#Dispose()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ImportEngine.#Dispose(System.Boolean)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ImportEngine+EngineContext.#AddPartManager(System.ComponentModel.Composition.Hosting.ImportEngine+PartManager)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ImportEngine+EngineContext.#Complete()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ImportEngine+EngineContext.#.ctor(System.ComponentModel.Composition.Hosting.ImportEngine,System.ComponentModel.Composition.Hosting.ImportEngine+EngineContext)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ImportEngine+EngineContext.#RemovePartManager(System.ComponentModel.Composition.Hosting.ImportEngine+PartManager)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ImportEngine.#GetEngineContext(System.ComponentModel.Composition.Hosting.AtomicComposition)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ImportEngine.#GetPartManager(System.ComponentModel.Composition.Primitives.ComposablePart,System.Boolean)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ImportEngine.#.ctor(System.ComponentModel.Composition.Hosting.ExportProvider,System.Boolean)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ImportEngine.#InPrerequisiteLoop()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ImportEngine.#OnExportsChanging(System.Object,System.ComponentModel.Composition.Hosting.ExportsChangeEventArgs)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ImportEngine+PartManager.#DisposeAllDependencies()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ImportEngine+PartManager.#GetImportedContractNames()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ImportEngine+PartManager.#GetSavedImport(System.ComponentModel.Composition.Primitives.ImportDefinition)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ImportEngine+PartManager.#.ctor(System.ComponentModel.Composition.Hosting.ImportEngine,System.ComponentModel.Composition.Primitives.ComposablePart)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ImportEngine+PartManager.#SetSavedImport(System.ComponentModel.Composition.Primitives.ImportDefinition,System.ComponentModel.Composition.Primitives.Export[],System.ComponentModel.Composition.Hosting.AtomicComposition)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ImportEngine+PartManager.#State")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ImportEngine+PartManager.#UpdateDisposableDependencies(System.ComponentModel.Composition.Primitives.ImportDefinition,System.Collections.Generic.IEnumerable`1<System.ComponentModel.Composition.Primitives.Export>)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ImportEngine.#PreviewImports(System.ComponentModel.Composition.Primitives.ComposablePart,System.ComponentModel.Composition.Hosting.AtomicComposition)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ImportEngine+RecompositionManager.#AddIndexEntries(System.ComponentModel.Composition.Hosting.ImportEngine+PartManager)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ImportEngine+RecompositionManager.#GetAffectedImports(System.ComponentModel.Composition.Primitives.ComposablePart,System.Collections.Generic.IEnumerable`1<System.ComponentModel.Composition.Primitives.ExportDefinition>)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ImportEngine+RecompositionManager.#GetAffectedParts(System.Collections.Generic.IEnumerable`1<System.String>)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ImportEngine+RecompositionManager.#GetPartsImporting(System.String)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ImportEngine+RecompositionManager.#IsAffectedImport(System.ComponentModel.Composition.Primitives.ImportDefinition,System.Collections.Generic.IEnumerable`1<System.ComponentModel.Composition.Primitives.ExportDefinition>)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ImportEngine+RecompositionManager.#.ctor()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ImportEngine+RecompositionManager.#RemoveIndexEntries(System.ComponentModel.Composition.Hosting.ImportEngine+PartManager)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ImportEngine+RecompositionManager.#UpdateImportIndex()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ImportEngine.#ReleaseImports(System.ComponentModel.Composition.Primitives.ComposablePart,System.ComponentModel.Composition.Hosting.AtomicComposition)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ImportEngine.#SatisfyImports(System.ComponentModel.Composition.Primitives.ComposablePart)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ImportEngine.#SatisfyImportsOnce(System.ComponentModel.Composition.Primitives.ComposablePart)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ImportEngine.#StopSatisfyingImports(System.ComponentModel.Composition.Hosting.ImportEngine+PartManager,System.ComponentModel.Composition.Hosting.AtomicComposition)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ImportEngine.#TryPreviewImportsStateMachine(System.ComponentModel.Composition.Hosting.ImportEngine+PartManager,System.ComponentModel.Composition.Primitives.ComposablePart,System.ComponentModel.Composition.Hosting.AtomicComposition)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ImportEngine.#TryRecomposeImport(System.ComponentModel.Composition.Hosting.ImportEngine+PartManager,System.Boolean,System.ComponentModel.Composition.Primitives.ImportDefinition,System.ComponentModel.Composition.Hosting.AtomicComposition)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ImportEngine.#TryRecomposeImports(System.ComponentModel.Composition.Hosting.ImportEngine+PartManager,System.Collections.Generic.IEnumerable`1<System.ComponentModel.Composition.Primitives.ExportDefinition>,System.ComponentModel.Composition.Hosting.AtomicComposition)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ImportEngine.#TrySatisfyImports(System.ComponentModel.Composition.Hosting.ImportEngine+PartManager,System.ComponentModel.Composition.Primitives.ComposablePart,System.Boolean)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ImportEngine.#TrySatisfyImportsStateMachine(System.ComponentModel.Composition.Hosting.ImportEngine+PartManager,System.ComponentModel.Composition.Primitives.ComposablePart)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.ImportEngine.#TrySatisfyImportSubset(System.ComponentModel.Composition.Hosting.ImportEngine+PartManager,System.Collections.Generic.IEnumerable`1<System.ComponentModel.Composition.Primitives.ImportDefinition>,System.ComponentModel.Composition.Hosting.AtomicComposition)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ImportingConstructorAttribute.#.ctor()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ImportingItem.#Cast(System.Type,System.ComponentModel.Composition.Primitives.Export)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ImportingItem.#CastExportsToCollectionImportType(System.ComponentModel.Composition.Primitives.Export[])")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ImportingItem.#.ctor(System.ComponentModel.Composition.Primitives.ContractBasedImportDefinition,System.ComponentModel.Composition.ReflectionModel.ImportType)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ImportingMember.#EnsureCollectionIsWritable(System.Collections.Generic.ICollection`1<System.Object>)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ImportingMember.#EnsureWritable()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ImportingMember.#GetNormalizedCollection(System.Type,System.Object)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ImportingMember.#PopulateCollection(System.Collections.Generic.ICollection`1<System.Object>,System.Collections.IEnumerable)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ImportingMember.#SetCollectionMemberValue(System.Object,System.Collections.IEnumerable)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ImportingMember.#SetSingleMemberValue(System.Object,System.Object)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ImportManyAttribute.#.ctor(System.String,System.Type)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ImportType.#CreateLazyType(System.Type)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ImportType.#GetStronglyTypedExport(System.ComponentModel.Composition.Primitives.Export)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ImportType.#.ctor(System.Type,System.ComponentModel.Composition.Primitives.ImportCardinality)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ImportType.#IsTypeAssignableCollectionType(System.Type)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ImportType+SpecificLazyType.#.ctor(System.Type,System.Type)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.Lazy`2.#.ctor(System.Func`1<!0>,!1)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.Lazy`2.#.ctor(System.Func`1<!0>,!1,System.Boolean)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.Lazy`2.#.ctor(!1)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.Lazy`2.#.ctor(!1,System.Boolean)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.LazyMemberInfo.#AreAccessorsValid(System.Reflection.MemberTypes,System.Reflection.MemberInfo[],System.String&)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.LazyMemberInfo.#Equals(System.Object)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.LazyMemberInfo.#GetAccessors()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.LazyMemberInfo.#GetHashCode()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.LazyMemberInfo.#.ctor(System.Reflection.MemberInfo)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.LazyMemberInfo.#.ctor(System.Reflection.MemberTypes,System.Reflection.MemberInfo[])")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.LazyMemberInfo.#op_Inequality(System.ComponentModel.Composition.ReflectionModel.LazyMemberInfo,System.ComponentModel.Composition.ReflectionModel.LazyMemberInfo)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.LazyMemberInfo.#op_Equality(System.ComponentModel.Composition.ReflectionModel.LazyMemberInfo,System.ComponentModel.Composition.ReflectionModel.LazyMemberInfo)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.LazyServices.#AsLazy`1(!!0)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.LazyServices.#GetNotNullValue`1(System.Lazy`1<!!0>,System.String)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.Lock.#Dispose()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.Lock.#EnterReadLock()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.Lock.#EnterWriteLock()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.Lock.#ExitReadLock()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.Lock.#ExitWriteLock()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.Lock.#.ctor()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.MetadataAttributeAttribute.#.ctor()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.MetadataServices.#GetValue`1(System.Collections.Generic.IDictionary`2<System.String,System.Object>,System.String)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.MetadataViewGenerator.#GenerateFieldAssignmentFromLocalValue(System.Reflection.Emit.ILGenerator,System.Reflection.Emit.LocalBuilder,System.Reflection.Emit.FieldBuilder)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.MetadataViewGenerator.#GenerateInterfaceViewProxyType(System.Type)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.MetadataViewGenerator.#GenerateLocalAssignmentFromDefaultAttribute(System.Reflection.Emit.ILGenerator,System.ComponentModel.DefaultValueAttribute[],System.Reflection.Emit.LocalBuilder)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.MetadataViewGenerator.#GenerateLocalAssignmentFromFlag(System.Reflection.Emit.ILGenerator,System.Reflection.Emit.LocalBuilder,System.Boolean)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.MetadataViewGenerator.#GenerateView(System.Type)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.MetadataViewGenerator.#.cctor()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.MetadataViewProvider.#GetMetadataView`1(System.Collections.Generic.IDictionary`2<System.String,System.Object>)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.MetadataViewProvider.#IsViewTypeValid(System.Type)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.PartCreationPolicyAttribute.#.ctor(System.ComponentModel.Composition.CreationPolicy)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.PartMetadataAttribute.#.ctor(System.String,System.Object)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.PartNotDiscoverableAttribute.#.ctor()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.ReadLock.#Dispose()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.Collections.ReadOnlyDictionary`2.#Contains(System.Collections.Generic.KeyValuePair`2<!0,!1>)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.Collections.ReadOnlyDictionary`2.#ContainsKey(!0)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.Collections.ReadOnlyDictionary`2.#CopyTo(System.Collections.Generic.KeyValuePair`2<!0,!1>[],System.Int32)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.Collections.ReadOnlyDictionary`2.#Count")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.Collections.ReadOnlyDictionary`2.#GetEnumerator()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.Collections.ReadOnlyDictionary`2.#System.Collections.Generic.ICollection`1<System.Collections.Generic.KeyValuePair`2<!0,!1>>.Add(System.Collections.Generic.KeyValuePair`2<!0,!1>)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.Collections.ReadOnlyDictionary`2.#System.Collections.Generic.ICollection`1<System.Collections.Generic.KeyValuePair`2<!0,!1>>.Clear()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.Collections.ReadOnlyDictionary`2.#System.Collections.Generic.ICollection`1<System.Collections.Generic.KeyValuePair`2<!0,!1>>.Remove(System.Collections.Generic.KeyValuePair`2<!0,!1>)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.Collections.ReadOnlyDictionary`2.#System.Collections.Generic.IDictionary`2<!0,!1>.Add(!0,!1)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.Collections.ReadOnlyDictionary`2.#System.Collections.Generic.IDictionary`2<!0,!1>.Remove(!0)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.Collections.ReadOnlyDictionary`2.#System.Collections.IEnumerable.GetEnumerator()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.Collections.ReadOnlyDictionary`2.#Keys")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.Collections.ReadOnlyDictionary`2.#.ctor(System.Collections.Generic.IDictionary`2<!0,!1>)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.Collections.ReadOnlyDictionary`2.#Item[!0]")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.Collections.ReadOnlyDictionary`2.#TryGetValue(!0,!1&)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.Collections.ReadOnlyDictionary`2.#Values")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.Collections.ReadOnlyDictionaryDebuggerProxy`2.#Items")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.Collections.ReadOnlyDictionaryDebuggerProxy`2.#.ctor(Microsoft.Internal.Collections.ReadOnlyDictionary`2<!0,!1>)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ReflectionComposablePart.#Activate()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ReflectionComposablePart.#CachedInstance")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ReflectionComposablePart.#CreateInstance(System.Reflection.ConstructorInfo,System.Object[])")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ReflectionComposablePart.#EnsureCardinality(System.ComponentModel.Composition.Primitives.ImportDefinition,System.ComponentModel.Composition.Primitives.Export[])")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ReflectionComposablePart.#EnsureGettable()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ReflectionComposablePart.#EnsureSettable(System.ComponentModel.Composition.Primitives.ImportDefinition)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ReflectionComposablePart.#GetConstructorArguments()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ReflectionComposablePart.#GetExportedValue(System.ComponentModel.Composition.Primitives.ExportDefinition)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ReflectionComposablePart.#GetExportingMemberFromDefinition(System.ComponentModel.Composition.Primitives.ExportDefinition)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ReflectionComposablePart.#GetImportingItemFromDefinition(System.ComponentModel.Composition.Primitives.ImportDefinition)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ReflectionComposablePart.#GetInstanceActivatingIfNeeded()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ReflectionComposablePart.#NotifyImportSatisfied()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ReflectionComposablePart.#.ctor(System.ComponentModel.Composition.ReflectionModel.ReflectionComposablePartDefinition)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ReflectionComposablePart.#.ctor(System.ComponentModel.Composition.ReflectionModel.ReflectionComposablePartDefinition,System.Object)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ReflectionComposablePart.#RequiresActivation()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ReflectionComposablePart.#SetImport(System.ComponentModel.Composition.ReflectionModel.ImportingItem,System.ComponentModel.Composition.Primitives.Export[])")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ReflectionComposablePart.#SetNonPrerequisiteImports()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ReflectionComposablePart.#TryGetImportValue(System.ComponentModel.Composition.Primitives.ImportDefinition,System.Object&)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ReflectionComposablePart.#UseImportedValues`1(System.Collections.Generic.IEnumerable`1<!!0>,System.Action`3<System.ComponentModel.Composition.ReflectionModel.ImportingItem,!!0,System.Object>,System.Boolean)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ReflectionComposablePartDefinition.#ExportDefinitions")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ReflectionComposablePartDefinition.#GetConstructor()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ReflectionComposablePartDefinition.#ImportDefinitions")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ReflectionComposablePartDefinition.#Metadata")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ReflectionComposablePartDefinition.#.ctor(System.ComponentModel.Composition.ReflectionModel.IReflectionPartCreationInfo)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ReflectionExtensions.#CreateReflectionProperty(System.Reflection.MethodInfo,System.Reflection.MethodInfo)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ReflectionExtensions.#ToLazyMember(System.Reflection.MemberInfo)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ReflectionExtensions.#ToLazyMember(System.ComponentModel.Composition.ReflectionModel.ReflectionMember)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ReflectionExtensions.#ToReflectionProperty(System.Reflection.PropertyInfo)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ReflectionExtensions.#ToReflectionWritableMember(System.Reflection.MemberInfo)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ReflectionField.#CanWrite")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ReflectionField.#GetValue(System.Object)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ReflectionField.#RequiresInstance")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ReflectionField.#ReturnType")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ReflectionField.#SetValue(System.Object,System.Object)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ReflectionItem.#.ctor()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ReflectionMember.#DeclaringType")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ReflectionMember.#Name")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ReflectionMemberExportDefinition.#GetDisplayName()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ReflectionMemberImportDefinition.#GetDisplayName()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ReflectionMethod.#RequiresInstance")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ReflectionMethod.#ReturnType")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ReflectionModelServices.#GetExportingMember(System.ComponentModel.Composition.Primitives.ExportDefinition)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ReflectionModelServices.#GetImportingMember(System.ComponentModel.Composition.Primitives.ImportDefinition)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ReflectionModelServices.#GetImportingParameter(System.ComponentModel.Composition.Primitives.ImportDefinition)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ReflectionModelServices.#GetPartType(System.ComponentModel.Composition.Primitives.ComposablePartDefinition)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ReflectionModelServices.#IsDisposalRequired(System.ComponentModel.Composition.Primitives.ComposablePartDefinition)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ReflectionModelServices.#IsImportingParameter(System.ComponentModel.Composition.Primitives.ImportDefinition)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ReflectionModelServices+LazyExportDefinition.#Metadata")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ReflectionModelServices+ReflectionPartCreationInfo.#GetConstructor()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ReflectionModelServices+ReflectionPartCreationInfo.#GetMetadata()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ReflectionModelServices+ReflectionPartCreationInfo.#.ctor(System.Lazy`1<System.Type>,System.Boolean,System.Lazy`1<System.Collections.Generic.IEnumerable`1<System.ComponentModel.Composition.Primitives.ImportDefinition>>,System.Lazy`1<System.Collections.Generic.IEnumerable`1<System.ComponentModel.Composition.Primitives.ExportDefinition>>,System.Lazy`1<System.Collections.Generic.IDictionary`2<System.String,System.Object>>,System.ComponentModel.Composition.Primitives.ICompositionElement)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ReflectionParameter.#GetDisplayName()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ReflectionParameter.#Name")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ReflectionParameter.#ReturnType")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ReflectionParameterImportDefinition.#GetDisplayName()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ReflectionParameterImportDefinition.#ToImportingItem()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ReflectionProperty.#CanRead")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ReflectionProperty.#CanWrite")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ReflectionProperty.#GetValue(System.Object)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ReflectionProperty.#Name")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ReflectionProperty.#.ctor(System.Reflection.MethodInfo,System.Reflection.MethodInfo)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ReflectionProperty.#RequiresInstance")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ReflectionProperty.#ReturnType")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ReflectionProperty.#SetValue(System.Object,System.Object)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.ReflectionServices.#GetAllProperties(System.Type)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.ReflectionServices.#GetDisplayName(System.Reflection.MemberInfo)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.ReflectionServices.#GetDisplayName(System.Type,System.String)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.ReflectionServices.#TryGetGenericInterfaceType(System.Type,System.Type,System.Type&)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.Requires.#IsInMembertypeSet(System.Reflection.MemberTypes,System.String,System.Reflection.MemberTypes)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.Requires.#NotNull`1(!!0,System.String)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.Requires.#NotNullElements`1(System.Collections.Generic.IEnumerable`1<!!0>,System.String)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.Requires.#NotNullElements`2(System.Collections.Generic.IEnumerable`1<System.Collections.Generic.KeyValuePair`2<!!0,!!1>>,System.String)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.Requires.#NotNullOrEmpty(System.String,System.String)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Primitives.SerializableCompositionElement.#.ctor(System.String,System.ComponentModel.Composition.Primitives.ICompositionElement)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.Runtime.Serialization.SerializationServices.#GetValue`1(System.Runtime.Serialization.SerializationInfo,System.String)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.StringComparers.#ContractName")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.StringComparers.#MetadataKeyNames")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Diagnostics.TraceSourceTraceWriter.#CanWriteError")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Diagnostics.TraceSourceTraceWriter.#CanWriteInformation")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Diagnostics.TraceSourceTraceWriter.#CanWriteWarning")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Diagnostics.TraceSourceTraceWriter.#.cctor()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Diagnostics.TraceSourceTraceWriter.#WriteEvent(System.Diagnostics.TraceEventType,System.ComponentModel.Composition.Diagnostics.CompositionTraceId,System.String,System.Object[])")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Diagnostics.TraceWriter.#.ctor()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.TypeCatalog.#CreateIndex()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.TypeCatalog.#GetCandidateParts(System.ComponentModel.Composition.Primitives.ImportDefinition)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.TypeCatalog.#GetDisplayName()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.TypeCatalog.#GetExports(System.ComponentModel.Composition.Primitives.ImportDefinition)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.TypeCatalog.#GetTypesDisplay()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.TypeCatalog.#PartsInternal")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Hosting.TypeCatalog.#.ctor(System.Collections.Generic.IEnumerable`1<System.Type>,System.ComponentModel.Composition.Primitives.ICompositionElement)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.Collections.WeakReferenceCollection`1.#Add(!0)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.Collections.WeakReferenceCollection`1.#AliveItemsToList()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.Collections.WeakReferenceCollection`1.#CleanupDeadReferences()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.Collections.WeakReferenceCollection`1.#Clear()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.Collections.WeakReferenceCollection`1.#IndexOf(!0)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.Collections.WeakReferenceCollection`1.#Remove(!0)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.Collections.WeakReferenceCollection`1.#.ctor()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.WriteLock.#Dispose()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.Primitives.ContractBasedImportDefinition.#ValidateRequiredMetadata()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.LazyExportDefinition.#Metadata")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.ReflectionInvoke.#DemandMemberAccess(System.Reflection.MemberInfo)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.ReflectionInvoke.#DemandMemberAccessIfNeeded(System.Type)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.ReflectionInvoke.#DemandRestrictedMemberAccess(System.Reflection.MemberInfo)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.ReflectionInvoke.#.cctor()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.ReflectionInvoke.#SafeCreateInstance(System.Type,System.Object[])")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.ReflectionInvoke.#SafeGetValue(System.Reflection.FieldInfo,System.Object)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.ReflectionInvoke.#SafeInvoke(System.Reflection.ConstructorInfo,System.Object[])")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.ReflectionInvoke.#SafeInvoke(System.Reflection.MethodInfo,System.Object,System.Object[])")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.ReflectionInvoke.#SafeSetValue(System.Reflection.FieldInfo,System.Object,System.Object)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.ReflectionInvoke.#UnsafePermissionSet(System.Reflection.Assembly)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ReflectionPartCreationInfo.#GetConstructor()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ReflectionPartCreationInfo.#GetMetadata()")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.ReflectionModel.ReflectionPartCreationInfo.#.ctor(System.Lazy`1<System.Type>,System.Boolean,System.Lazy`1<System.Collections.Generic.IEnumerable`1<System.ComponentModel.Composition.Primitives.ImportDefinition>>,System.Lazy`1<System.Collections.Generic.IEnumerable`1<System.ComponentModel.Composition.Primitives.ExportDefinition>>,System.Lazy`1<System.Collections.Generic.IDictionary`2<System.String,System.Object>>,System.ComponentModel.Composition.Primitives.ICompositionElement)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.ReflectionServices.#Assembly(System.Reflection.MemberInfo)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.ReflectionServices.#IsVisible(System.Reflection.ConstructorInfo)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.ReflectionServices.#IsVisible(System.Reflection.FieldInfo)")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "Microsoft.Internal.ReflectionServices.#IsVisible(System.Reflection.MethodInfo)")]
[module: SuppressMessage("Microsoft.Design", "CA1032:ImplementStandardExceptionConstructors", Scope = "type", Target = "System.ComponentModel.Composition.ChangeRejectedException")]
[module: SuppressMessage("Microsoft.Usage", "CA2240:ImplementISerializableCorrectly", Scope = "type", Target = "System.ComponentModel.Composition.CompositionException")]
[module: SuppressMessage("Microsoft.Design", "CA1032:ImplementStandardExceptionConstructors", Scope = "type", Target = "System.ComponentModel.Composition.CompositionException")]
[module: SuppressMessage("Microsoft.Security", "CA2116:AptcaMethodsShouldOnlyCallAptcaMethods", Scope = "member", Target = "System.ComponentModel.Composition.CompositionException+CompositionExceptionData.#System.Runtime.Serialization.ISafeSerializationData.CompleteDeserialization(System.Object)")]



