/*###############################################################################
# Linux Management Providers (LMP), Sensors provider package
# Copyright (C) 2009 Shakhrom RUSTAMOV <shahrombek@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#include "assocOpenDRIM_ComputerSystemSensor.h"

int Sensors_OpenDRIM_ComputerSystemSensor_associatorFilter(const CMPIBroker* broker, const CMPIContext* ctx, const CMPIObjectPath* cop, Instance& knownInstance, const char* assocClass, const char* resultClass, const char* role, const char* resultRole, bool& leftToRight, string& errorMessage) {
	_E_;
	string _assocClass, _resultClass, _resultRole, _role;
	assocClass == NULL ? _assocClass = "null" : _assocClass = assocClass;
	resultClass == NULL ? _resultClass = "null" : _resultClass = resultClass;
	resultRole == NULL ?  _resultRole = "null" :  _resultRole = resultRole;
	role == NULL ?  _role = "null" :  _role = role;
	
	for (unsigned int i=0; i<sizeof(OpenDRIM_ComputerSystemSensor_classnames)/sizeof(char*); i++) {
		if (CF_strCmpNoCase(_assocClass, OpenDRIM_ComputerSystemSensor_classnames[i])) {
			_assocClass=OpenDRIM_ComputerSystemSensor_classnames[0];
			break;
		}
	}
	if (!CF_strCmpNoCase(_assocClass, "null") && !CF_strCmpNoCase(_assocClass, OpenDRIM_ComputerSystemSensor_classnames[0]))
		return OK;
	
	Objectpath known(broker, (CMPIObjectPath*) cop);
	int errorCode = CA_associatorResolveDirection(broker, PartComponent_classnames, GroupComponent_classnames, PartComponent_NAMESPACE, GroupComponent_NAMESPACE, PartComponent_role, GroupComponent_role, known, _resultClass, _role, _resultRole, leftToRight);
	if (errorCode != OK)
		return -1;
	
	if (leftToRight) {
		CF_assert(Sensors_OpenDRIM_ComputerSystemSensor_getPartComponent(broker, ctx, known, knownInstance, NULL, errorMessage));
	} else {
		CF_assert(Sensors_OpenDRIM_ComputerSystemSensor_getGroupComponent(broker, ctx, known, knownInstance, NULL, errorMessage));
	}
	_L_;
	return OK;
}

int Sensors_OpenDRIM_ComputerSystemSensor_associator(const CMPIBroker* broker, const CMPIContext* ctx, const CMPIObjectPath* cop, Instance& knownInstance, const char* assocClass, const char* resultClass, const char* role, const char* resultRole, const char** properties, vector<Instance>& associatedInstances, bool& leftToRight, string& errorMessage, const string& dicriminant) {
	_E_;
	int errorCode = Sensors_OpenDRIM_ComputerSystemSensor_associatorFilter(broker, ctx, cop, knownInstance, assocClass, resultClass, role, resultRole, leftToRight, errorMessage);
	if (errorCode == -1)
		return OK;
	if (errorCode != OK)
		return errorCode;
	
	if (leftToRight) {
		if (role != NULL && strcasecmp(role, "PartComponent") != 0) return OK;
		if (resultRole != NULL && strcasecmp(resultRole, "GroupComponent") != 0) return OK;
		CF_assert(Sensors_OpenDRIM_ComputerSystemSensor_associatorPartComponentToGroupComponent(broker, ctx, knownInstance, properties, associatedInstances, errorMessage, dicriminant));
	} else {
		if (role != NULL && strcasecmp(role, "GroupComponent") != 0) return OK;
		if (resultRole != NULL && strcasecmp(resultRole, "PartComponent") != 0) return OK;
		CF_assert(Sensors_OpenDRIM_ComputerSystemSensor_associatorGroupComponentToPartComponent(broker, ctx, knownInstance, properties, associatedInstances, errorMessage, dicriminant));
	}
	_L_;
	return OK;
}

int Sensors_OpenDRIM_ComputerSystemSensor_enumeratePartComponents(const CMPIBroker* broker, const CMPIContext* ctx, vector<Instance>& instances, const char** properties, bool onlyNames, string& errorMessage) {
	_E_;
	/*
	 * CMPI broker version
	 */
	if (onlyNames) {
		vector<Objectpath> objectpaths;
		CF_assert(CB_enumerateInstanceNames(broker, ctx, PartComponent_NAMESPACE, PartComponent_classnames[0], objectpaths, errorMessage));
		for (size_t i=0; i<objectpaths.size(); i++)
			instances.push_back(Instance(broker, objectpaths[i]));
	} else {
		CF_assert(CB_enumerateInstances(broker,ctx, PartComponent_NAMESPACE, PartComponent_classnames[0], properties, instances, errorMessage));
	}
	/*
	 * Direct Invocation version
	 */
	/*
	vector<CIM_LogicalDevice> _instances;
	if (onlyNames) {
		CF_assert(Sensors_CIM_LogicalDevice_retrieve(broker, ctx, _instances, properties, errorMessage, "ein"));
	} else {
		CF_assert(Sensors_CIM_LogicalDevice_retrieve(broker, ctx, _instances, properties, errorMessage, "ei"));
	}

	for (size_t i=0; i<_instances.size(); i++)
		instances.push_back(Instance(broker, Sensors_CIM_LogicalDevice_toCMPIInstance(broker, _instances[i])));
	*/
	_L_;
	return OK;
}

int Sensors_OpenDRIM_ComputerSystemSensor_getPartComponent(const CMPIBroker* broker, const CMPIContext* ctx, const Objectpath& objectpath, Instance& instance, const char** properties, string& errorMessage) {
	_E_;
	if (!CF_strCmpNoCase(objectpath.getClassname(), PartComponent_classnames[0]))
		return INVALID_CLASS;
	//if (!CF_strCmpNoCase(objectpath.getNamespace(), PartComponent_NAMESPACE))
	//	return INVALID_NAMESPACE;
	/*
	 * CMPI broker version
	 */
	CF_assert(CB_getInstance(broker, ctx, objectpath, properties, instance, errorMessage));
	
	/*
	 * Direct Invocation version
	 */
	/*
	CIM_LogicalDevice _instance;
	Sensors_CIM_LogicalDevice_toCPP(broker, objectpath.getHdl(), _instance);
	CF_assert(Sensors_CIM_LogicalDevice_getInstance(broker, ctx, _instance, properties, errorMessage));
	instance = Instance(broker, Sensors_CIM_LogicalDevice_toCMPIInstance(broker, _instance));
	*/
	_L_;
	return OK;
}

int Sensors_OpenDRIM_ComputerSystemSensor_enumerateGroupComponents(const CMPIBroker* broker, const CMPIContext* ctx, vector<Instance>& instances, const char** properties, bool onlyNames, string& errorMessage) {
	_E_;
	/*
	 * CMPI broker version
	 */
	if (onlyNames) {
		vector<Objectpath> objectpaths;
		CF_assert(CB_enumerateInstanceNames(broker, ctx, GroupComponent_NAMESPACE, GroupComponent_classnames[0], objectpaths, errorMessage));
		for (size_t i=0; i<objectpaths.size(); i++)
			instances.push_back(Instance(broker, objectpaths[i]));
	} else {
		CF_assert(CB_enumerateInstances(broker,ctx, GroupComponent_NAMESPACE, GroupComponent_classnames[0], properties, instances, errorMessage));
	}
	/*
	 * Direct Invocation version
	 */
	/*
	vector<CIM_System> _instances;
	if (onlyNames) {
		CF_assert(Sensors_CIM_System_retrieve(broker, ctx, _instances, properties, errorMessage, "ein"));
	} else {
		CF_assert(Sensors_CIM_System_retrieve(broker, ctx, _instances, properties, errorMessage, "ei"));
	}

	for (size_t i=0; i<_instances.size(); i++)
		instances.push_back(Instance(broker, Sensors_CIM_System_toCMPIInstance(broker, _instances[i])));
	*/
	_L_;
	return OK;
}

int Sensors_OpenDRIM_ComputerSystemSensor_getGroupComponent(const CMPIBroker* broker, const CMPIContext* ctx, const Objectpath& objectpath, Instance& instance, const char** properties, string& errorMessage) {
	_E_;
	if (!CF_strCmpNoCase(objectpath.getClassname(), GroupComponent_classnames[0]))
		return INVALID_CLASS;
	//if (!CF_strCmpNoCase(objectpath.getNamespace(), GroupComponent_NAMESPACE))
	//	return INVALID_NAMESPACE;
	/*
	 * CMPI broker version
	 */
	CF_assert(CB_getInstance(broker, ctx, objectpath, properties, instance, errorMessage));

	/*
	 * Direct Invocation version
	 */
	/*
	CIM_System _instance;
	Sensors_CIM_System_toCPP(broker, objectpath.getHdl(), _instance);
	CF_assert(Sensors_CIM_System_getInstance(broker, ctx, _instance, properties, errorMessage));
	instance = Instance(broker, Sensors_CIM_System_toCMPIInstance(broker, _instance));
	*/
	_L_;
	return OK;
}
