/*###############################################################################
# Linux Management Providers (LMP), Battery provider package
# Copyright (C) 2009 Shakhrom RUSTAMOV, TUIT <shahrombek@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#ifndef OPENDRIM_COMPUTERSYSTEMBATTERYACCESS_H_
#define OPENDRIM_COMPUTERSYSTEMBATTERYACCESS_H_

#include "Battery_Common.h"

#include "OpenDRIM_ComputerSystemBattery.h"
#include "assocOpenDRIM_ComputerSystemBattery.h"

int Battery_OpenDRIM_ComputerSystemBattery_load(const CMPIBroker* broker, string& errorMessage);

int Battery_OpenDRIM_ComputerSystemBattery_unload(string& errorMessage);

int Battery_OpenDRIM_ComputerSystemBattery_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_ComputerSystemBattery>& instances, const char** properties, string& errorMessage, const string& discriminant);

int Battery_OpenDRIM_ComputerSystemBattery_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_ComputerSystemBattery& instance, const char** properties, string& errorMessage);

int Battery_OpenDRIM_ComputerSystemBattery_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ComputerSystemBattery& newInstance, const OpenDRIM_ComputerSystemBattery& oldInstance, const char** properties, string& errorMessage);

int Battery_OpenDRIM_ComputerSystemBattery_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ComputerSystemBattery& instance, string& errorMessage);

int Battery_OpenDRIM_ComputerSystemBattery_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ComputerSystemBattery& instance, string& errorMessage);

int Battery_OpenDRIM_ComputerSystemBattery_associatorPartComponentToGroupComponent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& PartComponent_instance, const char** properties, vector<Instance>& GroupComponent_associatedInstances, string& errorMessage, const string& discriminant);

int Battery_OpenDRIM_ComputerSystemBattery_associatorGroupComponentToPartComponent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& GroupComponent_instance, const char** properties, vector<Instance>& PartComponent_associatedInstances, string& errorMessage, const string& discriminant);

int Battery_OpenDRIM_ComputerSystemBattery_referencePartComponentToGroupComponent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& PartComponent_instance, const vector<Instance>& GroupComponent_instances, vector<OpenDRIM_ComputerSystemBattery>& OpenDRIM_ComputerSystemBattery_instances, const char** properties, string& errorMessage, const string& discriminant);

int Battery_OpenDRIM_ComputerSystemBattery_referenceGroupComponentToPartComponent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& GroupComponent_instance, const vector<Instance>& PartComponent_instances, vector<OpenDRIM_ComputerSystemBattery>& OpenDRIM_ComputerSystemBattery_instances, const char** properties, string& errorMessage, const string& discriminant);

int Battery_OpenDRIM_ComputerSystemBattery_populate(OpenDRIM_ComputerSystemBattery& instance, string& errorMessage);

#endif /*OPENDRIM_COMPUTERSYSTEMBATTERYACCESS_H_*/
