static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2013 Michael Henning <drawoc@darkrefraction.com>                 \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_file_path (path, _(\"File\"), \"\")                                  \n"
"    description(_(\"Path of file to load.\"))                                 \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_SOURCE                                                        \n"
"#define GEGL_OP_C_SOURCE webp-load.c                                          \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <webp/decode.h>                                                      \n"
"                                                                              \n"
"static gboolean                                                               \n"
"read_webp (const gchar *path, GeglBuffer *buf, GeglRectangle *bounds_out, const Babl **format_out)\n"
"{                                                                             \n"
"  GMappedFile *map = g_mapped_file_new (path, FALSE, NULL);                   \n"
"                                                                              \n"
"  const gpointer data = g_mapped_file_get_contents (map);                     \n"
"  gsize data_size = g_mapped_file_get_length (map);                           \n"
"                                                                              \n"
"  const Babl* format;                                                         \n"
"  GeglRectangle bounds = {0, };                                               \n"
"                                                                              \n"
"  WebPDecoderConfig config;                                                   \n"
"  if (!WebPInitDecoderConfig (&config) ||                                     \n"
"      WebPGetFeatures (data, data_size, &config.input) != VP8_STATUS_OK)      \n"
"    {                                                                         \n"
"      g_mapped_file_unref (map);                                              \n"
"      return FALSE;                                                           \n"
"    }                                                                         \n"
"                                                                              \n"
"  bounds.width  = config.input.width;                                         \n"
"  bounds.height = config.input.height;                                        \n"
"                                                                              \n"
"  if (config.input.has_alpha)                                                 \n"
"    {                                                                         \n"
"      config.output.colorspace = MODE_RGBA;                                   \n"
"      format = babl_format (\"R'G'B'A u8\");                                  \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      config.output.colorspace = MODE_RGB;                                    \n"
"      format = babl_format (\"R'G'B' u8\");                                   \n"
"    }                                                                         \n"
"                                                                              \n"
"  if (buf)                                                                    \n"
"    {                                                                         \n"
"      if (WebPDecode (data, data_size, &config) != VP8_STATUS_OK)             \n"
"        {                                                                     \n"
"          WebPFreeDecBuffer (&config.output);                                 \n"
"          g_mapped_file_unref (map);                                          \n"
"          return FALSE;                                                       \n"
"        }                                                                     \n"
"                                                                              \n"
"      gegl_buffer_set (buf, &bounds, 0, format, config.output.u.RGBA.rgba,    \n"
"                       config.output.u.RGBA.stride);                          \n"
"                                                                              \n"
"      WebPFreeDecBuffer (&config.output);                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  if (bounds_out)                                                             \n"
"    *bounds_out = bounds;                                                     \n"
"                                                                              \n"
"  if (format_out)                                                             \n"
"    *format_out = format;                                                     \n"
"                                                                              \n"
"  g_mapped_file_unref (map);                                                  \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_bounding_box (GeglOperation *operation)                                   \n"
"{                                                                             \n"
"  GeglProperties   *o = GEGL_PROPERTIES (operation);                          \n"
"  GeglRectangle result = {0,0,0,0};                                           \n"
"  const Babl   *format = NULL;                                                \n"
"                                                                              \n"
"  read_webp (o->path, NULL, &result, &format);                                \n"
"                                                                              \n"
"  if (format)                                                                 \n"
"    gegl_operation_set_format (operation, \"output\", format);                \n"
"                                                                              \n"
"  return result;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  return read_webp (o->path, output, NULL, NULL);                             \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_cached_region (GeglOperation       *operation,                            \n"
"                   const GeglRectangle *roi)                                  \n"
"{                                                                             \n"
"  return get_bounding_box (operation);                                        \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationSourceClass *source_class;                                     \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  source_class    = GEGL_OPERATION_SOURCE_CLASS (klass);                      \n"
"                                                                              \n"
"  source_class->process = process;                                            \n"
"  operation_class->get_bounding_box = get_bounding_box;                       \n"
"  operation_class->get_cached_region = get_cached_region;                     \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",         \"gegl:webp-load\",                                     \n"
"    \"title\",        _(\"WebP File Loader\"),                                \n"
"    \"categories\"  , \"hidden\",                                             \n"
"    \"description\" , _(\"WebP image loader.\"),                              \n"
"    NULL);                                                                    \n"
"                                                                              \n"
"  gegl_extension_handler_register (\".webp\", \"gegl:webp-load\");            \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
