/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.geom2d;

import java.util.HashMap;
import org.web3d.vrml.lang.FieldConstants;
import org.web3d.vrml.lang.InvalidFieldAccessException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.LocalColorsListener;
import org.web3d.vrml.nodes.TexCoordGenModeListener;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLGeometryNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.AbstractNode;

public abstract class BaseTriangleSet2D
extends AbstractNode
implements VRMLGeometryNodeType {
    protected static final int FIELD_SOLID = 1;
    protected static final int FIELD_VERTICES = 2;
    private static final int LAST_TRISET2D_INDEX = 2;
    private static final int NUM_FIELDS = 3;
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static int[] nodeFields;
    protected float[] vfVertices = FieldConstants.EMPTY_MFVEC2F;
    protected int numVertices;
    protected boolean vfSolid = false;

    protected BaseTriangleSet2D() {
        super("TriangleSet2D");
        this.hasChanged = new boolean[3];
    }

    protected BaseTriangleSet2D(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("point");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfVertices = new float[vRMLFieldData.numElements * 2];
                System.arraycopy(vRMLFieldData.floatArrayValue, 0, this.vfVertices, 0, vRMLFieldData.numElements * 2);
                this.numVertices = vRMLFieldData.numElements * 2;
            }
            n = vRMLNodeType.getFieldIndex("solid");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfSolid = vRMLFieldData.booleanValue;
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public boolean hasLocalColors() {
        return false;
    }

    public boolean hasLocalColorAlpha() {
        return false;
    }

    public void addLocalColorsListener(LocalColorsListener localColorsListener) {
    }

    public void removeLocalColorsListener(LocalColorsListener localColorsListener) {
    }

    public void addTexCoordGenModeChanged(TexCoordGenModeListener texCoordGenModeListener) {
    }

    public void removeTexCoordGenModeChanged(TexCoordGenModeListener texCoordGenModeListener) {
    }

    public String getTexCoordGenMode(int n) {
        return null;
    }

    public int getNumSets() {
        return 0;
    }

    public boolean isSolid() {
        return this.vfSolid;
    }

    public boolean isCCW() {
        return true;
    }

    public boolean isLightingEnabled() {
        return true;
    }

    public int getPrimaryType() {
        return 21;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 2: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfVertices;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = this.numVertices / 2;
                break;
            }
            case 1: {
                vRMLFieldData.clear();
                vRMLFieldData.booleanValue = this.vfSolid;
                vRMLFieldData.dataType = 1;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 2) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        switch (n) {
            case 2: {
                vRMLNodeType.setValue(n2, this.vfVertices, this.numVertices);
                break;
            }
            default: {
                super.sendRoute(d, n, vRMLNodeType, n2);
            }
        }
    }

    public void setValue(int n, boolean bl) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 1: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field:  solid");
                }
                this.vfSolid = bl;
                break;
            }
            default: {
                super.setValue(n, bl);
            }
        }
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 2: {
                this.setVertices(fArray, n2);
                break;
            }
            default: {
                super.setValue(n, fArray, n2);
            }
        }
    }

    protected void setVertices(float[] fArray, int n) throws InvalidFieldValueException {
        if (this.vfVertices.length < n) {
            this.vfVertices = new float[n];
        }
        System.arraycopy(fArray, 0, this.vfVertices, 0, n);
        this.numVertices = n;
        if (!this.inSetup) {
            this.hasChanged[2] = true;
            this.fireFieldChanged(2);
        }
    }

    static {
        nodeFields = new int[]{0};
        fieldDecl = new VRMLFieldDeclaration[3];
        fieldMap = new HashMap(9);
        BaseTriangleSet2D.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseTriangleSet2D.fieldDecl[2] = new VRMLFieldDeclaration(3, "MFVec2f", "vertices");
        BaseTriangleSet2D.fieldDecl[1] = new VRMLFieldDeclaration(2, "SFBool", "solid");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(2);
        fieldMap.put("vertices", n);
        fieldMap.put("set_vertices", n);
        fieldMap.put("vertices_changed", n);
        fieldMap.put("solid", new Integer(1));
    }
}

