/*
 * Copyright (C) 2013 Canonical, Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef NOTESAPPLICATION_H
#define NOTESAPPLICATION_H

#include <QObject>

class NotesApplication : public QObject
{
    Q_OBJECT
    Q_PROPERTY(QString applicationName READ applicationName WRITE setApplicationName
               NOTIFY applicationNameChanged)

public:
    NotesApplication(QObject* parent = 0);
    QString applicationName() const;
    void setApplicationName(QString& applicationName);

Q_SIGNALS:
    void aboutToQuit();
    void applicationNameChanged();
};

#endif // NOTESAPPLICATION_H
