" Vim syntax file
" Language: DDTP files - common defs for Italian version of Client syntax
" Maintainer: Lorenzo Cappelletti <lorenzo.cappelletti@email.it>
" Last Change: 

" For copyright statement and stuff, see file ddtpCom.vim



syntax match  ddtpComItErrE		/[AaEeIiOUu]['`]\|o`/	contained	" Wrong accents
syntax match  ddtpComItErrE		/\( p\)\@<!o'/		contained
syntax match  ddtpComItErrQuotes	/[Lln]'\zs \+/		contained	" Only double quotes!
syntax match  ddtpComItErrQuotes	/ \+\zs'/		contained
syntax match  ddtpComItErrQuotes	/`/			contained
syntax match  ddtpComItErrMispells	/\c\<men\zsu\ze\>/	contained	" Men
syntax match  ddtpComItErrMispells	/\c\<fittiz\zsz\zeio\>/	contained	" Fittizio
syntax match  ddtpComItErrMispells	/\c\<un\zs'\zealtro\>/	contained	" Un altro
syntax match  ddtpComItErrMispells	/\c\<off\zs \zeline\>/	contained	" Off-line

syntax cluster  ddtpComItErr  contains=ddtpComErrWSpaceMultiSent,ddtpComErrWSpacePunct,ddtpComItErr.*

highlight def link ddtpComItErrE		ddtpComErr
highlight def link ddtpComItErrQuotes		ddtpComErr
highlight def link ddtpComItErrMispells		ddtpComErr

