/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.util.ResourceBundleUtil;

public class TransformEdit
extends AbstractUndoableEdit {
    private Collection<Figure> figures;
    private AffineTransform tx;

    public TransformEdit(Figure figure, AffineTransform affineTransform) {
        this.figures = new LinkedList<Figure>();
        ((LinkedList)this.figures).add(figure);
        this.tx = (AffineTransform)affineTransform.clone();
    }

    public TransformEdit(Collection<Figure> collection, AffineTransform affineTransform) {
        this.figures = collection;
        this.tx = (AffineTransform)affineTransform.clone();
    }

    @Override
    public String getPresentationName() {
        ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
        return resourceBundleUtil.getString("edit.transform.text");
    }

    @Override
    public boolean addEdit(UndoableEdit undoableEdit) {
        if (undoableEdit instanceof TransformEdit) {
            TransformEdit transformEdit = (TransformEdit)undoableEdit;
            if (transformEdit.figures == this.figures) {
                this.tx.concatenate(transformEdit.tx);
                transformEdit.die();
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean replaceEdit(UndoableEdit undoableEdit) {
        if (undoableEdit instanceof TransformEdit) {
            TransformEdit transformEdit = (TransformEdit)undoableEdit;
            if (transformEdit.figures == this.figures) {
                this.tx.preConcatenate(transformEdit.tx);
                transformEdit.die();
                return true;
            }
        }
        return false;
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        for (Figure figure : this.figures) {
            figure.willChange();
            figure.transform(this.tx);
            figure.changed();
        }
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        try {
            AffineTransform affineTransform = this.tx.createInverse();
            for (Figure figure : this.figures) {
                figure.willChange();
                figure.transform(affineTransform);
                figure.changed();
            }
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            noninvertibleTransformException.printStackTrace();
        }
    }

    @Override
    public String toString() {
        return this.getClass().getName() + '@' + this.hashCode() + " tx:" + this.tx;
    }
}

