/* Xymon Client V1.2 for VSE/ESA and z/VSE
    Copyright (C) 2003-2010 Richard Smrcina
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of
    the License, or (at your option) any later version.
 
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
    See the GNU General Public License for more details.
 
    http://www.gnu.org/licenses/old-licenses/gpl-2.0.html            */
/*  This send the client data package to Xymon.
 
   Rich Smrcina: First use                       01/17/2007
   Rich Smrcina: Changed project name to Xymon   02/10/2009
                                                                      */
parse arg lib cfgmode .
cr='0a'x      /*  Carriage return */
/*  Retrieve options member from PRD2.CONFIG                     */
'execio * diskr 'lib'.hobvars.z (stem hobvars. finis'
/*  Init local variables first  */
bbdisplay=''
bbport=''
domainname=''
hostname=''
/*  Go through options table to fill values to run the client    */
do i=1 to hobvars.0
  if left(hobvars.i,1)='#' then iterate   /* Ignore comment */
  parse var hobvars.i kw value
  value=strip(value,'B')
  select
    when kw='bbdisplay' then
      bbdisplay=value
    when kw='bbport' then
      bbport=value
    when kw='domainname' then
      domainname=value
    when kw='hostname' then
      hostname=value
    otherwise
      nop
    end
  end
call init_values
/*  The operating system identification in the client data stream
    depends upon the configuration mode.  If we are in local config
    mode (cfgmode='client') then we look like a Linux system and
    send the basic info.  If we are in server config mode
    (cfgmode='server') then we identify ourselves as vse.           */
if cfgmode='SERVER' then do
  cdata='client 'hostname'.zvse zvse'||cr
  members='hobvsedt hobvseos hobvseup hobvsecp hobvsepg hobvsepr' ,
          'hobvsedu hobvsepo hobvseci hobvseme hobvsegv hobvsenp'
  end
else do
  cdata='client 'hostname'.linux linux'||cr
  members='hobvsedt hobvseos hobvsepo'
  end
z=rexxmsg('OFF')
/*  Get client data members, copy to stem to send to Hobbit    */
do i=1 to words(members)
  'execio * diskr' lib'.'word(members,i)'.data (stem odata. finis'
/* odata is input member data stem,
   cdata is the client data package variable for Hobbit          */
  do k=1 to odata.0
    cdata=cdata||strip(odata.k,'T')||cr
    end
  end
 
y=rexxmsg(z)
/*  Send the data to Xymon                                       */
do i=1 to words(bbdisplay)
  tempdisp=word(bbdisplay,i)
  parse var tempdisp bbdisp ':' bbprt
  if bbprt='' then bbprt=bbport
  call open_socket            /* Open the socket                 */
  call send_to_bb cdata       /* Send the whole chunk to Xymon   */
  call close_socket           /* Close the socket                */
  end
call term_socket
return
 
send_to_bb:
parse arg data
data=toascii(data)
ret=Socket('Send',sid,data)
parse var ret rc .
if rc<>0 then
  say 'Send:' ret
return
 
toascii:
parse arg buffer
buffer=translate(buffer,asc,ebc)
return buffer
 
open_socket:
ret=socket('Socket','AF_INET','Sock_Stream',0)
parse var ret rc .
if rc<>0 then
  say 'Socket:' ret
parse var ret rc sid .
name='AF_INET' bbprt bbdisp
ret=socket('Connect',sid,name)
parse var ret rc .
if rc<>0 then
  say 'Connect:' ret
return
 
close_socket:
ret=Socket('Close',sid)
parse var ret rc .
if rc<>0 then
  say 'Close:' ret
return
 
term_socket:
ret=Socket('Terminate')
parse var ret rc .
if rc<>0 then
  say 'Terminate:' ret
return
 
init_values:
ret=socket('Initialize','hobvse')  /* Init the socket here   */
parse var ret rc .                 /* for gethostname        */
if rc<>0 then
  say 'Initialize:' ret
ebc=' !"#$%&'||'7D'X||'()*+,-./012' ,
    '3456789:;<=>?@ABCDE' ,
    'FGHIJKLMNOPQRSTUVWX' ,
    'YZ[\]5_`abcdefghijk' ,
    'lmnopqrstuvwxyz{|}~'
asc='202122232425262728292A2B2C2D2E2F303132'x ,
    '333435363738393A3B3C3D3E3F404142434445'x ,
    '464748494A4B4C4D4E4F505152535455565758'x ,
    '595A5B5C5D5E5F606162636465666768696A6B'x ,
    '6C6D6E6F707172737475767778797A7B7C7D7E'x
if hostname='' then do
  ret=socket('Gethostname')
  parse var ret rc hostname .
  if rc<>0 then
    say 'Gethostname:' ret
  hostname=lower(hostname)
  end
if domainname='' then
  fqdn=hostname
else
  fqdn=hostname||'.'||domainname
/*  Change periods to commas  */
fqdn=translate(fqdn,',','.')
return
 
/*  Convert parameter to lower case.  */
lower:
arg string
lc_chars='abcdefghijklmnopqrstuvwxyz'
uc_chars='ABCDEFGHIJKLMNOPQRSTUVWXYZ'
string=translate(string,lc_chars,uc_chars)
return string
