/*
 * kbd.c - keyboard input functions
 * Copyright (c) 2006 Sascha Sommer <ssommer@suse.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 
 based on osdep/getch2.c from MPlayer (http://www.mplayerhq.hu) 
 Copyright (c) 1999 A'rpi/ESP-team <arpi@thot.banki.hu>

*/


/* GyS-TermIO v2.0 (for GySmail v3)          (C) 1999 A'rpi/ESP-team */


#define MAX_KEYS 64
#define BUF_LEN 256

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/time.h>
#include <sys/types.h>
#include <termios.h>

#include <unistd.h>

#include "kbd.h"

static int getch2_len=0;
static char getch2_buf[BUF_LEN];

int getch2(void){
  int len=0;
  int code=0;
  int time=0;

  while(!getch2_len || (getch2_len==1 && getch2_buf[0]==27)){
    fd_set rfds;
    struct timeval tv;
    int retval;
    /* Watch stdin (fd 0) to see when it has input. */
    FD_ZERO(&rfds); FD_SET(0,&rfds);
    /* Wait up to 'time' microseconds. */
    tv.tv_sec=time/1000; tv.tv_usec = (time%1000)*1000;
    retval=select(1, &rfds, NULL, NULL,  &tv);
    if(retval<=0) return -1;
    /* Data is available now. */
    retval=read(0,&getch2_buf[getch2_len],BUF_LEN-getch2_len);
    if(retval<1) return -1;
    getch2_len+=retval;
  }

    len=1;code=getch2_buf[0];
    /* Check the well-known codes... */
    if(code!=27){
      if(code=='A'-64){ code=KEY_HOME; goto found;}
      if(code=='E'-64){ code=KEY_END; goto found;}
      if(code=='D'-64){ code=KEY_DEL; goto found;}
      if(code=='H'-64){ code=KEY_BS; goto found;}
      if(code=='U'-64){ code=KEY_PGUP; goto found;}
      if(code=='V'-64){ code=KEY_PGDWN; goto found;}
      if(code==8 || code==127){ code=KEY_BS; goto found;}
      if(code==10 || code==13){
        if(getch2_len>1){
          int c=getch2_buf[1];
          if(c==10 || c==13) if(c!=code) len=2;
        }
        code=KEY_ENTER;
        goto found;
      }
    } else if(getch2_len>1){
      int c=getch2_buf[1];
      if(c==27){ code=KEY_ESC; len=2; goto found;}
      if(c>='0' && c<='9'){ code=c-'0'+KEY_F; len=2; goto found;}
      if(getch2_len>=4 && c=='[' && getch2_buf[2]=='['){
        int c=getch2_buf[3];
        if(c>='A' && c<'A'+12){ code=KEY_F+1+c-'A';len=4;goto found;}
      }
      if(c=='[' || c=='O') if(getch2_len>=3){
        int c=getch2_buf[2];
        static short int ctable[]={ KEY_UP,KEY_DOWN,KEY_RIGHT,KEY_LEFT,0,
                       KEY_END,KEY_PGDWN,KEY_HOME,KEY_PGUP,0,0,KEY_INS,0,0,0,
                       KEY_F+1,KEY_F+2,KEY_F+3,KEY_F+4};
        if(c>='A' && c<='S')
          if(ctable[c-'A']){ code=ctable[c-'A']; len=3; goto found;}
      }
      if(getch2_len>=4 && c=='[' && getch2_buf[3]=='~'){
        int c=getch2_buf[2];
        int ctable[8]={KEY_HOME,KEY_INS,KEY_DEL,KEY_END,KEY_PGUP,KEY_PGDWN,KEY_HOME,KEY_END};
        if(c>='1' && c<='8'){ code=ctable[c-'1']; len=4; goto found;}
      }
      if(getch2_len>=5 && c=='[' && getch2_buf[4]=='~'){
        int i=getch2_buf[2]-'0';
        int j=getch2_buf[3]-'0';
        if(i>=0 && i<=9 && j>=0 && j<=9){
          static short int ftable[20]={
            11,12,13,14,15, 17,18,19,20,21,
            23,24,25,26,28, 29,31,32,33,34 };
          int a=i*10+j;
          for(i=0;i<20;i++) if(ftable[i]==a){ code=KEY_F+1+i;len=5;goto found;}
        }
      }
    }
found:
  if((getch2_len-=len)>0){
    int i;
    for(i=0;i<getch2_len;i++) getch2_buf[i]=getch2_buf[len+i];
  }
  return code;
}



static struct termios tio_orig;
static int kbd_inited=0;

void kbd_enable(void){
    if(!kbd_inited){
        struct termios tio_new;
        tcgetattr(0,&tio_orig);
        tio_new=tio_orig;
        tio_new.c_lflag &= ~(ICANON|ECHO); /* Clear ICANON and ECHO. */
        tio_new.c_cc[VMIN] = 1;
        tio_new.c_cc[VTIME] = 0;
        tcsetattr(0,TCSANOW,&tio_new);
        ++kbd_inited;
    }
}

void kbd_disable(void){
    if(kbd_inited)
        tcsetattr(0,TCSANOW,&tio_orig);
}


