#!/usr/bin/python

# Arnau Sanchez <tokland@gmail.com>
import os, sys
import copy, time

###############################
###############################
class Sudoku:
	###############################
	def __init__(self, sudoku = None):
		self.sudoku = sudoku

	###############################
	def print_nums(self):
		for line in self.sudoku:
			for value in line:
				if value == 0: print "-",
				else: print value,
			print

	###############################
	def load(self, file):
		sudoku = []
		fd = open(file)
		for line in fd.readlines():
			if line[0] == "#":	continue
			sline = []
			for c in line[:9]:
				if c == '-': sline.append(0)
				else: sline.append(int(c))	
			sudoku.append(sline)
		self.sudoku = sudoku
	
	###############################
	def get_values_in_line(self, line):
		return copy.deepcopy(self.sudoku[line])

	###############################
	def get_values_in_column(self, column):
		values1 = []
		for line in self.sudoku:
			values1.append(line[column])
		return values1

	###############################
	def get_values_in_square(self, line, column):
		line = 3 * (line / 3)
		column = 3 * (column / 3)
		values = []
		for l in self.sudoku[line:line+3]:
			for c in l[column:column + 3]:
				values.append(c)
		return values
				
		
	###############################
	def solve(self, deep=0, verbose = False):
		for nline, line in enumerate(self.sudoku):
			for ncolumn, column in enumerate(line):
				if column > 0: 
					continue
				forbidden = self.get_values_in_line(nline)
				forbidden += self.get_values_in_column(ncolumn)
				forbidden += self.get_values_in_square(nline, ncolumn)
				if verbose:
					self.print_nums()

				for test_value in range(1,10):
					if test_value in forbidden:
						continue
					sudoku = copy.deepcopy(self.sudoku)
					sudoku[nline][ncolumn] = test_value
					new_sudoku = Sudoku(sudoku)
					solution = new_sudoku.solve(deep+1)
					if solution:
						return solution
				return
		return self

##############################
### MAIN
##############################

if len(sys.argv) < 2:
	print "usage: sudoku.py file"
	sys.exit(1)
file = sys.argv[1]
sudoku = Sudoku()
sudoku.load(file)
sudoku.print_nums()
t1 = time.time()
solution = sudoku.solve()
soltime = time.time() -t1
print "(solution found in %0.3f seconds)" %soltime
solution.print_nums()
sys.exit(0)
