<?php
$languageNames = array(
	/* Not in CLDR 21.0.1. Name "Arabic, Tunisian Spoken" used by Ethnologue:
	 * http://www.ethnologue.com/show_language.asp?code=aeb
	 * Added 2012-11-13.
	 */
	'aeb' => 'アラビア語チュニジア方言',

	/* Not in CLDR 21.0.1. Name Gheg Albanian used by Ethnologue:
	 * http://www.ethnologue.com/show_language.asp?code=aln
	 * Added 2008-01-04.
	 */
	// 'aln' => 'Gheg Albanian',

	/* Not in CLDR 21.0.1. Arabic language
	 * http://www.ethnologue.com/show_language.asp?code=arq
	 * Added 2009-08-27.
	 */
	'arq' => 'アラビア語アルジェリア方言',

	/* Not in CLDR 21.0.1. Arabic language
	 * http://www.ethnologue.com/show_language.asp?code=ary
	 * Added 2008-04-12.
	 */
	'ary' => 'アラビア語モロッコ方言',

	/* Not in CLDR 21.0.1. Arabic language
	 * http://www.ethnologue.com/show_language.asp?code=arz
	 * Added 2009-08-23.
	 */
	'arz' => 'アラビア語エジプト方言',

	/* Not in CLDR 21.0.1. Southern Turkic
	 * http://www.ethnologue.com/show_language.asp?code=azb
	 * Added 2012-11-28.
	 */
	'azb' => '南部アゼルバイジャン語',

	/* Not in CLDR 21.0.1. Name Bavarian used by Ethnologue:
	 * http://www.ethnologue.com/show_language.asp?code=bar
	 * Added 2007-11-10.
	 */
	'bar' => 'バイエルン・オーストリア語',

	/* Not in CLDR 21.0.1. Balochi language
	 * http://www.ethnologue.org/show_language.asp?code=bcc
	 * Added 2008-07-02.
	 */
	'bcc' => '南部バローチー語',

	/* Not in CLDR 21.0.1. Betawi language.
	 * http://www.ethnologue.com/show_language.asp?code=bew
	 * Added 2011-11-10.
	 */
	'bew' => 'ベタウィ語',

	/* Not in CLDR 21.0.1. Malay language.
	 * http://www.ethnologue.org/show_language.asp?code=bjn
	 * Added 2011-09-10.
	 */
	// 'bjn' => 'Banjar',

	/* Not in CLDR 21.0.1. Name Bishnupriya used by Ethnologue:
	 * http://www.ethnologue.org/show_language.asp?code=bpy
	 * Added 2007-11-10.
	 */
	'bpy' => 'ビシュヌプリヤ・マニプリ語',

	/* Not in CLDR 21.0.1. Luri language
	 * http://www.ethnologue.org/show_language.asp?code=bqi
	 * Added 2007-11-10.
	 */
	// 'bqi' => 'Bakhtiari',

	/* Not in CLDR 21.0.1. Bihari language
	 * http://www.ethnologue.org/show_language.asp?code=brh
	 * Added 2011-04-16.
	 */
	'brh' => 'ブラーフーイー語',

	/* Not in CLDR 21.0.1. Bisayan language
	 * http://www.ethnologue.org/show_language.asp?code=cps
	 * Added 2010-01-11.
	 */
	// 'cps' => 'Capiznon',

	/* Not in CLDR 21.0.1. Swedish language
	 * http://www.ethnologue.org/show_language.asp?code=dlc
	 * Added 2008-02-16.
	 */
	// 'dlc' => 'Dalecarlian',

	/* Not in CLDR 21.0.1. Central Dusun language
	 * http://www.ethnologue.org/show_language.asp?code=dtp
	 * Added 2011-04-16.
	 */
	// 'dtp' => 'Central Dusun',

	/* Not in CLDR 21.0.1. Romance language.
	 * http://www.ethnologue.org/show_language.asp?code=eml
	 * Added 2008-01-17.
	 */
	'eml' => 'エミリア・ロマーニャ語',

	/* Not in CLDR 21.0.1. Romance language.
	 * http://www.ethnologue.org/show_language.asp?code=ext
	 * Added 2007-12-02.
	 */
	'ext' => 'エストレマドゥーラ語',

	/* Not in CLDR 21.0.1. Variety of French.
	 * http://www.ethnologue.org/show_language.asp?code=frc
	 * Added 2007-12-02.
	 */
	// 'frc' => 'Cajun French',

	/* Not in CLDR 21.0.1. Romance language.
	 * http://www.ethnologue.org/show_language.asp?code=frp
	 * Added 2007-12-02.
	 */
	'frp' => 'アルピタン語',

	/* Not in CLDR 21.0.1. Chinese language.
	 * http://www.ethnologue.org/show_language.asp?code=hak
	 * Added 2007-12-02.
	 */
	'hak' => '客家語',

	/* Not in CLDR 21.0.1. Turkic language.
	 * Added 2008-01-14.
	 */
	// 'gag' => 'Gagauz',

	/* Not in CLDR 21.0.1. Chinese language.
	 * http://www.ethnologue.org/show_language.asp?code=gan
	 * Added 2007-12-02.
	 */
	//'gan' => 'Gan',

	/* Not in CLDR 21.0.1. Konkani language
	 * http://www.ethnologue.org/show_language.asp?code=gom
	 * Added 2008-09-02.
	 */
	// 'gom' => 'Goan Konkani',
	// 'gom-deva' => 'Goan Konkani (Devanagari script)',
	// 'gom-latn' => 'Goan Konkani (Latin script)',
	// 'gom-knda' => 'Goan Konkani (Kannada script)',
	// 'gom-mlym' => 'Goan Konkani (Malayalam script)',
	// 'gom-arab' => 'Goan Konkani (Arabic script)',

	/* Not in CLDR 21.0.1. Western Atlantic Creole language
	 * http://www.ethnologue.org/show_language.asp?code=dtp
	 * Added 2011-04-16.
	 */
	'jam' => 'ジャマイカ・クレオール語',

	/* Not in CLDR 21.0.1. Danish language.
	 * http://www.ethnologue.org/show_language.asp?code=jut
	 * Added 2008-02-06.
	 */
	// 'jut' => 'Jutish',

	/* Not in CLDR 21.0.1. Chitral language
	 * http://www.ethnologue.org/show_language.asp?code=khw
	 * Added 2011-04-16.
	 */
	'khw' => 'コワール語',

	/* Not in CLDR 21.0.1. Zaza-Gorani language.
	 * http://www.ethnologue.org/show_language.asp?code=kiu
	 * Added 2009-10-08.
	 */
	// 'kiu' => 'Kirmanjki',

	/* Not in CLDR 21.0.1. Komi language.
	 * http://www.ethnologue.org/show_language.asp?code=koi
	 * Added 2010-01-02.
	 */
	// 'koi' => 'Komi-Permyak',

	/* Not in CLDR 21.0.1. Artificial language.
	 * http://www.ethnologue.org/show_language.asp?code=lfn
	 * Added 2008-01-18.
	 */
	// 'lfn' => 'Lingua Franca Nova',

	/* Not in CLDR 21.0.1. Latvian language
	 * http://www.sil.org/iso639-3/documentation.asp?id=ltg
	 * Added 2010-04-03.
	 */
	// 'ltg' => 'Latgalian',

	/* Not in CLDR 21.0.1. Literary Chinese language
	 * http://www.sil.org/iso639-3/documentation.asp?id=lzh
	 * Added 2009-01-22.
	 */
	// 'lzh' => 'Literary Chinese',

	/* Not in CLDR 21.0.1. Mari language
	 * http://www.ethnologue.org/show_language.asp?code=mhr
	 * Added 2008-05-22.
	 */
	'mhr' => '東部マリ語',

	/* Not in CLDR 21.0.1. Mari language
	 * http://www.ethnologue.org/show_language.asp?code=mrj
	 * Added 2009-11-22.
	 */
	'mrj' => '山地マリ語',

	/* Not in CLDR 21.0.1. Malay language
	 * http://www.ethnologue.org/show_language.asp?code=mui
	 * Added 2010-02-11.
	 */
	// 'mui' => 'Musi',

	/* Not in CLDR 21.0.1. Caspian language
	 * http://www.ethnologue.org/show_language.asp?code=mzn
	 * Added 2008-03-01.
	 */
	'mzn' => 'マーザンダラーン語',

	/* Not in CLDR 21.0.1. Chinese language
	 * http://www.ethnologue.org/show_language.asp?code=nan
	 * Added 2008-03-01.
	 */
	'nan' => '閩南語',

	/* Not in CLDR 21.0.1. Tibeto-Burman family language.
	 * http://www.ethnologue.org/show_language.asp?code=njo
	 * Added 2008-01-14.
	 */
	// 'njo' => 'Ao Naga',

	/* Not in CLDR 21.0.1. Gallo-Italian language.
	 * http://www.ethnologue.org/show_language.asp?code=pms
	 * Added 2008-07-09.
	 */
	'pms' => 'ピエモンテ語',

	/* Not in CLDR 21.0.1. Lahnda language.
	 * http://www.ethnologue.org/show_language.asp?code=pnb
	 * Added 2008-10-29.
	 */
	// 'pnb' => 'Western Punjabi',

	/* Not in CLDR 21.0.1. Attic language.
	 * http://www.ethnologue.org/show_language.asp?code=pnt
	 * Added 2008-01-18.
	 */
	// 'pnt' => 'Pontic',

	/* Not in CLDR 21.0.1. Western Baltic language.
	 * http://www.ethnologue.org/show_language.asp?code=prg
	 * Added 2009-11-22.
	 */
	// 'prg' => 'Prussian',

	/* Not in CLDR 21.0.1. Gallo-Italic language.
	 * http://www.sil.org/iso639-3/documentation.asp?id=rgn
	 * Added 2009-11-15.
	 */
	// 'rgn' => 'Romagnol',

	/* Not in CLDR 21.0.1. East Slavic language.
	 * http://www.ethnologue.com/show_language.asp?code=rue
	 * Added 2010-04-03.
	 */
	// 'rue' => 'Rusyn',

	/* Not in CLDR 21.0.1. Eastern Romance language.
	 * http://www.ethnologue.org/show_language.asp?code=ruq
	 * Added 2008-02-04.
	 */
	// 'ruq' => 'Megleno-Romanian',
	// 'ruq-cyrl' => 'Megleno-Romanian (Cyrillic script)',
	// 'ruq-grek' => 'Megleno-Romanian (Greek script)',
	// 'ruq-latn' => 'Megleno-Romanian (Latin script)',

	/* Not in CLDR 21.0.1.
	 * http://www.sil.org/iso639-3/documentation.asp?id=sgs
	 * Added 2010-10-14.
	 */
	// 'sgs' => 'Samogitian',

	/* Not in CLDR 21.0.1.
	 * http://www.sil.org/iso639-3/documentation.asp?id=sli
	 * Added 2008-09-02.
	 */
	// 'sli' => 'Lower Silesian',

	/* Not in CLDR 21.0.1.
	 * http://www.sil.org/iso639-3/documentation.asp?id=szl
	 * Added 2008-03-29.
	 */
	'szl' => 'シレジア語',

	/* Not in CLDR 21.0.1. Tulu language
	 * http://www.sil.org/iso639-3/documentation.asp?id=tcy
	 * Added 2008-08-23.
	 */
	// 'tcy' => 'Tulu',

	/* Not in CLDR 21.0.1. Turoyo language
	 * http://www.sil.org/iso639-3/documentation.asp?id=tru
	 * Added 2012-07-26.
	 */
	// 'tru' => 'Turoyo',

	/* Not in CLDR 21.0.1. Finnic Uralic language.
	 * http://www.ethnologue.org/show_language.asp?code=vep
	 * Added 2009-01-24.
	 */
	// 'vep' => 'Veps',

	/* Not in CLDR 21.0.1. West Middle German language.
	 * http://www.sil.org/iso639-3/documentation.asp?id=vmf
	 * Added 2010-01-31.
	 */
	// 'vmf' => 'Upper Franconian',

	/* Not in CLDR 21.0.1. Estonian language.
	 * http://www.sil.org/iso639-3/documentation.asp?id=vro
	 * Added 2009-01-24.
	 */
	'vro' => 'ヴォロ語',

	/* Not in CLDR 21.0.1. Chinese language.
	 * http://www.ethnologue.org/show_language.asp?code=wuu
	 * Added 2007-12-02.
	 */
	'wuu' => '呉語',

	/* Not in CLDR 21.0.1. Low Franconian language.
	 * http://www.ethnologue.org/show_language.asp?code=zea
	 * Added 2008-01-17.
	 */
	'zea' => 'ゼーランド語',

	/* Not in CLDR. Used for MediaWiki localisation
	 */
	'bat-smg' => 'サモギティア語',
	// 'be-tarask' => 'Belarusian (Taraškievica orthography)',
	'cdo' => '閩東語',
	// 'crh-cyrl' => 'Crimean Turkish (Cyrillic script)',
	// 'crh-latn' => 'Crimean Turkish (Latin script)',
	// 'de-formal' => 'German (formal address)',
	// 'gan-hans' => 'Simplified Gan script',
	// 'gan-hant' => 'Traditional Gan script',
	'glk' => 'ギラキ語',
	'got' => 'ゴート語',
	// 'hif-latn' => 'Fiji Hindi (Latin script)',
	// 'ike-cans' => 'Eastern Canadian (Aboriginal syllabics)',
	// 'ike-latn' => 'Eastern Canadian (Latin script)',
	// 'kk-cn' => 'Kazakh (China)',
	// 'kk-kz' => 'Kazakh (Kazakhstan)',
	// 'kk-tr' => 'Kazakh (Turkey)',
	// 'kk-arab' => 'Kazakh (Arabic script)',
	// 'kk-cyrl' => 'Kazakh (Cyrillic script)',
	// 'kk-latn' => 'Kazakh (Latin script)',
	// 'ks-arab' => 'Kashmiri (Arabic script)',
	// 'ks-deva' => 'Kashmiri (Devanagari script)',
	// 'ku-latn' => 'Kurdish (Latin script)',
	'nds-nl' => 'オランダ低ザクセン語',
	'no' => 'ノルウェー語（ブークモール）',
	'roa-rup' => 'アルーマニア語',
	'roa-tara' => 'タラント語',
	// 'sr-ec' => 'Serbian (Cyrillic script)',
	// 'sr-el' => 'Serbian (Latin script)',
	// 'tg-cyrl' => 'Tajik (Cyrillic script)',
	// 'tg-latn' => 'Tajik (Latin script)',
	// 'tt-cyrl' => 'Tatar (Cyrillic script)',
	// 'tt-latn' => 'Tatar (Latin script)',
	// 'ug-arab' => 'Uyghur (Arabic script)',
	// 'ug-latn' => 'Uyghur (Latin script)',
	'xmf' => 'メグレル語',
	// 'ydd' => 'Eastern Yiddish',
	'zh-classical' => '漢文',
	'zh-cn' => '中国語（中国）',
	'zh-hk' => '中国語（香港）',
	'zh-min-nan' => '閩南語',
	'zh-sg' => '中国語（シンガポール）',
	'zh-tw' => '中国語（台湾）',
	'zh-yue' => '広東語', # language redirect

	/* additional list from Japanese Wikipedia */
	'als' => 'アレマン語',
	'be-x-old' => 'ベラルーシ語（タラシケヴィツァ）',
	'cbk-zam' => 'チャバカノ語',
	'bcl' => 'ビコール語',
	'bxr' => 'ブリヤート語',
	'diq' => 'ザザキ語',
	'fiu-vro' => 'ヴォロ語',
	'hif' => 'フィジー・ヒンディー語',
	'lbe' => 'ラク語',
	'lij' => 'リグリア語',
	'lmo' => 'ロンバルド語',
	'map-bms' => 'バニュマス語',
	'nov' => 'ノヴィアル',
	'nrm' => 'ノルマン語',
	'pdc' => 'ペンシルバニアドイツ語',
	'pih' => 'ノーフォーク語・ピトケアン語',
	'rmy' => 'ロマ語',
	'simple' => 'シンプル英語',
	'stq' => 'ザーターフリジア語',
	'tokipona' => 'トキポナ',
	'vec' => 'ヴェネツィア語',
	'vls' => '西フラマン語',
);
