import cgi
import difflib
import i18n
import json
import pprint
import re
import requests
import sys
try:
    import urllib.parse as urlparse
except ImportError:
    import urlparse

META = 'https://meta.wikimedia.org/'
TEST = 'http://api.beta.wmflabs.org/'
PROD = 'http://{0}.zero.wikipedia.org/'
ZERO = 'https://zero.wikimedia.org/'

def download(url, params=None, headers=None, usePost=False):
    # Static session var for download()
    if "session" not in download.__dict__:
        print("Starting session")
        download.session = requests.session()
    if usePost:
        r = download.session.post(url, data=params, headers=headers)
    else:
        r = download.session.get(url, params=params, headers=headers)
    log = r.request.url
    if headers is not None:
        log = 'Hdrs: ' + str(headers) + ' ' + log
    print(log)
    return r

def api(site, **kwargs):
    kwargs['format'] = 'json'
    url = site + 'w/api.php'
    action = kwargs['action'] if 'action' in kwargs else ''
    usePost = action in ['login', 'edit']
    data = download(url, kwargs, usePost=usePost).json()
    if 'error' in data:
        raise Exception(json.dumps(data['error']))
    return data[kwargs['action']]

def edittoken(site=META):
    return api(site, action='tokens', type='edit')['edittoken']

def login(user, password, site=META):
    res = api(site, action='login', lgname=user, lgpassword=password)
    if res['result'] == 'NeedToken':
        res = api(site, action='login', lgname=user, lgpassword=password, lgtoken=res['token'])
    if res['result'] != 'Success':
        raise Exception(json.dumps(res))

def getAllConfigs(site=META):
    data = api(site, action='query', generator='allpages', gaplimit='max', gapnamespace='480', prop='revisions', rvprop='content')
    pages = data['pages']
    return dict([(pages[k]['title'].replace('Zero:',''), json.loads(pages[k]['revisions'][0]['*'])) for k in pages])

def wiki(site, title, params=None, headers=None):
    url = site + 'wiki/' + title
    return download(url, params, headers).text

def translate(lang, xdict):
    if lang in xdict:
        return xdict[lang]
    for l in i18n._altlang(lang):
        if l in xdict:
            return xdict[l]
    return xdict['en']

def wikiZ(site, title, xcs, params=None):
    headers = {
#        'User-Agent':'android ZeroConfig-test/1.0',
        'X-Device':'android',
        'X-CS':xcs,
    }
    return wiki(site, title, params, headers)

def printDiff(val1, val2, prefix = ''):
    vals1 = pprint.pformat(val1).splitlines(1)
    vals2 = pprint.pformat(val2).splitlines(1)
    d = difflib.Differ()
    result = list(d.compare(vals1, vals2))
    for r in result:
        if r[0] != ' ':
            print(prefix + r.rstrip())
