var configs,
    queuedLinks = [],
    casper = require('casper').create({ viewportSize: { width:320, height:240 } }),
    username = casper.cli.get('username'),
    fs = require('fs'),
    pwfile = fs.open(casper.cli.get('passwordfile'), 'r'),
    password = pwfile.readLine(),
    testStatus = 'okay';

pwfile.close();


fs.write('status', 'UNKNOWN', 'w');


casper.start('https://zero.wikimedia.org/w/index.php?title=Special:UserLogin', function() {
	this.echo('STARTING');
	this.fill('form[name="userlogin"]', {
		wpName: username,
		wpPassword: password
	}, true);
});

casper.thenOpen('https://zero.wikimedia.org/w/api.php?action=zeroportal&type=carriersnoips');

casper.then(function() {
    configs = JSON.parse(this.getPageContent());
});

casper.then(function() {
    var config, xcs, comment, enabled, directReceiver, langs, sites, subdomains, s, l, enabledForPair, url,
		apiUrl, js, fileName;
    for (config in configs) {
        if (configs.hasOwnProperty(config)) {
            xcs = config;
	        if (xcs === "TESTON") {
		        continue;
	        }
            config = configs[config];
            comment = config.comment;
            enabled = config.enabled === false ? false : true;
	        directReceiver = {};
	        config.configs.forEach(function(elem, idx, arr) {
		        if (elem.proxies.indexOf("DIRECT") !== -1) {
			        this['whitelistedLangs'] = elem.whitelistedLangs;
			        this['sites'] = elem.sites;
			        enabled = enabled && (elem.enabled === false ? false : true);
		        }
	        }, directReceiver);
	        if (!directReceiver.hasOwnProperty('whitelistedLangs')) {
		        directReceiver['whitelistedLangs'] = [];
		        // undefined sites okay, subdomains var gets defaults below
		        enabled = false;
	        }
            langs = (directReceiver.whitelistedLangs.length === 0) ?
	            config.showLangs :
	            directReceiver.whitelistedLangs.slice(0);
            sites = directReceiver.sites;
            subdomains = sites === undefined ?
                ['m', 'zero'] :
                sites.map( function ( elem ) {
                    if ( elem === 'm.wikipedia' ) return 'm';
                    if ( elem === 'zero.wikipedia' ) return 'zero';
                } );

            if ( !langs || langs.indexOf( 'pl' ) === -1 ) {
                langs.push( 'pl' );
            }

            for (s = 0; s < subdomains.length; s++) {
                for ( l = 0; l < langs.length; l++ ) {
                    enabledForPair = enabled && (directReceiver.whitelistedLangs.length === 0 || directReceiver.whitelistedLangs.indexOf(langs[l]) !== -1);
                    url = 'http://' + langs[l] + '.' + subdomains[s] + '.wikipedia.org/wiki/Main_Page';
					apiUrl = 'http://' + langs[l] + '.' + subdomains[s] + '.wikipedia.org/wiki/Special:ZeroRatedMobileAccess?zcmd=js-banner';
                    fileName = 'caps/' + (enabledForPair ? 'enabled-' : 'NOT-enabled-') + xcs + '-' + langs[l] + '.' + subdomains[s] + '.png';
                    queuedLinks.push({f: fileName, u: url, x: xcs, efp: enabledForPair, js: false});
					// now do the stuff for the unified design tests
					queuedLinks.push({f: 'unified-' + fileName, u: url, x: xcs, efp: enabledForPair, js: true, au: apiUrl});
                }
            }
        }
    }
});

casper.then(function() {
    casper.each(queuedLinks, function(self, link) {
		/*
		if (this.page.customHeaders['X-CS']) {
			delete this.page.customHeaders['X-CS'];
		}
		*/
        self.echo('QUEUED:' + link.x + ':' + link.u);

		if (link.js) {
			// If we're trying to process under the unified design, let's just go after the banner directly.
			// The page JavaScript should in theory manipulate the DOM, but
			// casper.waitForSelector('#zero-rated-banner-text') didn't produce the expected results, even with a long
			// timeout. Use of this.page.customHeaders seemed to not achieve the desired outcome, or created
			// inconsistent results at best. this.page.customHeaders didn't work so well, even if trying to use
			// JavaScript's delete operator (e.g., delete this.page.customHeaders['X-CS'];) to avoid staleness upfront.
			self.thenOpen(link.au, { method: 'get', headers: { 'X-CS': link.x, 'Accept': 'application/json' } },
				function() {
					var json = this.getPageContent(),
						enabled = /window\.zeroGlobalConfig=\{"enabled":true/.exec(json);
					if (link.efp && !enabled) {
						testStatus = 'FAILED';
						this.echo('FAIL:JavaScript banner disabled when it should be disabled:' + link.x + ':' + link.au + ':' + link.f);
					} else if (!link.efp && enabled) {
						testStatus = 'FAILED';
						this.echo('FAIL:JavaScript banner enabled when it should be disabled:' + link.x + ':' + link.u + ':' + link.f);
					}
					this.capture(link.f, {top:0, left:0, width:320, height:240});
				}
			);
		} else {
			// if we're trying to process under the old design
			self.thenOpen(link.u, { method: 'get', headers: { 'X-CS': link.x } },
				function() {
					if ( (link.efp && !this.exists('#zero-rated-banner-text'))) {
						testStatus = 'FAILED';
						this.echo('FAIL:banner not found:' + link.x + ':' + link.u + ':' + link.f);
					} else if (!link.efp && this.exists('#zero-rated-banner-text')) {
						testStatus = 'FAILED';
						this.echo('FAIL:unexpected banner found:' + link.x + ':' + link.u + ':' + link.f);
					}
					this.capture(link.f, {top:0, left:0, width:320, height:240});
				}
			);

		}

    });
});

casper.then(function() {
    this.echo('STATUS:' + testStatus);
    fs.write('status', testStatus, 'w');
});

casper.run();
