/*
Run like so:

1. Install stable PhantomJS with brew in the Max OS X section of http://phantomjs.org/download.html
2. Install stable 1.0.x CasperJS as described at
   http://docs.casperjs.org/en/latest/installation.html#installing-from-homebrew-osx
3. With Terminal, after toggling 'enabled' to true or false, wait 10-15 minutes or so, then
   cd into the directory containing purge.js and run the following command:

        casperjs purge.js --xcs=646-02 fr en

 That will try to purge the French and English /wiki/Main_Page URLs and will take screenshots.
 */


var casper = require('casper').create({ viewportSize: { width:320, height:320 } }),
	xcs = casper.cli.get('xcs'),
	languages = casper.cli.args;

if (!xcs || !languages) {
	casper.echo('');
	casper.echo('Not running. Please run like so')
	casper.echo('');
	casper.echo('    casperjs ' + require('system').args[3] + ' --xcs=###-## lang1 [lang2 lang3...]')
	casper.echo('');
	casper.exit()
}

casper.start('http://example.com', function() {
	this.echo('Starting...');
});
casper.then( function() {
	casper.each(languages, function(self, lang) {
		var url = 'http://' + lang + '.m.wikipedia.org/wiki/Main_Page',
			purgePre = xcs + '-' + lang + '-0-pre.png',
			purgeMid = xcs + '-' + lang + '-1-about_to_purge.png',
			purgePost = xcs + '-' + lang + '-2-post.png';
		self.echo('Opening ' + url);
		self.thenOpen(url, { method: 'get', headers: { 'X-CS': xcs } }, function() {
			this.capture(purgePre, {top:0, left:0, width:320, height:320});
		});

		self.thenOpen(url + '?action=purge', { method: 'get', headers: { 'X-CS': xcs } }, function () {
			this.capture(purgeMid, {top:0, left:0, width:320, height:320});
			casper.waitForSelector('.mw-htmlform-submit', function() {
				this.echo('Purging ' + url);
				this.click('.mw-htmlform-submit');
				casper.then(function() {
					this.echo('Purged ' + url);
					casper.thenOpen(url, { method: 'get', headers: { 'X-CS': xcs } }, function() {
						this.capture(purgePost, {top:0, left:0, width:320, height:320});
						this.echo('See ' + purgePre + ', ' + purgeMid + ', and ' +  purgePost);
					});
				})
			});
		});
	});
});

casper.then(function () {
	this.echo('Done');
});


casper.run();
