<?php

namespace ZeroPortal;
use JsonConfig\JCSingleton;
use Title;
use TitleValue;
use ZeroBanner\ZeroConfig;
use ZeroBanner\PageRenderingHooks;


/**
 * Configuration page hook handlers for ZeroRatedMobileAccess extension.
 *
 * @file
 * @ingroup Extensions
 */
class ConfigPageHooks {

	/**
	 * Checks if the given title has 'JsonZeroConfig' model
	 * @param TitleValue $titleValue
	 * @return bool
	 */
	static function isZeroConfigTitle( TitleValue $titleValue ) {
		$conf = JCSingleton::getMetadata( $titleValue );
		return $conf ? $conf->model === 'JsonZeroConfig' : false;
	}

	/**
	 * Adds CSS for pretty-printing configuration on ZeroConfig pages.
	 * @param \OutputPage &$out
	 * @param \Skin &$skin
	 * @return bool
	 */
	static function onBeforePageDisplay( &$out,
										 /** @noinspection PhpUnusedParameterInspection */ &$skin ) {
		$title = $out->getTitle();
		if ( $title && self::isZeroConfigTitle( $title->getTitleValue() ) ) {
			$out->addModules( 'zeroportal.config' );
		}
		return true;
	}
}
