<?php
/**
 * Extension ZeroRatedMobileAccess — Zero Rated Mobile Access
 *
 * @file
 * @ingroup Extensions
 * @author Patrick Reilly
 * @author Yuri Astrakhan
 * @copyright © 2011 Patrick Reilly, 2013 Yuri Astrakhan
 * @licence GNU General Public Licence 2.0 or later
 */

// Needs to be called within MediaWiki; not standalone
if ( !defined( 'MEDIAWIKI' ) ) {
	echo( "This is a MediaWiki extension and cannot run standalone.\n" );
	die( -1 );
}

if ( !defined( 'NS_ZERO' ) ) {
	echo( "ZeroBanner extension has not been added\n" );
	die( -1 );
}

// Extension credits that will show up on Special:Version
$wgExtensionCredits['other'][] = array(
	'path'  =>  __FILE__,
	'name'  =>  'ZeroPortal',
	'version'  =>  '1.0.0',
	'author' => array( 'Yuri Astrakhan' ),
	'descriptionmsg'  =>  'zeroportal-desc',
	'url'  =>  'https://www.mediawiki.org/wiki/Extension:ZeroPortal',
);

$cwd = __DIR__ . DIRECTORY_SEPARATOR;
$wgMessagesDirs['ZeroPortal'] = $cwd . 'i18n';
$wgExtensionMessagesFiles['ZeroPortal'] = $cwd . 'ZeroPortal.i18n.php';

// autoload extension classes
$cwd .= 'includes' . DIRECTORY_SEPARATOR;
foreach ( array(
	          'ApiZeroPortal',
	          'ConfigPageHooks',
	          'ZeroConfigView',
	          'PortalSpecialPage',
          ) as $key => $class ) {
	$wgAutoloadClasses['ZeroPortal\\' . ( is_string( $key ) ? $key : $class )] = $cwd . $class . '.php';
}

$wgResourceModules['zeroportal.config'] = array(
	'dependencies' => 'zerobanner.config.styles', // defined in ZeroBanner ext, used for sample banners
	'localBasePath' => __DIR__,
	'remoteExtPath' => 'ZeroPortal',
	'styles'        => array( 'modules/zero.config.css' ),
	'position'      => 'top',
);

$wgAPIModules['zeroportal'] = 'ZeroPortal\ApiZeroPortal';
$wgHooks['BeforePageDisplay'][] = 'ZeroPortal\ConfigPageHooks::onBeforePageDisplay';

// Set our own view class for the JsonZeroConfig model, and configure local storage
$wgJsonConfigModels['JsonZeroConfig']['view'] = 'ZeroPortal\ZeroConfigView';
$wgJsonConfigs['JsonZeroConfig']['store'] = true;

$wgSpecialPages['ZeroPortal'] = 'ZeroPortal\PortalSpecialPage';
$wgSpecialPageGroups['ZeroPortal'] = 'other';
$wgExtensionMessagesFiles['ZeroPortalAlias'] = __DIR__ . DIRECTORY_SEPARATOR . 'ZeroPortal.alias.php';

$wgZeroPortalImpersonateUser = false;
