/* global mw, jQuery */
( function ( M, $ ) {
    'use strict';
    $( function () {
        var config = (window && (window.zeroGlobalConfig || (window.mw && window.mw.zeroConfig))) || false,
	        hostname = document.location.hostname.toLowerCase(), // hostname of the current page
            isMdot = hostname.indexOf( '.m.' ) !== -1,
            isHttps = window.location.protocol === 'https:',
	        // this is set if operator zero-rates HTTPS
            supportsTls = config ? (config.enabled && config.enableHttps) : $.cookie( 'ZeroOpts' ) === 'tls',
            getConfig = config ? config : (function () {
                // Singleton to hold zero configuration
                var instance;
                return function () {
                    if ( !instance ) {
                        instance = M.require( 'api' ).get( { action: 'zeroconfig', type: 'config' } );
                    }
                    return instance;
                };
            })();

        $( '#page-secondary-actions').find('.languageSelector' ).off();

        if ( isMdot ) {
            /* CSS isn't working for this element, and !important breaks stuff */
            $( '.icon-settings' ).show();
        }

        /*
        In the future state with ESI, we may need to revisit approach.
        But for now, we'll have Varnish send a cookie.
        And if the user doesn't have cookies but does have JS, we'll check
        the config API as a last resort.
        */
        if ( supportsTls || M.settings.getUserSetting( 'zerodontask', true ) ) {
            $( '.icon-watchlist,.icon-loginout,#page-actions' ).show();
            $( '.hlist > li:not(.new)' ).css( 'display', 'inline-block' );
            if ( !isMdot ) {
                /* the previous display: inline-block needs a tweak */
                $( '#ca-upload' ).hide();
            } else {
                /*
                 FIXME: jdlrobson in change 83133 - "Maybe MobileFrontend can make this
                 easier by marking these links with a shared class so you can do something
                 like $( '.httpsLink' ).show();"
                 */
                $( '.icon-uploads,#ca-upload' ).show();
            }
            // Theoretically, cookies could be turned off, but it's unlikely.
            // We decided to avoid hitting the API in this case.
        } else {
            /* We should avoid !important for these */
            $( '.icon-uploads,.edit-page' ).hide();
        }

	    if ( config && config.testInfoScreen ) {
		    $( '#zero-rated-banner' ).on( 'click', function ( ev ) {
			    ev.preventDefault();
			    M.require( 'ZeroInfo' );
			    window.location.hash = '#zeroinfo';
		    } );
	    }

        // Disable other click event handlers for images/thumbnails, for example, the
        // mobile media viewer.
        // FIXME: Figure out a less fragile way to handle this
        $( 'a.image, a.thumbimage' ).each( function() {
            var $a = $( this ), match = $a.attr( 'href' ).match( /[^\/]+$/ );
            if ( match ) {
                $a.off( 'click mouseup tap' );
            }
        } );

        $( 'a' ).on( 'click', function ( ev ) {
            var knownSites = [
                    // a hardcoded list of our sites - avoids api call if not listed
                    'm.wikipedia', 'zero.wikipedia'
                ],
                $target = $( this ), // onclick <a> element
                isSpecialCase = false, // true if interstitial should be shown despite not being a redirect
                search = $target.prop( 'search' ), // query part of the link target URL
                isImage = $target.hasClass( 'image' ), // is this a link to an image page
                showWarning, // true if a warning page should be shown
                toUrl, // target URL of the link
                toAsAnchor, // target URL as a DOM <a> object
                toHostname, // hostname of of the URL
                toHostParts, // hostname parts of the URL
                toLang = false, // language of the destination site
                toSite = false, // non-language specific name of the site, e.g. "m.wikipedia"
                isLocal, // true if the target is a link to the current site
                isHttpsSwitch, // true if the link would switch from http to https
                isFreeLookingUploadDotLink, // whether the interstitial points at upload.wikimedia.org
                isFreeProtocol; // whether the interstitial points at a protocol that's free

            if ( $target.attr( 'id' ) === 'mw-mf-last-modified' ) {
                isSpecialCase = true;
            }

            if ( isSpecialCase ) {
                // Special case link, need to show interstitial regardless
                toUrl = $target.prop( 'href' );
            } else if ( /[?&]title=[^:&]+:ZeroRatedMobileAccess(&|$)/.test( search ) ) {
                // Extract target URL from the redirect link if needed
                toUrl = /[&?]to=([^&]+)/.exec( search );
                if ( toUrl !== null ) {
                    toUrl = decodeURIComponent( toUrl[1] );
                }
            }
            if ( !toUrl ) {
                return; // Link was not recognized, don't handle
            }

	        if ( config && !config.enabled ) {
		        // Config is provided but disabled, we don't exist
		        showWarning = false;
	        } else if ( M.settings.getUserSetting( 'zerodontask', true ) ) {
                // User chooses not to be notified, no need for any kinds of warnings
                showWarning = false;
            } else if ( isSpecialCase ) {
                // Special case link
                // TODO: need to rethink logic. For now show always
                showWarning = true;
            } else {
                // Link to Special:Zero redirector
                // Use a DOM anchor trick to parse target URL
                toAsAnchor = $( '<a>', { href: toUrl } )[0];
                if ( toAsAnchor.hostname ) {
                    toHostname = toAsAnchor.hostname.toLowerCase();
                    isLocal = toHostname === hostname;
                } else {
                    toHostname = hostname;
                    isLocal = true;
                }
                toHostParts = toHostname.split( '.', 3 );
                if ( toHostParts.length >= 3 ) {
                    toLang = toHostParts[0];
                    toSite = toHostParts[1] + '.' + toHostParts[2];
                }

                isHttpsSwitch = !isHttps && toAsAnchor.protocol === 'https:';
                isFreeProtocol = !isHttpsSwitch || supportsTls;
		        // @fixme: need to bring $wgZeroBannerClusterDomain here
                isFreeLookingUploadDotLink = isFreeProtocol && toHostname === 'upload.wikimedia.org';

                if ( isFreeLookingUploadDotLink ) {
                    // This is a link to upload.wikimedia.org, so must be handled below.
                    // Why? Sometimes configs support mdot, but dissuade with warnings.
                } else if ( !isLocal && ( !toSite || $.inArray( toSite, knownSites ) === -1 ) ) {
                    showWarning = true; // Navigating to an unknown site
                } else if ( isLocal && !isImage && isFreeProtocol ) {
                    showWarning = false; // This is a local link to a non-image page
                }
            }

            // At this point do custom <a> click navigation
            // it will be handled by navigate() called either directly or from a callback
            ev.preventDefault();

            function navigate( warn ) {
                if ( warn ) {
                    M.require( 'ZeroOverlay' );
                    window.location.hash = ( isImage ? '#zerofile/' : '#zerosite/' ) + toUrl;
                } else {
                    // Navigate directly to the target bypassing a server hit
                    window.location.href = toUrl;
                }
            }

            if ( showWarning === undefined ) {
	            var onConfig = function ( conf ) {
		            var showWarning;
		            if ( !conf.enabled ) {
			            showWarning = false;
		            } else if ( isFreeLookingUploadDotLink ) {
			            showWarning = !conf.showImages;
		            } else if ( !isLocal ) {
			            // The logical construct here is "should we navigate without asking" and inverting that.
			            showWarning = !(
			            ( conf.whitelistedLangs &&
			            ( conf.whitelistedLangs.length === 0 ||
			            $.inArray( toLang, conf.whitelistedLangs ) !== -1 ) ) &&
			            ( conf.sites &&
			            ( conf.sites.length === 0 ||
			            $.inArray( toSite, conf.sites ) !== -1 ) ) &&
			            ( !isHttpsSwitch || conf.enableHttps )
			            );
		            } else {
			            // local link to an image
			            showWarning = !conf.showImages;
		            }
		            navigate( showWarning );
	            };
	            if (config) {
		            onConfig(config);
	            } else {
		            // We still don't know how to handle it, and need to make a server call
		            getConfig().done(onConfig);
	            }
            } else {
                navigate( showWarning );
            }
        } );
    } );
}( mw.mobileFrontend, jQuery ) );
