/* global mw */
( function( M ) {
    'use strict';
    var ZeroOverlay = M.require( 'Overlay' ).extend( {
            template: M.template.get( 'interstitial.hogan' ),
            closeOnBack: true,
            defaults: {
                yes: mw.msg( 'zero-accept' ),
                no: mw.msg( 'zero-go-back' ),
                dontask: mw.msg( 'zero-dont-ask' )
            },
            initialize: function( options ) {
                this.defaults.warning = mw.msg(
                    options.image ? 'zero-file-auth' : 'zero-charge-auth' );
                this._super( options );
            },
            postRender: function( options ) {
                this._super( options );
                this.$( '#zerodontask' ).on( 'click', function() {
                    M.settings.saveUserSetting( 'zerodontask', true, true );
                    window.location.href = options.url;
                } );
            }
        } );

    M.router.route( /^zerosite\/(.*)/, function( url ) {
        new ZeroOverlay( { url: url, image: false } ).show();
    } );
    M.router.route( /^zerofile\/(.*)/, function( url ) {
        new ZeroOverlay( { url: url, image: true } ).show();
    } );

    M.define( 'ZeroOverlay', ZeroOverlay );

}( mw.mobileFrontend ) );
