<?php

/**
 * Internationalization file with magic words for the Wikibase Client extension.
 *
 * @since 0.1
 *
 * @licence GNU GPL v2+
 */

$magicWords = array();

/** English (English) */
$magicWords['en'] = array(
	'noexternallanglinks' => array( 0, 'noexternallanglinks' ),
	'property' => array( 0, 'property' ),
	'wbreponame' => array( 0, 'wbreponame' ),
);

/** Arabic (العربية) */
$magicWords['ar'] = array(
	'noexternallanglinks' => array( 0, 'لا_وصلات_لغة_خارجية' ),
	'property' => array( 0, 'خاصية' ),
	'wbreponame' => array( 0, 'اسم_مستودع_وب' ),
);

/** Egyptian Spoken Arabic (مصرى) */
$magicWords['arz'] = array(
	'noexternallanglinks' => array( 0, 'من_غير_وصلات_لغه_خارجيه' ),
	'property' => array( 0, 'خاصيه' ),
	'wbreponame' => array( 0, 'اسم_ريبو_وب' ),
);

/** German (Deutsch) */
$magicWords['de'] = array(
	'noexternallanglinks' => array( 0, 'keineexternensprachlinks', 'keine_externen_sprachlinks' ),
	'property' => array( 0, 'eigenschaft' ),
	'wbreponame' => array( 0, 'wbrepositoriumsname' ),
);

/** Zazaki (Zazaki) */
$magicWords['diq'] = array(
	'noexternallanglinks' => array( 0, 'tebergreyzuwaniçıniyo' ),
	'property' => array( 0, 'nitelıg' ),
);

/** Esperanto (Esperanto) */
$magicWords['eo'] = array(
	'noexternallanglinks' => array( 0, 'neniuligiloalalialingvo' ),
	'property' => array( 0, 'eco' ),
);

/** Spanish (español) */
$magicWords['es'] = array(
	'noexternallanglinks' => array( 0, 'nointerwikis' ),
	'property' => array( 0, 'propiedad' ),
);

/** Estonian (eesti) */
$magicWords['et'] = array(
	'noexternallanglinks' => array( 0, 'välistekeelelinkideta' ),
	'property' => array( 0, 'omadus' ),
);

/** Persian (فارسی) */
$magicWords['fa'] = array(
	'property' => array( 0, 'ویژگی' ),
);

/** Finnish (suomi) */
$magicWords['fi'] = array(
	'property' => array( 0, 'ominaisuus' ),
);

/** French (français) */
$magicWords['fr'] = array(
	'noexternallanglinks' => array( 0, 'sanslienexterne' ),
	'property' => array( 0, 'propriété' ),
);

/** Hindi (हिन्दी) */
$magicWords['hi'] = array(
	'noexternallanglinks' => array( 0, 'कोई_अंतरविकी_कड़ियाँ_नहीं', 'कोई_अंतरविकि_कड़ियाँ_नहीं' ),
	'property' => array( 0, 'गुण' ),
);

/** Korean (한국어) */
$magicWords['ko'] = array(
	'noexternallanglinks' => array( 0, '바깥언어링크없음', '바깥언어고리없음' ),
	'property' => array( 0, '속성' ),
);

/** Luxembourgish (Lëtzebuergesch) */
$magicWords['lb'] = array(
	'property' => array( 0, 'Eegeschaft' ),
);

/** Minangkabau (Baso Minangkabau) */
$magicWords['min'] = array(
	'noexternallanglinks' => array( 0, 'tanpainterwiki' ),
	'property' => array( 0, 'properti' ),
);

/** Macedonian (македонски) */
$magicWords['mk'] = array(
	'noexternallanglinks' => array( 0, 'безнадворјазврски' ),
	'property' => array( 0, 'својство' ),
	'wbreponame' => array( 0, 'вбскладиштеиме' ),
);

/** Malayalam (മലയാളം) */
$magicWords['ml'] = array(
	'noexternallanglinks' => array( 0, 'ബാഹ്യഭാഷാകണ്ണികൾവേണ്ട' ),
);

/** Dutch (Nederlands) */
$magicWords['nl'] = array(
	'noexternallanglinks' => array( 0, 'geenexternetaalkoppelingen', 'geenexternetaalverwijzingen' ),
	'property' => array( 0, 'eigenschap' ),
);

/** Norwegian Nynorsk (norsk nynorsk) */
$magicWords['nn'] = array(
	'noexternallanglinks' => array( 0, 'ingenspråklenkjerutanfrå' ),
);

/** Polish (polski) */
$magicWords['pl'] = array(
	'property' => array( 0, 'właściwość' ),
);

/** Portuguese (português) */
$magicWords['pt'] = array(
	'property' => array( 0, 'propriedade' ),
);

/** Brazilian Portuguese (português do Brasil) */
$magicWords['pt-br'] = array(
	'noexternallanglinks' => array( 0, 'naointerwikis' ),
	'property' => array( 0, 'propriedade' ),
);

/** Russian (русский) */
$magicWords['ru'] = array(
	'property' => array( 0, 'свойство' ),
);

/** Ukrainian (українська) */
$magicWords['uk'] = array(
	'noexternallanglinks' => array( 0, 'беззовнішніхпосилань' ),
	'property' => array( 0, 'властивість' ),
);

/** Vietnamese (Tiếng Việt) */
$magicWords['vi'] = array(
	'noexternallanglinks' => array( 0, 'không_liên_kết_ngôn_ngữ_ngoài', 'khôngliênkếtngônngữngoài' ),
	'property' => array( 0, 'thuộc_tính', 'thuộctính' ),
	'wbreponame' => array( 0, 'tên_kho_wb', 'tênkhowb' ),
);

/** Yiddish (ייִדיש) */
$magicWords['yi'] = array(
	'property' => array( 0, 'אייגנשאפט' ),
);

/** Simplified Chinese (中文（简体）‎) */
$magicWords['zh-hans'] = array(
	'noexternallanglinks' => array( 0, '无外部语言连接' ),
	'property' => array( 0, '属性' ),
	'wbreponame' => array( 0, 'wb报告名' ),
);

/** Traditional Chinese (中文（繁體）‎) */
$magicWords['zh-hant'] = array(
	'noexternallanglinks' => array( 0, '隱藏跨語言連結' ),
	'property' => array( 0, '屬性' ),
	'wbreponame' => array( 0, 'wb匯報名' ),
);