<?php
/**
 * Aliases for special pages of Translate extension.
 *
 * @file
 * @license GPL-2.0+
 */
// @codingStandardsIgnoreFile

$specialPageAliases = array();

/** English (English) */
$specialPageAliases['en'] = array(
	'AggregateGroups' => array( 'AggregateGroups' ),
	'ImportTranslations' => array( 'ImportTranslations' ),
	'LanguageStats' => array( 'LanguageStats' ),
	'Magic' => array( 'AdvancedTranslate', 'Magic' ),
	'ManageMessageGroups' => array( 'ManageMessageGroups' ),
	'ManageTranslatorSandbox' => array( 'ManageTranslatorSandbox', 'TranslateSandbox' ),
	'MessageGroupStats' => array( 'MessageGroupStats' ),
	'MyLanguage' => array( 'MyLanguage' ),
	'PageTranslation' => array( 'PageTranslation' ),
	'PageTranslationDeletePage' => array( 'PageTranslationDeletePage' ),
	'SearchTranslations' => array( 'SearchTranslations' ),
	'SupportedLanguages' => array( 'SupportedLanguages' ),
	'Translate' => array( 'Translate' ),
	'TranslationStash' => array( 'TranslationStash' ),
	'TranslationStats' => array( 'TranslationStats', 'TranslationStatistics' ),
	'Translations' => array( 'Translations' ),
	'PageMigration' => array( 'PageMigration' ),
	'PagePreparation' => array( 'PagePreparation' ),
);

/** Afrikaans (Afrikaans) */
$specialPageAliases['af'] = array(
	'LanguageStats' => array( 'TaalStatsistieke' ),
	'Magic' => array( 'GevorderdeVertaal' ),
	'MyLanguage' => array( 'MyTaal' ),
	'PageTranslation' => array( 'BladsyVertaling' ),
	'Translate' => array( 'Vertaal' ),
	'TranslationStats' => array( 'VertaalStatistieke' ),
	'Translations' => array( 'Vertalings' ),
);

/** Arabic (العربية) */
$specialPageAliases['ar'] = array(
	'AggregateGroups' => array( 'مجموعات_مجمعة' ),
	'ImportTranslations' => array( 'استيراد_الترجمات' ),
	'LanguageStats' => array( 'إحصاءات_اللغات' ),
	'Magic' => array( 'ترجمة_متقدمة', 'ماجيك' ),
	'ManageMessageGroups' => array( 'التحكم_بمجموعات_الرسائل' ),
	'ManageTranslatorSandbox' => array( 'التحكم_بملعب_المترجم', 'ملعب_الترجمة' ),
	'MessageGroupStats' => array( 'إحصاءات_مجموعات_الرسائل' ),
	'MyLanguage' => array( 'لغتي' ),
	'PageTranslation' => array( 'ترجمة_صفحة' ),
	'PageTranslationDeletePage' => array( 'صفحة_حذف_ترجمة_الصفحة' ),
	'SearchTranslations' => array( 'بحث_الترجمات' ),
	'SupportedLanguages' => array( 'اللغات_المدعومة' ),
	'Translate' => array( 'ترجمة' ),
	'TranslationStash' => array( 'ستاش_الترجمة' ),
	'TranslationStats' => array( 'إحصاءات_الترجمة' ),
	'Translations' => array( 'ترجمات' ),
	'PageMigration' => array( 'هجرة_الصفحة' ),
);

/** Aramaic (ܐܪܡܝܐ) */
$specialPageAliases['arc'] = array(
	'MyLanguage' => array( 'ܠܫܢܐ_ܕܝܠܝ' ),
	'PageTranslation' => array( 'ܬܘܪܓܡܐ_ܕܦܐܬܐ' ),
	'SupportedLanguages' => array( 'ܠܫܢ̈ܐ_ܣܡܝܟ̈ܐ' ),
	'Translate' => array( 'ܬܪܓܡ' ),
	'Translations' => array( 'ܬܘܪ̈ܓܡܐ' ),
);

/** Egyptian Spoken Arabic (مصرى) */
$specialPageAliases['arz'] = array(
	'AggregateGroups' => array( 'مجموعات_متجمعه' ),
	'ImportTranslations' => array( 'استوراد_الترجمات' ),
	'LanguageStats' => array( 'احصائيات_اللغات' ),
	'Magic' => array( 'ترجمة_متقدمة', 'ماجيك' ),
	'ManageMessageGroups' => array( 'التحكم_بمجموعات_الرسايل' ),
	'ManageTranslatorSandbox' => array( 'التحكم_بسبوره_المترجم', 'سبوره_الترجمه' ),
	'MessageGroupStats' => array( 'احصاءات_مجموعات_الرسايل' ),
	'MyLanguage' => array( 'اللغة_بتاعتى' ),
	'PageTranslation' => array( 'ترجمة_صفحه' ),
	'PageTranslationDeletePage' => array( 'صفحه_حذف_ترجمه_الصفحه' ),
	'SearchTranslations' => array( 'تدوير_الترجمات' ),
	'SupportedLanguages' => array( 'اللغات_المتدعمه' ),
	'Translate' => array( 'ترجمه' ),
	'TranslationStash' => array( 'ستاش_الترجمه' ),
	'TranslationStats' => array( 'احصائيات_الترجمه' ),
	'Translations' => array( 'ترجمات' ),
	'PageMigration' => array( 'هجره_الصفحه' ),
);

/** Assamese (অসমীয়া) */
$specialPageAliases['as'] = array(
	'ImportTranslations' => array( 'অনুবাদ_আমদানি_কৰক' ),
	'LanguageStats' => array( 'ভাষাৰ_পৰিসংখ্যা' ),
	'Magic' => array( 'উন্নত_অনুবাদ', 'যাদু' ),
	'MessageGroupStats' => array( 'বাৰ্তাৰ_গোট_পৰিসংখ্যা' ),
	'MyLanguage' => array( 'মোৰ_ভাষা' ),
	'PageTranslation' => array( 'পৃষ্ঠা_অনুবাদ' ),
	'SupportedLanguages' => array( 'সমৰ্থিত_ভাষাসমূহ' ),
	'Translate' => array( 'অনুবাদ_কৰক' ),
	'TranslationStats' => array( 'অনুবাদ_পৰিসংখ্যা' ),
	'Translations' => array( 'অনুবাদসমূহ' ),
);

/** Asturian (asturianu) */
$specialPageAliases['ast'] = array(
	'Translate' => array( 'Traducir' ),
);

/** Azerbaijani (azərbaycanca) */
$specialPageAliases['az'] = array(
	'PageTranslation' => array( 'SəhifəTərcüməsi' ),
	'Translations' => array( 'Tərcümələr' ),
);

/** South Azerbaijani (تورکجه) */
$specialPageAliases['azb'] = array(
	'PageTranslation' => array( 'صحیفه_چئویرمه‌سی' ),
	'Translations' => array( 'چئویرمه‌لر' ),
);

/** Bashkir (башҡортса) */
$specialPageAliases['ba'] = array(
	'Magic' => array( 'AdvancedTranslate' ),
	'MyLanguage' => array( 'MyLanguage' ),
	'Translate' => array( 'Translate' ),
	'Translations' => array( 'Translations' ),
);

/** Southern Balochi (بلوچی مکرانی) */
$specialPageAliases['bcc'] = array(
	'Magic' => array( 'پیشرپتگین ترجمه' ),
	'Translate' => array( 'ترجمه' ),
);

/** Bulgarian (български) */
$specialPageAliases['bg'] = array(
	'Translate' => array( 'Превеждане' ),
	'Translations' => array( 'Преводи' ),
);

/** Banjar (Bahasa Banjar) */
$specialPageAliases['bjn'] = array(
	'ImportTranslations' => array( 'Impor_tarjamahan' ),
	'LanguageStats' => array( 'Statistik_bahasa' ),
	'Magic' => array( 'Tarjamahakan_lanjut' ),
	'MyLanguage' => array( 'Bahasa_ulun' ),
	'PageTranslation' => array( 'Tarjamahan_tungkaran' ),
	'Translate' => array( 'Tarjamahakan' ),
	'TranslationStats' => array( 'Statistik_tarjamahan' ),
	'Translations' => array( 'Tarjamahan' ),
);

/** Breton (brezhoneg) */
$specialPageAliases['br'] = array(
	'ImportTranslations' => array( 'EnporzhiañTroidigezhioù' ),
	'LanguageStats' => array( 'StadegoùYezh' ),
	'Magic' => array( 'TreiñAraokaet' ),
	'MyLanguage' => array( 'MaYezh' ),
	'PageTranslation' => array( 'TroidigezhPajenn' ),
	'SupportedLanguages' => array( 'Yezhoùskoret' ),
	'Translate' => array( 'Treiñ' ),
	'TranslationStats' => array( 'StadegoùTreiñ' ),
	'Translations' => array( 'Troidigezhioù' ),
);

/** Bosnian (bosanski) */
$specialPageAliases['bs'] = array(
	'ImportTranslations' => array( 'UvozPrijevoda' ),
	'LanguageStats' => array( 'StatistikeJezika' ),
	'Magic' => array( 'NaprednoPrevodjenje' ),
	'PageTranslation' => array( 'PrijevodStranice' ),
	'Translate' => array( 'Prevedi' ),
	'TranslationStats' => array( 'StatistikePrevoda' ),
	'Translations' => array( 'Prijevodi' ),
);

/** буряад (буряад) */
$specialPageAliases['bxr'] = array(
	'MyLanguage' => array( 'Минии_хэлэн' ),
	'PageTranslation' => array( 'Хуудаһанай_оршуулга' ),
	'SupportedLanguages' => array( 'Дэмжэдэг_хэлэн' ),
	'Translate' => array( 'Оршуулха' ),
	'Translations' => array( 'Оршуулганууд' ),
);

/** Min Dong Chinese (Mìng-dĕ̤ng-ngṳ̄) */
$specialPageAliases['cdo'] = array(
	'ImportTranslations' => array( '導底翻譯' ),
	'LanguageStats' => array( '語言統計' ),
	'Magic' => array( '高級翻譯' ),
	'ManageMessageGroups' => array( '管理信息組' ),
	'MessageGroupStats' => array( '信息組統計' ),
	'MyLanguage' => array( '我其語言' ),
	'PageTranslation' => array( '頁面翻譯' ),
	'SupportedLanguages' => array( '支持其語言' ),
	'Translate' => array( '翻譯' ),
	'TranslationStats' => array( '翻譯統計' ),
);

/** Chechen (нохчийн) */
$specialPageAliases['ce'] = array(
	'AggregateGroups' => array( 'Агрегированни_тобанаш' ),
	'ImportTranslations' => array( 'Гоч_йинарш_импорт_яр' ),
	'LanguageStats' => array( 'Меттан_статистика' ),
	'Magic' => array( 'Шордина_гочдар' ),
	'ManageMessageGroups' => array( 'Хаамийн_тобанийн_урхалла_дар' ),
	'MessageGroupStats' => array( 'Хаамийн_тобанийн_статистика' ),
	'MyLanguage' => array( 'Сан_мотт' ),
	'PageTranslation' => array( 'АгӀонаш_гоч_яр' ),
	'PageTranslationDeletePage' => array( 'Гоч_еш_йолу_агӀо_дӀаяккхар' ),
	'SearchTranslations' => array( 'Гоч_йинарш_лахар' ),
	'SupportedLanguages' => array( 'Ловш_долу_меттанаш' ),
	'Translate' => array( 'Гоч_де' ),
	'TranslationStats' => array( 'Гочдаран_статистика' ),
	'Translations' => array( 'Гоч_дарш' ),
);

/** Cebuano (Cebuano) */
$specialPageAliases['ceb'] = array(
	'Translate' => array( 'Hubara' ),
);

/** Czech (čeština) */
$specialPageAliases['cs'] = array(
	'Translate' => array( 'Přeložit' ),
);

/** Danish (dansk) */
$specialPageAliases['da'] = array(
	'PageTranslation' => array( 'Sideoversættelse' ),
	'Translate' => array( 'Oversæt' ),
);

/** German (Deutsch) */
$specialPageAliases['de'] = array(
	'AggregateGroups' => array( 'Zusammenfassende_Nachrichtengruppen' ),
	'ImportTranslations' => array( 'Übersetzungen_importieren' ),
	'LanguageStats' => array( 'Sprachstatistiken' ),
	'Magic' => array( 'Erweitertes_Übersetzen' ),
	'ManageMessageGroups' => array( 'Nachrichtengruppen_verwalten' ),
	'ManageTranslatorSandbox' => array( 'Übersetzerspielwiese_verwalten' ),
	'MessageGroupStats' => array( 'Nachrichtengruppenstatistiken' ),
	'MyLanguage' => array( 'Meine_Sprache' ),
	'PageTranslation' => array( 'Übersetzung_von_Seiten' ),
	'PageTranslationDeletePage' => array( 'Löschseite_für_Übersetzungen' ),
	'SearchTranslations' => array( 'Übersetzungen_suchen' ),
	'SupportedLanguages' => array( 'Unterstützte_Sprachen' ),
	'Translate' => array( 'Übersetzen' ),
	'TranslationStash' => array( 'Übersetzungsversteck' ),
	'TranslationStats' => array( 'Übersetzungsstatistik' ),
	'Translations' => array( 'Übersetzungen' ),
	'PageMigration' => array( 'Seitenmigration' ),
	'PagePreparation' => array( 'Seitenvorbereitung' ),
);

/** Zazaki (Zazaki) */
$specialPageAliases['diq'] = array(
	'AggregateGroups' => array( 'GrubéAggregate' ),
	'ImportTranslations' => array( 'AçarnayışaZerrefi' ),
	'LanguageStats' => array( 'Zıwanİst' ),
	'Magic' => array( 'AçarnayışoHerayen' ),
	'ManageMessageGroups' => array( 'GrubanéMesacanİdareke' ),
	'ManageTranslatorSandbox' => array( 'İdareyaQumdorAçarnayış', 'QumdorAçarnayış' ),
	'MessageGroupStats' => array( 'İstatistikéGrubandéMesacan' ),
	'MyLanguage' => array( 'ZıwaneMe' ),
	'PageTranslation' => array( 'PerraAçarnayış' ),
	'PageTranslationDeletePage' => array( 'PerraAçarnayışéPerraBesternayış' ),
	'SearchTranslations' => array( 'AçarnayışaCıgeyreyış' ),
	'SupportedLanguages' => array( 'ZıwanêkeDestegnênê' ),
	'Translate' => array( 'Açarnayış' ),
	'TranslationStash' => array( 'AçarnayışiNımnanyış' ),
	'TranslationStats' => array( 'İstatistikéAçarnayışi' ),
	'Translations' => array( 'Açarnoği' ),
);

/** Lower Sorbian (dolnoserbski) */
$specialPageAliases['dsb'] = array(
	'LanguageStats' => array( 'Rěcne statistiki' ),
	'Magic' => array( 'Rozšyrjone pśełožowanje' ),
	'Translate' => array( 'Přełožiś' ),
	'TranslationStats' => array( 'Statistika pśełožkow' ),
	'Translations' => array( 'Pśełožki' ),
);

/** Divehi (ދިވެހިބަސް) */
$specialPageAliases['dv'] = array(
	'Translate' => array( 'ތަރުޖަމާކުރައްވާ' ),
	'Translations' => array( 'ތަރުޖަމާތައް' ),
);

/** Greek (Ελληνικά) */
$specialPageAliases['el'] = array(
	'AggregateGroups' => array( 'ΣυγκεντρωτικέςΟμάδες' ),
	'ImportTranslations' => array( 'ΕισαγωγήΜεταφράσεων' ),
	'LanguageStats' => array( 'ΣτατιστικάΓλώσσας' ),
	'Magic' => array( 'ΠροχωρημένηΜετάφραση', 'ΜαγικέςΛέξεις' ),
	'ManageMessageGroups' => array( 'ΔιαχείρισηΟμάδωνΜηνυμάτων' ),
	'ManageTranslatorSandbox' => array( 'ΔιαχείρισηΑμμοδοχείουΜεταφραστή', 'ΑμμοδοχείοΜετάφρασης' ),
	'MessageGroupStats' => array( 'ΣτατιστικάΟμάδαςΜηνυμάτων' ),
	'MyLanguage' => array( 'ΗΓλώσσαΜου' ),
	'PageTranslation' => array( 'ΜετάφρασηΣελίδας' ),
	'PageTranslationDeletePage' => array( 'ΔιαγραφήΣελίδαςΜετάφρασηςΣελίδων' ),
	'SearchTranslations' => array( 'ΑναζήτησηΜεταφράσεων' ),
	'SupportedLanguages' => array( 'ΥποστηριζόμενεςΓλώσσες' ),
	'Translate' => array( 'Μετάφραση' ),
	'TranslationStats' => array( 'ΣτατιστικάΜετάφρασης' ),
	'Translations' => array( 'Μεταφράσεις' ),
);

/** Esperanto (Esperanto) */
$specialPageAliases['eo'] = array(
	'ImportTranslations' => array( 'Enporti_tradukojn', 'Importi_tradukojn' ),
	'LanguageStats' => array( 'Lingvaj_statistikoj' ),
	'Magic' => array( 'Altnivela_tradukado' ),
	'MyLanguage' => array( 'Mia_lingvo' ),
	'SearchTranslations' => array( 'Serĉi_tradukojn' ),
	'SupportedLanguages' => array( 'Subtenataj_lingvoj' ),
	'Translate' => array( 'Traduki' ),
	'TranslationStats' => array( 'Statistikol_pri_tradukado' ),
	'Translations' => array( 'Tradukoj' ),
);

/** Spanish (español) */
$specialPageAliases['es'] = array(
	'Magic' => array( 'Traducción_avanzada' ),
	'MyLanguage' => array( 'MiIdioma', 'Mi_idioma' ),
	'SupportedLanguages' => array( 'IdiomasAdmitidos' ),
	'Translate' => array( 'Traducir' ),
	'Translations' => array( 'Traducciones' ),
);

/** Persian (فارسی) */
$specialPageAliases['fa'] = array(
	'AggregateGroups' => array( 'جمع_گروه‌ها' ),
	'ImportTranslations' => array( 'درون‌بری_ترجمه‌ها' ),
	'LanguageStats' => array( 'آمار_زبان‌ها' ),
	'Magic' => array( 'ترجمه_پیشرفته' ),
	'ManageMessageGroups' => array( 'مدیریت_گروه‌های_پیغام' ),
	'ManageTranslatorSandbox' => array( 'مدیریت_صفحهٔ_تمرین_ترجمه', 'صفحهٔ_تمرین_ترجمه' ),
	'MessageGroupStats' => array( 'آمار_گروه_پیغام' ),
	'MyLanguage' => array( 'زبان‌های_من' ),
	'PageTranslation' => array( 'ترجمه_صفحه' ),
	'PageTranslationDeletePage' => array( 'صفحه_حذف_ترجمه_صفحه' ),
	'SearchTranslations' => array( 'جستجوی_ترجمه‌ها' ),
	'SupportedLanguages' => array( 'زبان‌های_پشتیبانی‌شده' ),
	'Translate' => array( 'ترجمه' ),
	'TranslationStats' => array( 'آمار_ترجمه‌ها' ),
	'Translations' => array( 'ترجمه‌ها' ),
	'PageMigration' => array( 'مهاجرت_صفحه' ),
);

/** Finnish (suomi) */
$specialPageAliases['fi'] = array(
	'ImportTranslations' => array( 'Käännösten_tuonti' ),
	'LanguageStats' => array( 'Kielitilastot' ),
	'Magic' => array( 'Laajennettu_kääntäminen' ),
	'ManageMessageGroups' => array( 'Viestiryhmien_hallinta' ),
	'MyLanguage' => array( 'Oma_kieli' ),
	'PageTranslation' => array( 'Sivujen_kääntäminen' ),
	'SupportedLanguages' => array( 'Tuetut_kielet' ),
	'Translate' => array( 'Käännä' ),
	'TranslationStats' => array( 'Käännöstilastot' ),
	'Translations' => array( 'Käännökset' ),
);

/** French (français) */
$specialPageAliases['fr'] = array(
	'LanguageStats' => array( 'StatistiquesDesLangues', 'Statistiques_des_langues' ),
	'Magic' => array( 'Traduction_avancée', 'Traductionavancée', 'Traduction_avancee', 'Traductionavancee' ),
	'MyLanguage' => array( 'MaLangue', 'Ma_langue' ),
	'Translate' => array( 'Traduire' ),
	'TranslationStats' => array( 'StatistiquesDesTraductions', 'Statistiques_des_traductions' ),
	'Translations' => array( 'Traductions' ),
);

/** Franco-Provençal (arpetan) */
$specialPageAliases['frp'] = array(
	'LanguageStats' => array( 'Statistiques_de_les_lengoues', 'StatistiquesDeLesLengoues' ),
	'Magic' => array( 'Traduccion_avanciê', 'TraduccionAavanciê' ),
	'Translate' => array( 'Traduire' ),
	'TranslationStats' => array( 'Statistiques_de_traduccion', 'StatistiquesDeTraduccion' ),
	'Translations' => array( 'Traduccions' ),
);

/** Galician (galego) */
$specialPageAliases['gl'] = array(
	'ImportTranslations' => array( 'Importar_traducións' ),
	'LanguageStats' => array( 'Estatísticas_da_lingua' ),
	'Magic' => array( 'Tradución_avanzada' ),
	'PageTranslation' => array( 'Tradución_de_páxinas' ),
	'Translate' => array( 'Traducir' ),
	'TranslationStats' => array( 'Estatísticas_da_tradución' ),
	'Translations' => array( 'Traducións' ),
);

/** Swiss German (Alemannisch) */
$specialPageAliases['gsw'] = array(
	'ImportTranslations' => array( 'Übersetzige_importiere' ),
	'LanguageStats' => array( 'Sprochstatischtik' ),
	'Magic' => array( 'Usgwytets_Ibersetze' ),
	'ManageMessageGroups' => array( 'Noochrichtegruppe_verwalte' ),
	'MessageGroupStats' => array( 'Noochrichtegruppestatistike' ),
	'MyLanguage' => array( 'Myyni_Sprooch' ),
	'PageTranslation' => array( 'Übersetzig_vo_Syte' ),
	'PageTranslationDeletePage' => array( 'Löschsyte_für_Übersetzige' ),
	'SupportedLanguages' => array( 'Sprooche_wo_unterstützt_werde' ),
	'Translate' => array( 'Ibersetze' ),
	'TranslationStats' => array( 'Ibersetzigsstatischtik' ),
	'Translations' => array( 'Ibersetzige' ),
);

/** Hebrew (עברית) */
$specialPageAliases['he'] = array(
	'ImportTranslations' => array( 'ייבוא_תרגומים' ),
	'LanguageStats' => array( 'סטטיסטיקות_שפה' ),
	'Magic' => array( 'תרגום_מתקדם' ),
	'ManageMessageGroups' => array( 'ניהול_קבוצות_הודעות' ),
	'ManageTranslatorSandbox' => array( 'ניהול_ארגז_חול_של_מתרגמים' ),
	'MessageGroupStats' => array( 'סטטיסטיקות_של_קבוצות_הודעות' ),
	'MyLanguage' => array( 'השפה_שלי' ),
	'PageTranslation' => array( 'תרגום_דף' ),
	'PageTranslationDeletePage' => array( 'מחיקת_דף_מתורגם' ),
	'SearchTranslations' => array( 'חיפוש_תרגומים' ),
	'SupportedLanguages' => array( 'שפות_נתמכות' ),
	'Translate' => array( 'תרגום' ),
	'TranslationStash' => array( 'מחסן_תרגומים' ),
	'TranslationStats' => array( 'סטטיסטיקות_תרגום' ),
	'Translations' => array( 'תרגומים' ),
	'PageMigration' => array( 'המרת_דף' ),
);

/** Hindi (हिन्दी) */
$specialPageAliases['hi'] = array(
	'Translate' => array( 'अनुवाद' ),
);

/** Croatian (hrvatski) */
$specialPageAliases['hr'] = array(
	'Translate' => array( 'Prevedi' ),
);

/** Upper Sorbian (hornjoserbsce) */
$specialPageAliases['hsb'] = array(
	'ImportTranslations' => array( 'Přełožki_importować' ),
	'LanguageStats' => array( 'Rěčne_statistiki' ),
	'Magic' => array( 'Rozšěrjene_přełožowanje', 'Magiske' ),
	'MyLanguage' => array( 'Moja_rěč' ),
	'PageTranslation' => array( 'Přełožowanje_stronow' ),
	'SearchTranslations' => array( 'Přełožki_pytać' ),
	'SupportedLanguages' => array( 'Podpěrane_rěče' ),
	'Translate' => array( 'Přełožić' ),
	'TranslationStats' => array( 'Statistika_přełožkow' ),
	'Translations' => array( 'Přełožki' ),
);

/** Haitian (Kreyòl ayisyen) */
$specialPageAliases['ht'] = array(
	'ImportTranslations' => array( 'EnpòteTradiksyon' ),
	'LanguageStats' => array( 'EstatistikLang' ),
	'Magic' => array( 'TradiksyonAvanse', 'Magik' ),
	'ManageMessageGroups' => array( 'GereGwoupMesaj' ),
	'MyLanguage' => array( 'LangMwen' ),
	'PageTranslation' => array( 'TradiksyonPaj' ),
	'SupportedLanguages' => array( 'LangSipòte' ),
	'Translate' => array( 'Tradui' ),
	'TranslationStats' => array( 'EstatistikTradiksyon' ),
	'Translations' => array( 'TradiksyonYo' ),
);

/** Hungarian (magyar) */
$specialPageAliases['hu'] = array(
	'LanguageStats' => array( 'Nyelvi_statisztika' ),
	'Magic' => array( 'Fejlettebb_fordító' ),
	'Translate' => array( 'Fordítás' ),
	'TranslationStats' => array( 'Fordítási_statisztika' ),
	'Translations' => array( 'Fordítások' ),
);

/** Interlingua (interlingua) */
$specialPageAliases['ia'] = array(
	'ImportTranslations' => array( 'Importar_traductiones' ),
	'LanguageStats' => array( 'Statisticas_de_linguas' ),
	'Magic' => array( 'Traduction_avantiate', 'Magia' ),
	'ManageMessageGroups' => array( 'Gerer_gruppos_de_messages' ),
	'MessageGroupStats' => array( 'Statisticas_de_gruppos_de_messages' ),
	'MyLanguage' => array( 'Mi_lingua' ),
	'PageTranslation' => array( 'Traduction_de_paginas' ),
	'PageTranslationDeletePage' => array( 'Deler_pagina_traducite' ),
	'SupportedLanguages' => array( 'Linguas_supportate' ),
	'Translate' => array( 'Traducer' ),
	'TranslationStats' => array( 'Statisticas_de_traduction' ),
	'Translations' => array( 'Traductiones' ),
);

/** Indonesian (Bahasa Indonesia) */
$specialPageAliases['id'] = array(
	'ImportTranslations' => array( 'Impor_terjemahan', 'ImporTerjemahan' ),
	'LanguageStats' => array( 'Statistik_bahasa', 'StatistikBahasa' ),
	'Magic' => array( 'Terjemahkan_lanjut', 'TerjemahkanLanjut' ),
	'ManageMessageGroups' => array( 'Kelola_pesan_grup', 'KelolaPesanGrup' ),
	'MessageGroupStats' => array( 'Statistik_pesan_grup', 'StatistikPesanGrup' ),
	'MyLanguage' => array( 'Bahasa_saya' ),
	'PageTranslation' => array( 'Terjemahan_halaman', 'TerjemahanHalaman' ),
	'SearchTranslations' => array( 'Cari_terjemahan', 'CariTerjemahan' ),
	'SupportedLanguages' => array( 'Bahasa_yang_didukung', 'BahasaDidukung' ),
	'Translate' => array( 'Terjemahkan' ),
	'TranslationStats' => array( 'Statistik_terjemahan', 'StatistikTerjemahan' ),
	'Translations' => array( 'Terjemahan' ),
);

/** Icelandic (íslenska) */
$specialPageAliases['is'] = array(
	'Translate' => array( 'Þýða' ),
);

/** Italian (italiano) */
$specialPageAliases['it'] = array(
	'AggregateGroups' => array( 'GruppiAggregati' ),
	'ImportTranslations' => array( 'ImportaTraduzioni' ),
	'LanguageStats' => array( 'StatisticheLingua' ),
	'Magic' => array( 'TraduciAvanzato' ),
	'ManageMessageGroups' => array( 'GestisciGruppiMessaggio' ),
	'MessageGroupStats' => array( 'StatisticheGruppiMessaggio' ),
	'MyLanguage' => array( 'MiaLingua' ),
	'PageTranslation' => array( 'TraduzionePagina' ),
	'SearchTranslations' => array( 'CercaTraduzioni' ),
	'SupportedLanguages' => array( 'LingueSupportate' ),
	'Translate' => array( 'Traduci' ),
	'TranslationStats' => array( 'StatisticheTraduzione' ),
	'Translations' => array( 'Traduzioni' ),
);

/** Japanese (日本語) */
$specialPageAliases['ja'] = array(
	'AggregateGroups' => array( '集約群' ),
	'ImportTranslations' => array( '翻訳取り込み', '翻訳インポート' ),
	'LanguageStats' => array( '言語統計' ),
	'Magic' => array( '高度な翻訳' ),
	'ManageMessageGroups' => array( 'メッセージ群の管理' ),
	'ManageTranslatorSandbox' => array( '翻訳者サンドボックスの管理' ),
	'MessageGroupStats' => array( 'メッセージグループ統計' ),
	'MyLanguage' => array( '自分の言語' ),
	'PageTranslation' => array( 'ページ翻訳' ),
	'PageTranslationDeletePage' => array( 'ページ翻訳削除ページ' ),
	'SearchTranslations' => array( '翻訳の検索' ),
	'SupportedLanguages' => array( 'サポートしている言語' ),
	'Translate' => array( '翻訳' ),
	'TranslationStats' => array( '翻訳統計' ),
	'Translations' => array( '翻訳結果' ),
);

/** Georgian (ქართული) */
$specialPageAliases['ka'] = array(
	'LanguageStats' => array( 'ენის_სტატისტიკა' ),
	'MyLanguage' => array( 'ჩემი_ენა' ),
	'SupportedLanguages' => array( 'მხარდაჭერილი_ენები' ),
	'Translate' => array( 'თარგმნა' ),
	'TranslationStats' => array( 'თარგმნის_სტატისტიკა' ),
	'Translations' => array( 'თარგმანები' ),
);

/** Khmer (ភាសាខ្មែរ) */
$specialPageAliases['km'] = array(
	'ImportTranslations' => array( 'ការបកប្រែនាំចូល' ),
	'LanguageStats' => array( 'ស្ថិតិភាសា' ),
	'Magic' => array( 'បកប្រែថ្នាក់ខ្ពស់' ),
	'ManageMessageGroups' => array( 'គ្រប់គ្រងក្រុមសារ' ),
	'MyLanguage' => array( 'ភាសារបស់ខ្ញុំ' ),
	'PageTranslation' => array( 'ការបកប្រែទំព័រ' ),
	'SupportedLanguages' => array( 'ភាសាដែលអាចប្រើបាន' ),
	'Translate' => array( 'បកប្រែ' ),
	'TranslationStats' => array( 'ស្ថិតិការបកប្រែ' ),
	'Translations' => array( 'ការបកប្រែ' ),
);

/** Korean (한국어) */
$specialPageAliases['ko'] = array(
	'AggregateGroups' => array( '집계그룹' ),
	'ImportTranslations' => array( '번역가져오기' ),
	'LanguageStats' => array( '언어통계' ),
	'Magic' => array( '고급번역' ),
	'ManageMessageGroups' => array( '메시지그룹관리' ),
	'ManageTranslatorSandbox' => array( '번역자연습장관리', '번역연습장' ),
	'MessageGroupStats' => array( '메시지그룹통계' ),
	'MyLanguage' => array( '내언어' ),
	'PageTranslation' => array( '문서번역' ),
	'PageTranslationDeletePage' => array( '문서번역삭제문서' ),
	'SearchTranslations' => array( '번역검색', '번역찾기' ),
	'SupportedLanguages' => array( '지원하는언어' ),
	'Translate' => array( '번역' ),
	'TranslationStash' => array( '비공개번역' ),
	'TranslationStats' => array( '번역통계' ),
	'Translations' => array( '번역목록' ),
	'PageMigration' => array( '문서이주' ),
);

/** Karachay-Balkar (къарачай-малкъар) */
$specialPageAliases['krc'] = array(
	'MyLanguage' => array( 'Мени_тилим' ),
);

/** Colognian (Ripoarisch) */
$specialPageAliases['ksh'] = array(
	'LanguageStats' => array( 'Shtatistike_vu_de_Shprooche' ),
	'Magic' => array( 'Extras', 'Extras Översäze', 'ExtrasÖversäze' ),
	'Translate' => array( 'Övversäze' ),
	'TranslationStats' => array( 'Statistik vun fun de Övversäzung', 'Övversäzungszahle', 'Statistik vun fun de Övversäzong', 'Övversäzongszahle' ),
	'Translations' => array( 'Övversätzunge' ),
);

/** Kurdish (Latin script) (Kurdî (latînî)‎) */
$specialPageAliases['ku-latn'] = array(
	'MyLanguage' => array( 'Zimanê_Min' ),
	'Translate' => array( 'Wergerîne' ),
	'Translations' => array( 'Werger' ),
);

/** Cornish (kernowek) */
$specialPageAliases['kw'] = array(
	'ImportTranslations' => array( 'YmperthiTreylyansow' ),
	'LanguageStats' => array( 'StatystygyonYeth' ),
	'Magic' => array( 'TreylyaAvonsys' ),
	'MyLanguage' => array( 'OwYeth' ),
	'PageTranslation' => array( 'TreylyansFolennow' ),
	'SupportedLanguages' => array( 'YethowSkoodhys' ),
	'Translate' => array( 'Treylya' ),
	'TranslationStats' => array( 'StatystygronTreylya' ),
	'Translations' => array( 'Treylyansow' ),
);

/** Luxembourgish (Lëtzebuergesch) */
$specialPageAliases['lb'] = array(
	'ImportTranslations' => array( 'Iwwersetzungen_importéieren' ),
	'LanguageStats' => array( 'Sproochestatistiken' ),
	'Magic' => array( 'Erweidert_Iwwersetzung' ),
	'ManageMessageGroups' => array( 'Gruppe_vu_Message_geréieren' ),
	'ManageTranslatorSandbox' => array( 'Iwwersetzungssandkëscht_geréieren' ),
	'MessageGroupStats' => array( 'Statistike_vun_de_Gruppe_vu_Messagen' ),
	'MyLanguage' => array( 'Meng_Sprooch' ),
	'PageTranslation' => array( 'Säiten-Iwwersetzung' ),
	'PageTranslationDeletePage' => array( 'Läschsäit_fir_Iwwersetzungen' ),
	'SearchTranslations' => array( 'Iwwersetzunge_sichen' ),
	'SupportedLanguages' => array( 'Ënnerstetzt_Sproochen' ),
	'Translate' => array( 'Iwwersetzen' ),
	'TranslationStats' => array( 'Iwwersetzungsstatistiken' ),
	'Translations' => array( 'Iwwersetzungen' ),
);

/** lumbaart (lumbaart) */
$specialPageAliases['lmo'] = array(
	'Translate' => array( 'Volta' ),
	'Translations' => array( 'Tradüzion' ),
);

/** Lithuanian (lietuvių) */
$specialPageAliases['lt'] = array(
	'PageTranslation' => array( 'Puslapio vertimas' ),
	'Translate' => array( 'Vertimas' ),
);

/** Literary Chinese (文言) */
$specialPageAliases['lzh'] = array(
	'Translate' => array( '譯' ),
);

/** Macedonian (македонски) */
$specialPageAliases['mk'] = array(
	'AggregateGroups' => array( 'ЗбирниГрупи' ),
	'ImportTranslations' => array( 'УвезиПреводи' ),
	'LanguageStats' => array( 'СтатистикиЗаЈазик' ),
	'Magic' => array( 'НапредноПреведување' ),
	'ManageMessageGroups' => array( 'РаководењеСоГрупиНаПораки' ),
	'ManageTranslatorSandbox' => array( 'РаководиПреведувачкиПесочник' ),
	'MessageGroupStats' => array( 'СтатистикиЗаГупиПораки' ),
	'MyLanguage' => array( 'МојЈазик' ),
	'PageTranslation' => array( 'ПреводНаСтраницата' ),
	'PageTranslationDeletePage' => array( 'ПреводНаСтраницаИзбришиСтраница' ),
	'SearchTranslations' => array( 'ПребарајПреводи' ),
	'SupportedLanguages' => array( 'ПоддржаниЈазици' ),
	'Translate' => array( 'Преведување' ),
	'TranslationStash' => array( 'ПреведувачкиСклад' ),
	'TranslationStats' => array( 'СтатистикиЗаПреведување' ),
	'Translations' => array( 'Преводи' ),
	'PageMigration' => array( 'СелењеСтраници' ),
	'PagePreparation' => array( 'ПодготовнаНаСтраници' ),
);

/** Malayalam (മലയാളം) */
$specialPageAliases['ml'] = array(
	'ImportTranslations' => array( 'പരിഭാഷാ_ഇറക്കുമതി' ),
	'LanguageStats' => array( 'ഭാഷാസ്ഥിതിവിവരം' ),
	'Magic' => array( 'വിപുലീകൃതപരിഭാഷ', 'മായാജാലം' ),
	'ManageMessageGroups' => array( 'സന്ദേശസംഘങ്ങളുടെകൈകാര്യം' ),
	'MessageGroupStats' => array( 'സന്ദേശഗണസ്ഥിതിവിവരം' ),
	'MyLanguage' => array( 'എന്റെഭാഷ' ),
	'PageTranslation' => array( 'താളിന്റെപരിഭാഷ' ),
	'SearchTranslations' => array( 'പരിഭാഷകളിൽതിരയുക' ),
	'SupportedLanguages' => array( 'പിന്തുണയുള്ളഭാഷകൾ' ),
	'Translate' => array( 'പരിഭാഷ' ),
	'TranslationStats' => array( 'പരിഭാഷാസ്ഥിതിവിവരം' ),
	'Translations' => array( 'പരിഭാഷകൾ' ),
);

/** Marathi (मराठी) */
$specialPageAliases['mr'] = array(
	'ImportTranslations' => array( 'भाषांतराआयात' ),
	'LanguageStats' => array( 'भाषासांख्यिकी' ),
	'Magic' => array( 'प्रगतभाषांतर', 'जादुई' ),
	'MyLanguage' => array( 'माझीभाषा' ),
	'PageTranslation' => array( 'पृष्ठभाषांतर', 'पृष्ठअनुवाद' ),
	'SearchTranslations' => array( 'अनुवाद_शोधा' ),
	'Translate' => array( 'भाषांतर' ),
	'TranslationStats' => array( 'भाषांतरसांख्यिकी' ),
	'Translations' => array( 'भाषांतरणे' ),
);

/** Malay (Bahasa Melayu) */
$specialPageAliases['ms'] = array(
	'Translate' => array( 'Terjemah' ),
	'Translations' => array( 'Terjemahan' ),
);

/** Maltese (Malti) */
$specialPageAliases['mt'] = array(
	'LanguageStats' => array( 'StatistikaLingwa' ),
	'Magic' => array( 'TraduzzjoniAvvanzata' ),
	'PageTranslation' => array( 'TraduzzjoniPaġna' ),
	'Translate' => array( 'Traduzzjoni' ),
	'TranslationStats' => array( 'StatistikaTraduzzjoni' ),
	'Translations' => array( 'Traduzzjonijiet' ),
);

/** Mirandese (Mirandés) */
$specialPageAliases['mwl'] = array(
	'Magic' => array( 'Traduçon Abançada' ),
	'Translate' => array( 'Traduzir' ),
	'TranslationStats' => array( 'Stado de la traduçon' ),
	'Translations' => array( 'Traduçones' ),
);

/** Erzya (эрзянь) */
$specialPageAliases['myv'] = array(
	'Magic' => array( 'ПревейстэЮтавтомс', 'Магия' ),
	'MyLanguage' => array( 'Келем' ),
	'Translate' => array( 'Ютавтомс' ),
	'TranslationStats' => array( 'ЮтавтомадоСтатистика' ),
);

/** Nahuatl (Nāhuatl) */
$specialPageAliases['nah'] = array(
	'Translate' => array( 'Tlahtōlcuepāz', 'Traducir' ),
);

/** Norwegian Bokmål (norsk bokmål) */
$specialPageAliases['nb'] = array(
	'AggregateGroups' => array( 'Samlingsgrupper' ),
	'ImportTranslations' => array( 'Importer_oversettelser' ),
	'LanguageStats' => array( 'Språkstatistikk' ),
	'Magic' => array( 'Avansert_oversettelse', 'Avansert_oversetting', 'Magi' ),
	'ManageMessageGroups' => array( 'Behandle_meldingsgrupper' ),
	'MessageGroupStats' => array( 'Meldingsgruppestatistikk' ),
	'MyLanguage' => array( 'Mitt_språk' ),
	'PageTranslation' => array( 'Sideoversettelse' ),
	'SearchTranslations' => array( 'Søk_i_oversettelser' ),
	'SupportedLanguages' => array( 'Støttede_språk' ),
	'Translate' => array( 'Oversett' ),
	'TranslationStats' => array( 'Oversettelsesstatistikk' ),
	'Translations' => array( 'Oversettelser' ),
);

/** Low German (Plattdüütsch) */
$specialPageAliases['nds'] = array(
	'Translate' => array( 'Översetten' ),
);

/** Low Saxon (Netherlands) (Nedersaksies) */
$specialPageAliases['nds-nl'] = array(
	'AggregateGroups' => array( 'Samen-evoegden_groepen' ),
	'ImportTranslations' => array( 'Vertalingen_invoeren' ),
	'LanguageStats' => array( 'Taalstaotistieken' ),
	'Magic' => array( 'Uutebreid_vertalen' ),
	'ManageMessageGroups' => array( 'Berichtengroepen_beheren' ),
	'ManageTranslatorSandbox' => array( 'Vertalers_zaandkule_beheren' ),
	'MyLanguage' => array( 'Mien_taal' ),
	'PageTranslation' => array( 'Ziedvertaling' ),
	'PageTranslationDeletePage' => array( 'Ziedvertaling_zied_vortdoon' ),
	'SearchTranslations' => array( 'Vertalingen_zeuken' ),
	'SupportedLanguages' => array( 'Ondersteunde_talen' ),
	'Translate' => array( 'Vertalen' ),
	'TranslationStats' => array( 'Vertaalstaotistieken' ),
	'Translations' => array( 'Vertalingen' ),
);

/** Dutch (Nederlands) */
$specialPageAliases['nl'] = array(
	'AggregateGroups' => array( 'SamengevoegdeGroepen' ),
	'ImportTranslations' => array( 'VertalingenImporteren' ),
	'LanguageStats' => array( 'Taalstatistieken' ),
	'Magic' => array( 'UitgebreidVertalen', 'VertalenUitgebreid' ),
	'ManageMessageGroups' => array( 'BerichtengroepenBeheren' ),
	'ManageTranslatorSandbox' => array( 'VertalerszandbakBeheren' ),
	'MessageGroupStats' => array( 'Berichtengroepstatistieken' ),
	'MyLanguage' => array( 'MijnTaal' ),
	'PageTranslation' => array( 'Paginavertaling' ),
	'PageTranslationDeletePage' => array( 'PaginavertalingpaginaVerwijderen' ),
	'SearchTranslations' => array( 'VertalingenZoeken' ),
	'SupportedLanguages' => array( 'OndersteundeTalen' ),
	'Translate' => array( 'Vertalen' ),
	'TranslationStats' => array( 'Vertaalstatistieken', 'Vertalingsstatistieken' ),
	'Translations' => array( 'Vertalingen' ),
	'PageMigration' => array( 'PaginaMigreren' ),
);

/** Norwegian Nynorsk (norsk nynorsk) */
$specialPageAliases['nn'] = array(
	'Magic' => array( 'Avansert_omsetjing' ),
	'MyLanguage' => array( 'Språket_mitt' ),
	'Translate' => array( 'Set_om' ),
	'Translations' => array( 'Omsetjingar' ),
);

/** Occitan (occitan) */
$specialPageAliases['oc'] = array(
	'Magic' => array( 'Traduccion avançada', 'Traduccionavançada', 'Traduccion avancada', 'Traduccionavancada' ),
	'Translate' => array( 'Traduire', 'Tradusir' ),
	'Translations' => array( 'Traduccions', 'Reviradas' ),
);

/** Oriya (ଓଡ଼ିଆ) */
$specialPageAliases['or'] = array(
	'Translate' => array( 'ଅନୁବାଦ' ),
	'Translations' => array( 'ଅନୁବାଦସମୂହ' ),
);

/** Punjabi (ਪੰਜਾਬੀ) */
$specialPageAliases['pa'] = array(
	'Magic' => array( 'ਉੱਚੇ_ਦਰਜੇ_ਦਾ_ਉਲਥਾ', 'ਜਾਦੂ' ),
	'MyLanguage' => array( 'ਮੇਰੀ_ਭਾਸ਼ਾ', 'ਮੇਰੀ_ਬੋਲੀ' ),
	'PageTranslation' => array( 'ਸਫ਼ੇ_ਦਾ_ਉਲਥਾ', 'ਸਫ਼ੇ_ਦਾ_ਤਰਜਮਾ' ),
	'Translate' => array( 'ਉਲਥਾਓ', 'ਤਰਜਮਾ_ਕਰੋ' ),
);

/** Polish (polski) */
$specialPageAliases['pl'] = array(
	'AggregateGroups' => array( 'Grupy_zbiorcze' ),
	'ImportTranslations' => array( 'Import_tłumaczeń' ),
	'LanguageStats' => array( 'Statystyka_językowa' ),
	'Magic' => array( 'Rozszerzone_tłumaczenie_MediaWiki' ),
	'ManageMessageGroups' => array( 'Zarządzanie_grupami_komunikatów' ),
	'MyLanguage' => array( 'Mój_język' ),
	'PageTranslation' => array( 'Tłumaczenie_strony' ),
	'SupportedLanguages' => array( 'Wspierane_języki' ),
	'Translate' => array( 'Przetłumacz' ),
	'TranslationStats' => array( 'Statystyki_tłumaczenia' ),
	'Translations' => array( 'Tłumaczenia' ),
	'PageMigration' => array( 'Migracja_strony' ),
	'PagePreparation' => array( 'Przygotowanie_strony' ),
);

/** Pashto (پښتو) */
$specialPageAliases['ps'] = array(
	'Magic' => array( 'پرمختللې ژباړه، کوډګريز' ),
	'Translate' => array( 'ژباړل' ),
	'Translations' => array( 'ژباړې' ),
);

/** Portuguese (português) */
$specialPageAliases['pt'] = array(
	'ImportTranslations' => array( 'Importar_traduções' ),
	'LanguageStats' => array( 'Estatísticas_de_línguas' ),
	'Magic' => array( 'Tradução_avançada' ),
	'PageTranslation' => array( 'Tradução_de_páginas' ),
	'Translate' => array( 'Traduzir' ),
	'TranslationStats' => array( 'Estatísticas_de_traduções' ),
	'Translations' => array( 'Traduções' ),
);

/** Brazilian Portuguese (português do Brasil) */
$specialPageAliases['pt-br'] = array(
	'Magic' => array( 'Tradução_avançada' ),
	'Translate' => array( 'Traduzir' ),
	'TranslationStats' => array( 'Estado_da_tradução', 'Status_da_tradução' ),
);

/** Quechua (Runa Simi) */
$specialPageAliases['qu'] = array(
	'Magic' => array( 'NawparikusqaTikray' ),
	'ManageTranslatorSandbox' => array( 'TikranaPukllana' ),
	'MyLanguage' => array( 'Rimayniy' ),
	'Translate' => array( 'Tikray' ),
);

/** Romanian (română) */
$specialPageAliases['ro'] = array(
	'ImportTranslations' => array( 'Importare_traduceri' ),
	'LanguageStats' => array( 'Statistici_limbă' ),
	'Magic' => array( 'Traducere_avansată' ),
	'PageTranslation' => array( 'Traducere_pagină' ),
	'Translate' => array( 'Traducere' ),
	'TranslationStats' => array( 'Statistici_traduceri' ),
	'Translations' => array( 'Traduceri' ),
);

/** Russian (русский) */
$specialPageAliases['ru'] = array(
	'AggregateGroups' => array( 'Агрегированные_группы' ),
	'ImportTranslations' => array( 'Импорт_переводов' ),
	'LanguageStats' => array( 'Статистика_языка' ),
	'Magic' => array( 'Расширенный_перевод' ),
	'ManageMessageGroups' => array( 'Управление_группами_сообщений' ),
	'MessageGroupStats' => array( 'Статистика_группы_сообщений' ),
	'MyLanguage' => array( 'Мой_язык' ),
	'PageTranslation' => array( 'Перевод_страниц' ),
	'PageTranslationDeletePage' => array( 'Удаление_переводимой_страницы' ),
	'SearchTranslations' => array( 'Поиск_переводов' ),
	'SupportedLanguages' => array( 'Поддерживаемые_языки' ),
	'Translate' => array( 'Перевести' ),
	'TranslationStats' => array( 'Статистика_переводов' ),
	'Translations' => array( 'Переводы' ),
);

/** Sanskrit (संस्कृतम्) */
$specialPageAliases['sa'] = array(
	'LanguageStats' => array( 'भाषासांख्यिकी' ),
	'Magic' => array( 'प्रगतभाषांतरमाया' ),
	'Translate' => array( 'भाषांतर' ),
	'TranslationStats' => array( 'भाषांतरसांख्यिकी' ),
	'Translations' => array( 'भाषांतरानि' ),
);

/** Sicilian (sicilianu) */
$specialPageAliases['scn'] = array(
	'AggregateGroups' => array( 'GruppiAggregati' ),
	'ImportTranslations' => array( 'ImportaTraduzioni' ),
	'LanguageStats' => array( 'StatisticheLingua' ),
	'Magic' => array( 'TraduciAvanzato' ),
	'ManageMessageGroups' => array( 'GestisciGruppiMessaggio' ),
	'MessageGroupStats' => array( 'MessaggioGruppoStat' ),
	'MyLanguage' => array( 'MiaLingua' ),
	'PageTranslation' => array( 'TraduzionePagina' ),
	'SupportedLanguages' => array( 'LingueSupportate' ),
	'Translate' => array( 'Traduci' ),
	'TranslationStats' => array( 'StatisticheTraduzione' ),
	'Translations' => array( 'Traduzioni' ),
);

/** Sinhala (සිංහල) */
$specialPageAliases['si'] = array(
	'Translate' => array( 'පරිවර්තනය' ),
);

/** Slovak (slovenčina) */
$specialPageAliases['sk'] = array(
	'LanguageStats' => array( 'ŠtatistikyJazykov' ),
	'Magic' => array( 'RozšírenéPreložiť' ),
	'PageTranslation' => array( 'PrekladStránky' ),
	'Translate' => array( 'Preložiť' ),
	'TranslationStats' => array( 'ŠtatistikyPrekladov' ),
	'Translations' => array( 'Preklady' ),
);

/** Albanian (shqip) */
$specialPageAliases['sq'] = array(
	'Translate' => array( 'Përkthe' ),
);

/** Serbian (Cyrillic script) (српски (ћирилица)‎) */
$specialPageAliases['sr-ec'] = array(
	'ImportTranslations' => array( 'Увоз_превода' ),
	'LanguageStats' => array( 'Статистика_језика' ),
	'Magic' => array( 'Напредно_превођење' ),
	'ManageMessageGroups' => array( 'Управљање_групама_порука' ),
	'MyLanguage' => array( 'Мој_језик' ),
	'PageTranslation' => array( 'Превод_странице' ),
	'SupportedLanguages' => array( 'Подржани_језици' ),
	'Translate' => array( 'Преведи' ),
	'TranslationStats' => array( 'Статистика_превода' ),
	'Translations' => array( 'Преводи' ),
);

/** Sundanese (Basa Sunda) */
$specialPageAliases['su'] = array(
	'LanguageStats' => array( 'StatBasa' ),
	'Magic' => array( 'TarjamahTeleb' ),
	'Translate' => array( 'Tarjamah' ),
	'TranslationStats' => array( 'StatTarjamah' ),
	'Translations' => array( 'Tarjamahan' ),
);

/** Swedish (svenska) */
$specialPageAliases['sv'] = array(
	'ImportTranslations' => array( 'Importera_översättningar' ),
	'LanguageStats' => array( 'Språkstatistik' ),
	'Magic' => array( 'Avancerad_översättning' ),
	'MyLanguage' => array( 'Mitt_språk' ),
	'Translate' => array( 'Översätt' ),
	'TranslationStats' => array( 'Översättningsstatistik' ),
	'Translations' => array( 'Översättningar' ),
	'PageMigration' => array( 'Sidmigrering' ),
);

/** Swahili (Kiswahili) */
$specialPageAliases['sw'] = array(
	'Magic' => array( 'TasfiriyaJuu', 'Uchawi' ),
	'Translate' => array( 'Tafsiri' ),
	'TranslationStats' => array( 'TakwimuzaTafsiri' ),
	'Translations' => array( 'Tafsiri' ),
);

/** Telugu (తెలుగు) */
$specialPageAliases['te'] = array(
	'ImportTranslations' => array( 'అనువాదాలదిగుమతి' ),
	'LanguageStats' => array( 'భాషాలెక్కలు' ),
	'PageTranslation' => array( 'పేజిఅనువాదము' ),
	'Translate' => array( 'అనువాదం' ),
	'TranslationStats' => array( 'అనువాదలెక్కలు' ),
	'Translations' => array( 'అనువాదాలు' ),
);

/** Thai (ไทย) */
$specialPageAliases['th'] = array(
	'LanguageStats' => array( 'สถิติภาษา' ),
	'Magic' => array( 'การแปลขั้นสูง' ),
	'MyLanguage' => array( 'ภาษาของฉัน' ),
	'SupportedLanguages' => array( 'ภาษาที่รองรับ' ),
	'Translate' => array( 'แปล' ),
	'TranslationStats' => array( 'สถิติการแปล' ),
	'Translations' => array( 'การแปล' ),
);

/** Tagalog (Tagalog) */
$specialPageAliases['tl'] = array(
	'LanguageStats' => array( 'Mga_estadistika_ng_wika' ),
	'Magic' => array( 'Mas_masulong_na_pagsasalinwika', 'Salamangka' ),
	'Translate' => array( 'Isalinwika' ),
	'TranslationStats' => array( 'Mga_estadistika_ng_salinwika' ),
	'Translations' => array( 'Mga_salinwika' ),
);

/** толышә зывон (толышә зывон) */
$specialPageAliases['tly'] = array(
	'MyLanguage' => array( 'Чымы_зывон' ),
);

/** Turkish (Türkçe) */
$specialPageAliases['tr'] = array(
	'AggregateGroups' => array( 'GruplarıBirleştirme' ),
	'ImportTranslations' => array( 'ÇevirileriİçeAktar' ),
	'LanguageStats' => array( 'Dilİstatistikleri' ),
	'Magic' => array( 'GelişmişÇeviri' ),
	'ManageMessageGroups' => array( 'MesajGruplarınıYönet', 'İletiGruplarınıYönet' ),
	'MessageGroupStats' => array( 'MesajGrubuİstatistikleri', 'İletiGrubuİstatistikleri' ),
	'MyLanguage' => array( 'Dilim', 'BenimDilim' ),
	'PageTranslation' => array( 'SayfaÇevirisi' ),
	'PageTranslationDeletePage' => array( 'SayfaÇevirisiSayfaSilme' ),
	'SupportedLanguages' => array( 'DesteklenenDiller' ),
	'Translate' => array( 'Çevir', 'Çeviri' ),
	'TranslationStats' => array( 'Çeviriİstatistikleri' ),
	'Translations' => array( 'Çeviriler' ),
);

/** Tatar (Cyrillic script) (татарча) */
$specialPageAliases['tt-cyrl'] = array(
	'LanguageStats' => array( 'Телләр_хисабы' ),
	'MyLanguage' => array( 'Телем' ),
	'PageTranslation' => array( 'Битне_тәрҗемә_итү' ),
	'Translate' => array( 'Тәрҗемә' ),
	'TranslationStats' => array( 'Тәрҗемәләр_хисабы' ),
	'Translations' => array( 'Тәрҗемәләр' ),
);

/** Tuvinian (тыва дыл) */
$specialPageAliases['tyv'] = array(
	'MyLanguage' => array( 'Дылым' ),
	'PageTranslation' => array( 'Арын_очулгазы' ),
	'PageTranslationDeletePage' => array( 'Очулдуругда_арынны_казыыр' ),
	'SearchTranslations' => array( 'Очулгалар_дилээр' ),
	'SupportedLanguages' => array( 'Дөгүмнээн_дылдар' ),
	'Translate' => array( 'Очулдурар' ),
	'TranslationStats' => array( 'Очулга_статистиказы' ),
	'Translations' => array( 'Очулгалар' ),
);

/** Ukrainian (українська) */
$specialPageAliases['uk'] = array(
	'AggregateGroups' => array( 'Агреговані_групи' ),
	'ImportTranslations' => array( 'Імпорт_перекладів' ),
	'LanguageStats' => array( 'Статистика_мови' ),
	'Magic' => array( 'Поглиблений_переклад' ),
	'ManageMessageGroups' => array( 'Керування_групами_повідомлень' ),
	'MessageGroupStats' => array( 'Статистика_групи_повідомлень' ),
	'MyLanguage' => array( 'Моя_мова' ),
	'PageTranslation' => array( 'Переклад' ),
	'PageTranslationDeletePage' => array( 'Вилучення_перекладабельної_сторінки' ),
	'SearchTranslations' => array( 'Пошук_перекладів' ),
	'SupportedLanguages' => array( 'Підтримувані_мови' ),
	'Translate' => array( 'Перекласти' ),
	'TranslationStats' => array( 'Статистика_перекладів' ),
	'Translations' => array( 'Переклади' ),
);

/** vèneto (vèneto) */
$specialPageAliases['vec'] = array(
	'Translate' => array( 'Tradusi' ),
	'Translations' => array( 'Tradussioni' ),
);

/** Vietnamese (Tiếng Việt) */
$specialPageAliases['vi'] = array(
	'ImportTranslations' => array( 'Nhập_bản_dịch' ),
	'LanguageStats' => array( 'Thống_kê_ngôn_ngữ' ),
	'Magic' => array( 'Dịch_nâng_cao' ),
	'ManageMessageGroups' => array( 'Quản_lý_nhóm_thông_điệp', 'Quản_lý_nhóm', 'Quản_lí_nhóm_thông_điệp', 'Quản_lí_nhóm' ),
	'ManageTranslatorSandbox' => array( 'Quản_lý_chỗ_thử_biên_dịch', 'Quản_lí_chỗ_thử_biên_dịch' ),
	'MessageGroupStats' => array( 'Thống_kê_nhóm_thông_điệp', 'Thống_kê_nhóm' ),
	'MyLanguage' => array( 'Ngôn_ngữ_tôi' ),
	'PageTranslation' => array( 'Dịch_trang', 'Biên_dịch_trang' ),
	'SearchTranslations' => array( 'Tìm_kiếm_bản_dịch' ),
	'SupportedLanguages' => array( 'Ngôn_ngữ_đuọc_hỗ_trợ' ),
	'Translate' => array( 'Dịch', 'Biên_dịch' ),
	'TranslationStats' => array( 'Thống_kê_biên_dịch' ),
	'Translations' => array( 'Bản_dịch' ),
);

/** Wolof (Wolof) */
$specialPageAliases['wo'] = array(
	'Translate' => array( 'Tekki' ),
);

/** Yiddish (ייִדיש) */
$specialPageAliases['yi'] = array(
	'Translate' => array( 'פֿארטײַטש' ),
);

/** Cantonese (粵語) */
$specialPageAliases['yue'] = array(
	'MyLanguage' => array( '我個話' ),
	'Translate' => array( '譯' ),
);

/** Simplified Chinese (中文（简体）‎) */
$specialPageAliases['zh-hans'] = array(
	'AggregateGroups' => array( '信息组总计' ),
	'ImportTranslations' => array( '导入翻译' ),
	'LanguageStats' => array( '语言统计' ),
	'Magic' => array( '高级翻译' ),
	'ManageMessageGroups' => array( '信息组管理' ),
	'ManageTranslatorSandbox' => array( '管理译者沙盒' ),
	'MessageGroupStats' => array( '信息组状态' ),
	'MyLanguage' => array( '我的语言' ),
	'PageTranslation' => array( '页面翻译' ),
	'PageTranslationDeletePage' => array( '页面翻译删除页面' ),
	'SearchTranslations' => array( '搜索翻译' ),
	'SupportedLanguages' => array( '支持的语言' ),
	'Translate' => array( '翻译' ),
	'TranslationStash' => array( '翻译隐藏' ),
	'TranslationStats' => array( '翻译统计' ),
	'Translations' => array( '译文' ),
	'PageMigration' => array( '页面迁移' ),
	'PagePreparation' => array( '页面预备' ),
);

/** Traditional Chinese (中文（繁體）‎) */
$specialPageAliases['zh-hant'] = array(
	'AggregateGroups' => array( '集合群組' ),
	'ImportTranslations' => array( '匯入翻譯' ),
	'LanguageStats' => array( '語言統計' ),
	'Magic' => array( '進階翻譯' ),
	'ManageMessageGroups' => array( '管理訊息群組' ),
	'ManageTranslatorSandbox' => array( '管理翻譯人員沙盒' ),
	'MessageGroupStats' => array( '訊息群組統計' ),
	'MyLanguage' => array( '我的語言' ),
	'PageTranslation' => array( '頁面翻譯' ),
	'PageTranslationDeletePage' => array( '頁面翻譯刪除頁面' ),
	'SearchTranslations' => array( '搜尋翻譯' ),
	'SupportedLanguages' => array( '支援的語言' ),
	'Translate' => array( '翻譯' ),
	'TranslationStash' => array( '翻譯儲藏庫' ),
	'TranslationStats' => array( '翻譯統計' ),
	'Translations' => array( '翻譯清單' ),
	'PageMigration' => array( '頁面轉移' ),
	'PagePreparation' => array( '頁面準備' ),
);