<?php
/**
 * Aliases for special pages
 *
 * @file
 * @ingroup Extensions
 */
// @codingStandardsIgnoreFile

$specialPageAliases = array();

/** English (English) */
$specialPageAliases['en'] = array(
	'IndexPages' => array( 'IndexPages' ),
	'PagesWithoutScans' => array( 'PagesWithoutScans' ),
	'ProofreadIndexOai' => array( 'ProofreadIndexOai' ),
	'ProofreadIndexOaiSchema' => array( 'ProofreadIndexOaiSchema' ),
);

/** Arabic (العربية) */
$specialPageAliases['ar'] = array(
	'IndexPages' => array( 'صفحات_الفهرس' ),
	'PagesWithoutScans' => array( 'صفحات_بدون_فحص' ),
	'ProofreadIndexOai' => array( 'فهرس_التصحيح_أو_إيه_آي' ),
	'ProofreadIndexOaiSchema' => array( 'سكيما_فهرس_تصحيح_أو_إيه_آي' ),
);

/** Egyptian Spoken Arabic (مصرى) */
$specialPageAliases['arz'] = array(
	'IndexPages' => array( 'صفحات_الفهرس' ),
	'PagesWithoutScans' => array( 'صفحات_من_غير_فحص' ),
	'ProofreadIndexOai' => array( 'فهرس_التصحيح_او_ايه_ىى' ),
	'ProofreadIndexOaiSchema' => array( 'سكيما_فهرس_تصحيح_او_ايه_اى' ),
);

/** Assamese (অসমীয়া) */
$specialPageAliases['as'] = array(
	'IndexPages' => array( 'সমল_পৃষ্ঠাসমূহ' ),
);

/** Breton (brezhoneg) */
$specialPageAliases['br'] = array(
	'IndexPages' => array( 'PajennoùMeneger' ),
);

/** Danish (dansk) */
$specialPageAliases['da'] = array(
	'IndexPages' => array( 'Indekssider' ),
	'PagesWithoutScans' => array( 'Sider_uden_billeder' ),
);

/** German (Deutsch) */
$specialPageAliases['de'] = array(
	'IndexPages' => array( 'Seiten_indexieren' ),
	'PagesWithoutScans' => array( 'Seiten_ohne_Scans' ),
	'ProofreadIndexOai' => array( 'Index_korrekturlesen_OAI' ),
	'ProofreadIndexOaiSchema' => array( 'Index_korrekturlesen_OAI-Schema' ),
);

/** Zazaki (Zazaki) */
$specialPageAliases['diq'] = array(
	'IndexPages' => array( 'Perraİndeks' ),
	'PagesWithoutScans' => array( 'PerréBéCıgeyrayışi' ),
	'ProofreadIndexOai' => array( 'TimarkerdışaİndeksOai' ),
	'ProofreadIndexOaiSchema' => array( 'TimarkerdışaİndeksOaiŞema' ),
);

/** Estonian (eesti) */
$specialPageAliases['et'] = array(
	'IndexPages' => array( 'Registrid' ),
	'PagesWithoutScans' => array( 'Skannimata_tekstid' ),
);

/** Persian (فارسی) */
$specialPageAliases['fa'] = array(
	'IndexPages' => array( 'فهرست_صفحه‌ها' ),
	'PagesWithoutScans' => array( 'صفحه‌های_بدون_پویش‌ها' ),
);

/** Hebrew (עברית) */
$specialPageAliases['he'] = array(
	'IndexPages' => array( 'דפי_מפתח', 'רשימת_דפי_מפתח' ),
	'PagesWithoutScans' => array( 'דפים_ללא_סריקות' ),
);

/** Haitian (Kreyòl ayisyen) */
$specialPageAliases['ht'] = array(
	'IndexPages' => array( 'PajEndèks' ),
);

/** Interlingua (interlingua) */
$specialPageAliases['ia'] = array(
	'IndexPages' => array( 'Paginas_de_indice' ),
	'PagesWithoutScans' => array( 'Paginas_non_transcludite' ),
);

/** Italian (italiano) */
$specialPageAliases['it'] = array(
	'IndexPages' => array( 'PagineIndice' ),
	'PagesWithoutScans' => array( 'PagineSenzaScansioni' ),
);

/** Japanese (日本語) */
$specialPageAliases['ja'] = array(
	'IndexPages' => array( '索引ページ' ),
	'PagesWithoutScans' => array( 'スキャンのないページ' ),
);

/** Korean (한국어) */
$specialPageAliases['ko'] = array(
	'IndexPages' => array( '색인문서' ),
	'PagesWithoutScans' => array( '스캔안된문서', '스캔안한문서' ),
	'ProofreadIndexOai' => array( '색인교정Oai' ),
	'ProofreadIndexOaiSchema' => array( '색인교정Oai스키마' ),
);

/** Luxembourgish (Lëtzebuergesch) */
$specialPageAliases['lb'] = array(
	'IndexPages' => array( 'Säiten_indexéieren' ),
	'PagesWithoutScans' => array( 'Säiten_ouni_Scan' ),
);

/** Macedonian (македонски) */
$specialPageAliases['mk'] = array(
	'IndexPages' => array( 'ИндексираниСтраници' ),
	'PagesWithoutScans' => array( 'СтранициБезПроверки' ),
	'ProofreadIndexOai' => array( 'ИндексПроверениOai' ),
	'ProofreadIndexOaiSchema' => array( 'ИндексПроверениOaiШема' ),
);

/** Malayalam (മലയാളം) */
$specialPageAliases['ml'] = array(
	'IndexPages' => array( 'സൂചികാതാളുകൾ' ),
	'PagesWithoutScans' => array( 'സ്കാൻലഭ്യമല്ലാത്തതാളുകൾ' ),
);

/** Norwegian Bokmål (norsk bokmål) */
$specialPageAliases['nb'] = array(
	'IndexPages' => array( 'Indekssider' ),
	'PagesWithoutScans' => array( 'Sider_uten_skanninger' ),
);

/** Low Saxon (Netherlands) (Nedersaksies) */
$specialPageAliases['nds-nl'] = array(
	'IndexPages' => array( 'Indexziejen' ),
	'PagesWithoutScans' => array( 'Ziejen_zonder_deurlochting' ),
);

/** Dutch (Nederlands) */
$specialPageAliases['nl'] = array(
	'IndexPages' => array( 'Indexpaginas', 'Indexpagina\'s' ),
	'PagesWithoutScans' => array( 'PaginasZonderScans', 'Pagina\'sZonderScans' ),
);

/** Portuguese (português) */
$specialPageAliases['pt'] = array(
	'IndexPages' => array( 'Páginas_índice' ),
	'PagesWithoutScans' => array( 'Páginas_sem_digitalizações' ),
);

/** Sicilian (sicilianu) */
$specialPageAliases['scn'] = array(
	'IndexPages' => array( 'PagineIndicizzate' ),
	'PagesWithoutScans' => array( 'PagineSenzaScansioni' ),
);

/** Swedish (svenska) */
$specialPageAliases['sv'] = array(
	'IndexPages' => array( 'Indexsidor' ),
);

/** Turkish (Türkçe) */
$specialPageAliases['tr'] = array(
	'IndexPages' => array( 'SayfaEndeksle' ),
	'PagesWithoutScans' => array( 'TaramasızSayfalar' ),
);

/** vèneto (vèneto) */
$specialPageAliases['vec'] = array(
	'IndexPages' => array( 'PagineDeIndice' ),
	'PagesWithoutScans' => array( 'PagineSensaScansion' ),
);

/** Vietnamese (Tiếng Việt) */
$specialPageAliases['vi'] = array(
	'IndexPages' => array( 'Trang_mục_lục' ),
	'PagesWithoutScans' => array( 'Trang_không_có_hình_quét' ),
);

/** Simplified Chinese (中文（简体）‎) */
$specialPageAliases['zh-hans'] = array(
	'IndexPages' => array( '索引页面' ),
	'PagesWithoutScans' => array( '未扫描页面' ),
	'ProofreadIndexOai' => array( '校对索引OAI' ),
	'ProofreadIndexOaiSchema' => array( '校对索引OAI图表' ),
);

/** Traditional Chinese (中文（繁體）‎) */
$specialPageAliases['zh-hant'] = array(
	'IndexPages' => array( '索引頁面' ),
	'PagesWithoutScans' => array( '未掃描頁面' ),
);