<?php
/**
 * Aliases for MobileFrontend extension
 *
 * @file
 * @ingroup Extensions
 */
// @codingStandardsIgnoreFile

$specialPageAliases = array();

/** English (English) */
$specialPageAliases['en'] = array(
	'History' => array( 'History' ),
	'MobileWebApp' => array( 'MobileWebApp' ),
	'MobileOptions' => array( 'MobileOptions' ),
	'Uploads' => array( 'Uploads' ),
	'MobileDiff' => array( 'MobileDiff' ),
	'MobileEditor' => array( 'MobileEditor' ),
	'MobileMenu' => array( 'MobileMenu' ),
	'MobileLanguages' => array( 'MobileLanguages' ),
	'Nearby' => array( 'Nearby' ),
	'UserProfile' => array( 'UserProfile' ),
);

/** Afrikaans (Afrikaans) */
$specialPageAliases['af'] = array(
	'History' => array( 'Geskiedenis' ),
	'Uploads' => array( 'Oplaaie' ),
	'Nearby' => array( 'Naby' ),
);

/** Arabic (العربية) */
$specialPageAliases['ar'] = array(
	'History' => array( 'تاريخ' ),
	'MobileWebApp' => array( 'تطبيق_ويب_المحمول' ),
	'MobileOptions' => array( 'خيارات_المحمول' ),
	'Uploads' => array( 'مرفوعات' ),
	'MobileDiff' => array( 'فرق_المحمول' ),
	'MobileEditor' => array( 'محرر_المحمول' ),
	'MobileMenu' => array( 'قائمة_المحمول' ),
	'MobileLanguages' => array( 'لغات_المحمول' ),
	'Nearby' => array( 'قريب' ),
	'UserProfile' => array( 'ملف_المستخدم' ),
);

/** Egyptian Spoken Arabic (مصرى) */
$specialPageAliases['arz'] = array(
	'History' => array( 'تاريخ' ),
	'MobileWebApp' => array( 'تطبيق_ويب_الموبايل' ),
	'MobileOptions' => array( 'خيارات_الموبايل' ),
	'Uploads' => array( 'مرفوعات' ),
	'MobileDiff' => array( 'فرق_الموبايل' ),
	'MobileEditor' => array( 'محرر_الموبايل' ),
	'MobileMenu' => array( 'قايمه_الموبايل' ),
	'MobileLanguages' => array( 'لغات_الموبايل' ),
	'Nearby' => array( 'قريب' ),
	'UserProfile' => array( 'بروفايل_اليوزر' ),
);

/** Asturian (asturianu) */
$specialPageAliases['ast'] = array(
	'Nearby' => array( 'Cercano' ),
);

/** Catalan (català) */
$specialPageAliases['ca'] = array(
	'Nearby' => array( 'A_prop' ),
);

/** Chechen (нохчийн) */
$specialPageAliases['ce'] = array(
	'MobileOptions' => array( 'Мобильни_верси_нисяр' ),
	'Uploads' => array( 'Чуйохурш' ),
	'MobileDiff' => array( 'Версеш_муха_ю_хьажар' ),
	'MobileMenu' => array( 'Мобильни_меню' ),
	'Nearby' => array( 'Гергахьо' ),
);

/** German (Deutsch) */
$specialPageAliases['de'] = array(
	'History' => array( 'Versionsgeschichte' ),
	'MobileWebApp' => array( 'Mobile_Webanwendung' ),
	'MobileOptions' => array( 'Mobile_Optionen' ),
	'Uploads' => array( 'Hochgeladene_Dateien' ),
	'MobileDiff' => array( 'Mobiler_Unterschied' ),
	'MobileEditor' => array( 'Mobiler_Editor' ),
	'MobileMenu' => array( 'Mobiles_Menü' ),
	'MobileLanguages' => array( 'Mobile_Sprachen' ),
	'Nearby' => array( 'In_der_Nähe' ),
	'UserProfile' => array( 'Benutzerprofil' ),
);

/** Zazaki (Zazaki) */
$specialPageAliases['diq'] = array(
	'History' => array( 'Tarix' ),
	'MobileWebApp' => array( 'MobilWebDezge' ),
	'MobileOptions' => array( 'MobilWeçenegi' ),
	'Uploads' => array( 'Barkerdışi' ),
	'MobileDiff' => array( 'MobilVer' ),
	'MobileEditor' => array( 'MobilVurnayoğ' ),
	'MobileMenu' => array( 'MıobilMenu' ),
	'MobileLanguages' => array( 'MobilZıwani' ),
	'Nearby' => array( 'Nezdıra' ),
	'UserProfile' => array( 'ProfilaKarberi' ),
);

/** Esperanto (Esperanto) */
$specialPageAliases['eo'] = array(
	'MobileOptions' => array( 'Opcioj_pri_poŝaparato' ),
	'Uploads' => array( 'Alŝutoj' ),
	'MobileMenu' => array( 'Menuo_por_poŝaparato' ),
	'Nearby' => array( 'Apude' ),
);

/** Spanish (español) */
$specialPageAliases['es'] = array(
	'Uploads' => array( 'Subidas' ),
	'Nearby' => array( 'Cerca' ),
	'UserProfile' => array( 'Perfil_de_usuario', 'Perfil_de_usuaria' ),
);

/** Estonian (eesti) */
$specialPageAliases['et'] = array(
	'History' => array( 'Ajalugu' ),
	'MobileOptions' => array( 'Mobiili_suvandid' ),
	'Uploads' => array( 'Üleslaaditud_failid' ),
	'MobileDiff' => array( 'Mobiilierinevus' ),
	'MobileEditor' => array( 'Mobiiliredaktor' ),
	'MobileMenu' => array( 'Mobiili_menüü' ),
	'MobileLanguages' => array( 'Mobiilikeeled' ),
	'Nearby' => array( 'Lähikond' ),
	'UserProfile' => array( 'Kasutaja_profiil' ),
);

/** Persian (فارسی) */
$specialPageAliases['fa'] = array(
	'History' => array( 'تاریخچه' ),
	'MobileWebApp' => array( 'برنامه_وبی_گوشی_همراه' ),
	'MobileOptions' => array( 'گزینه‌های_گوشی_همراه' ),
	'Uploads' => array( 'بارگذاری‌ها' ),
	'MobileDiff' => array( 'تفاوت_گوشی_همراه' ),
	'MobileEditor' => array( 'ویرایشگر_گوشی_همراه' ),
	'MobileMenu' => array( 'گزینگان_گوشی_همراه' ),
	'MobileLanguages' => array( 'زبان‌های_گوشی_همراه' ),
	'Nearby' => array( 'درنزدیکی', 'در_نزدیکی' ),
	'UserProfile' => array( 'شناسنامهٔ_کاربری', 'شناسنامه_کاربری' ),
);

/** Galician (galego) */
$specialPageAliases['gl'] = array(
	'Uploads' => array( 'Subidas', 'Cargas' ),
	'Nearby' => array( 'Preto', 'Cerca' ),
	'UserProfile' => array( 'Perfil_de_usuario', 'Perfil_de_usuaria' ),
);

/** Hebrew (עברית) */
$specialPageAliases['he'] = array(
	'History' => array( 'היסטוריה' ),
	'MobileWebApp' => array( 'יישום_וב_נייד' ),
	'MobileOptions' => array( 'הגדרות_נייד', 'הגדרות_פלאפון', 'הגדרות_סלולרי' ),
	'Uploads' => array( 'העלאות' ),
	'MobileDiff' => array( 'השוואה_ניידת' ),
	'MobileEditor' => array( 'עריכה_ניידת' ),
	'MobileMenu' => array( 'תפריט_נייד' ),
	'MobileLanguages' => array( 'שפות_בנייד' ),
	'Nearby' => array( 'בסביבה', 'קרוב' ),
	'UserProfile' => array( 'פרופיל_משתמש' ),
);

/** Hindi (हिन्दी) */
$specialPageAliases['hi'] = array(
	'MobileOptions' => array( 'मोबाइल_विकल्प' ),
);

/** Upper Sorbian (hornjoserbsce) */
$specialPageAliases['hsb'] = array(
	'History' => array( 'Stawizny' ),
	'MobileWebApp' => array( 'Mobilne_webnałoženje' ),
	'MobileOptions' => array( 'Mobilne_opcije' ),
	'Uploads' => array( 'Nahrate_dataje' ),
	'MobileDiff' => array( 'Mobilny_rozdźěl' ),
	'MobileEditor' => array( 'Mobilny_editor' ),
	'MobileMenu' => array( 'Mobilny_meni' ),
	'MobileLanguages' => array( 'Mobilne_rěče' ),
	'Nearby' => array( 'W_bliskosći' ),
	'UserProfile' => array( 'Wužiwarski_profil' ),
);

/** Italian (italiano) */
$specialPageAliases['it'] = array(
	'History' => array( 'Cronologia' ),
	'MobileOptions' => array( 'OpzioniMobile' ),
	'Uploads' => array( 'Caricamenti' ),
	'MobileDiff' => array( 'DiffMobile' ),
	'MobileEditor' => array( 'EditorMobile' ),
	'MobileMenu' => array( 'MenuMobile' ),
	'MobileLanguages' => array( 'LingueMobile' ),
	'Nearby' => array( 'NelleVicinanze' ),
	'UserProfile' => array( 'ProfiloUtente' ),
);

/** Japanese (日本語) */
$specialPageAliases['ja'] = array(
	'History' => array( '履歴' ),
	'MobileOptions' => array( '携帯機器オプション' ),
	'Uploads' => array( '携帯機器アップロード' ),
	'MobileDiff' => array( '携帯機器差分' ),
	'MobileEditor' => array( '携帯機器編集' ),
	'MobileMenu' => array( '携帯機器メニュー' ),
	'MobileLanguages' => array( '携帯機器言語', '言語' ),
	'Nearby' => array( '付近' ),
	'UserProfile' => array( '利用者プロフィール' ),
);

/** Korean (한국어) */
$specialPageAliases['ko'] = array(
	'History' => array( '역사' ),
	'MobileWebApp' => array( '모바일웹앱' ),
	'MobileOptions' => array( '모바일설정' ),
	'Uploads' => array( '올린파일' ),
	'MobileDiff' => array( '모바일차이' ),
	'MobileEditor' => array( '모바일편집기' ),
	'MobileMenu' => array( '모바일메뉴' ),
	'MobileLanguages' => array( '모바일언어' ),
	'Nearby' => array( '근처' ),
	'UserProfile' => array( '사용자프로필' ),
);

/** Luxembourgish (Lëtzebuergesch) */
$specialPageAliases['lb'] = array(
	'History' => array( 'Versiounen' ),
	'MobileWebApp' => array( 'Mobil_Webapplikatioun' ),
	'MobileOptions' => array( 'Mobil_Optiounen' ),
	'Uploads' => array( 'Eropgeluede_Fichieren' ),
	'MobileDiff' => array( 'Mobilen_Ënnerscheed' ),
	'MobileEditor' => array( 'Mobilen_Editeur' ),
	'MobileMenu' => array( 'Mobile_Menü' ),
	'MobileLanguages' => array( 'Mobil_Sproochen' ),
	'Nearby' => array( 'Nobäi' ),
	'UserProfile' => array( 'Benotzerprofil' ),
);

/** Literary Chinese (文言) */
$specialPageAliases['lzh'] = array(
	'Nearby' => array( '近郊' ),
);

/** Macedonian (македонски) */
$specialPageAliases['mk'] = array(
	'History' => array( 'Историја' ),
	'MobileWebApp' => array( 'МобиленСемреженПрилог' ),
	'MobileOptions' => array( 'МобилниПоставки' ),
	'Uploads' => array( 'Подигања' ),
	'MobileDiff' => array( 'МобилнаРазлика' ),
	'MobileEditor' => array( 'МобиленУредувач' ),
	'MobileMenu' => array( 'МобилноМени' ),
	'MobileLanguages' => array( 'МобилниЈазици' ),
	'Nearby' => array( 'ВоБлизина' ),
	'UserProfile' => array( 'КорисничкиПрофил' ),
);

/** Malayalam (മലയാളം) */
$specialPageAliases['ml'] = array(
	'History' => array( 'ഹിസ്റ്ററി' ),
	'MobileWebApp' => array( 'മൊബൈൽവെബ്ആപ്' ),
	'MobileOptions' => array( 'മൊബൈൽഐച്ഛികങ്ങൾ' ),
	'Uploads' => array( 'അപ്‌ലോഡുകൾ' ),
	'MobileDiff' => array( 'മൊബൈൽവ്യത്യാസം' ),
	'MobileEditor' => array( 'മൊബൈൽതിരുത്തൽ' ),
	'MobileMenu' => array( 'മൊബൈൽമെനു' ),
	'MobileLanguages' => array( 'മൊബൈൽഭാഷകൾ' ),
	'Nearby' => array( 'സമീപസ്ഥം' ),
	'UserProfile' => array( 'ഉപയോക്തൃവിവരങ്ങൾ' ),
);

/** Marathi (मराठी) */
$specialPageAliases['mr'] = array(
	'History' => array( 'इतिहास' ),
);

/** Min Nan Chinese (Bân-lâm-gú) */
$specialPageAliases['nan'] = array(
	'Uploads' => array( 'Kā--ê_tóng-àn' ),
);

/** Dutch (Nederlands) */
$specialPageAliases['nl'] = array(
	'History' => array( 'Geschiedenis' ),
	'MobileOptions' => array( 'MobieleVoorkeuren' ),
	'MobileDiff' => array( 'MobielVerschillen' ),
	'MobileEditor' => array( 'MobielBewerken' ),
	'MobileMenu' => array( 'MobielMenu' ),
	'MobileLanguages' => array( 'MobielTalen' ),
	'Nearby' => array( 'InDeBuurt' ),
	'UserProfile' => array( 'Gebruikersprofiel' ),
);

/** Norwegian Nynorsk (norsk nynorsk) */
$specialPageAliases['nn'] = array(
	'MobileOptions' => array( 'Mobilval' ),
	'Uploads' => array( 'Opplastingar' ),
	'Nearby' => array( 'Nær_her' ),
);

/** Polish (polski) */
$specialPageAliases['pl'] = array(
	'History' => array( 'Historia' ),
	'Nearby' => array( 'W_pobliżu' ),
);

/** Russian (русский) */
$specialPageAliases['ru'] = array(
	'MobileOptions' => array( 'Настройки_мобильной_версии' ),
	'Uploads' => array( 'Загрузки' ),
	'MobileDiff' => array( 'Сравнение_версий' ),
	'MobileMenu' => array( 'Мобильное_меню' ),
	'Nearby' => array( 'Поблизости' ),
);

/** Sicilian (sicilianu) */
$specialPageAliases['scn'] = array(
	'MobileOptions' => array( 'OpzioniMobile' ),
);

/** Serbian (Cyrillic script) (српски (ћирилица)‎) */
$specialPageAliases['sr-ec'] = array(
	'History' => array( 'Историја' ),
	'MobileOptions' => array( 'МобилнаПодешавања' ),
	'Uploads' => array( 'Отпремања' ),
	'MobileMenu' => array( 'МобилниМени' ),
	'UserProfile' => array( 'КорисничкиПрофил' ),
);

/** Swedish (svenska) */
$specialPageAliases['sv'] = array(
	'Nearby' => array( 'Nära' ),
);

/** Ukrainian (українська) */
$specialPageAliases['uk'] = array(
	'History' => array( 'Історія' ),
	'MobileOptions' => array( 'Налаштування_мобільної_версії' ),
	'Uploads' => array( 'Мобільне_Завантаження' ),
	'MobileDiff' => array( 'Мобільна_різниця_версій' ),
	'MobileMenu' => array( 'Мобільне_меню' ),
	'Nearby' => array( 'Поблизу' ),
	'UserProfile' => array( 'Профіль_користувача' ),
);

/** Vietnamese (Tiếng Việt) */
$specialPageAliases['vi'] = array(
	'History' => array( 'Lịch_sử' ),
	'MobileWebApp' => array( 'Ứng_dụng_Web_di_động', 'Ứng_dụng_di_động_Web' ),
	'MobileOptions' => array( 'Tùy_chọn_di_động' ),
	'Uploads' => array( 'Tập_tin_tải_lên' ),
	'MobileDiff' => array( 'So_sánh_di_động' ),
	'MobileEditor' => array( 'Sửa_đổi_di_động' ),
	'MobileMenu' => array( 'Trình_đơn_di_động' ),
	'MobileLanguages' => array( 'Ngôn_ngữ_di_động' ),
	'Nearby' => array( 'Kề_bên' ),
	'UserProfile' => array( 'Hồ_sơ_cá_nhân' ),
);

/** Simplified Chinese (中文（简体）‎) */
$specialPageAliases['zh-hans'] = array(
	'History' => array( '历史' ),
	'MobileWebApp' => array( '移动网页App' ),
	'MobileOptions' => array( '移动版选项' ),
	'Uploads' => array( '上传' ),
	'MobileDiff' => array( '移动版差异' ),
	'MobileEditor' => array( '移动版编辑器' ),
	'MobileMenu' => array( '移动版菜单' ),
	'MobileLanguages' => array( '移动版语言' ),
	'Nearby' => array( '附近' ),
	'UserProfile' => array( '用户资料' ),
);

/** Traditional Chinese (中文（繁體）‎) */
$specialPageAliases['zh-hant'] = array(
	'History' => array( '歷史' ),
	'MobileWebApp' => array( '行動網頁App' ),
	'MobileOptions' => array( '行動版選項' ),
	'Uploads' => array( '上載' ),
	'MobileDiff' => array( '行動版差異' ),
	'MobileEditor' => array( '行動版編輯器' ),
	'MobileMenu' => array( '行動版選單' ),
	'MobileLanguages' => array( '行動版語言' ),
	'Nearby' => array( '附近' ),
	'UserProfile' => array( '使用者資訊' ),
);

/** Chinese (Hong Kong) (中文（香港）‎) */
$specialPageAliases['zh-hk'] = array(
	'MobileWebApp' => array( '流動網頁App' ),
);