<?php
/**
 * Aliases for special pages of the Disambiguator extension
 *
 * @file
 * @ingroup Extensions
 */
// @codingStandardsIgnoreFile

$specialPageAliases = array();

/** English (English) */
$specialPageAliases['en'] = array(
	'DisambiguationPages' => array( 'DisambiguationPages' ),
	'DisambiguationPageLinks' => array( 'DisambiguationPageLinks' ),
);

/** Arabic (العربية) */
$specialPageAliases['ar'] = array(
	'DisambiguationPages' => array( 'صفحات_توضيح' ),
	'DisambiguationPageLinks' => array( 'وصلات_صفحات_توضيح' ),
);

/** Egyptian Spoken Arabic (مصرى) */
$specialPageAliases['arz'] = array(
	'DisambiguationPages' => array( 'صفحات_توضيح' ),
	'DisambiguationPageLinks' => array( 'وصلات_صفحات_توضيح' ),
);

/** Min Dong Chinese (Mìng-dĕ̤ng-ngṳ̄) */
$specialPageAliases['cdo'] = array(
	'DisambiguationPages' => array( '消除歧義頁面' ),
	'DisambiguationPageLinks' => array( '消除歧義頁面鏈接' ),
);

/** German (Deutsch) */
$specialPageAliases['de'] = array(
	'DisambiguationPages' => array( 'Begriffsklärungsseiten' ),
	'DisambiguationPageLinks' => array( 'Begriffsklärungslinks' ),
);

/** Zazaki (Zazaki) */
$specialPageAliases['diq'] = array(
	'DisambiguationPages' => array( 'PerréManedébini' ),
	'DisambiguationPageLinks' => array( 'GreyéPerréManedébini' ),
);

/** Estonian (eesti) */
$specialPageAliases['et'] = array(
	'DisambiguationPages' => array( 'Täpsustusleheküljed' ),
	'DisambiguationPageLinks' => array( 'Lingid_täpsustusleheküljele' ),
);

/** Persian (فارسی) */
$specialPageAliases['fa'] = array(
	'DisambiguationPages' => array( 'صفحات_ابهام‌زدایی' ),
	'DisambiguationPageLinks' => array( 'پیوندهای_صفحات_ابهام‌زدایی' ),
);

/** Galician (galego) */
$specialPageAliases['gl'] = array(
	'DisambiguationPages' => array( 'Páxinas_de_homónimos' ),
	'DisambiguationPageLinks' => array( 'Ligazóns_cara_a_páxinas_de_homónimos' ),
);

/** Hebrew (עברית) */
$specialPageAliases['he'] = array(
	'DisambiguationPages' => array( 'דפי_פירושונים' ),
	'DisambiguationPageLinks' => array( 'דפים_המקשרים_לדפי_פירושונים' ),
);

/** Italian (italiano) */
$specialPageAliases['it'] = array(
	'DisambiguationPages' => array( 'PagineDisambiguazione' ),
	'DisambiguationPageLinks' => array( 'CollegamentiPagineDisambiguazione' ),
);

/** Japanese (日本語) */
$specialPageAliases['ja'] = array(
	'DisambiguationPages' => array( '曖昧さ回避ページ' ),
	'DisambiguationPageLinks' => array( '曖昧さ回避ページリンク' ),
);

/** Korean (한국어) */
$specialPageAliases['ko'] = array(
	'DisambiguationPages' => array( '동음이의어문서' ),
	'DisambiguationPageLinks' => array( '동음이의어문서링크' ),
);

/** Luxembourgish (Lëtzebuergesch) */
$specialPageAliases['lb'] = array(
	'DisambiguationPages' => array( 'Homonymie-Säiten' ),
	'DisambiguationPageLinks' => array( 'HomonymieSäitLinken' ),
);

/** Minangkabau (Baso Minangkabau) */
$specialPageAliases['min'] = array(
	'DisambiguationPages' => array( 'LamanDisambiguasi' ),
	'DisambiguationPageLinks' => array( 'PautanLamanDisambiguasi' ),
);

/** Macedonian (македонски) */
$specialPageAliases['mk'] = array(
	'DisambiguationPages' => array( 'ПојаснителниСтраници' ),
	'DisambiguationPageLinks' => array( 'ВрскиДоПојаснување' ),
);

/** Malayalam (മലയാളം) */
$specialPageAliases['ml'] = array(
	'DisambiguationPages' => array( 'വിവക്ഷിതതാളുകൾ' ),
	'DisambiguationPageLinks' => array( 'വിവക്ഷിതതാളുകളുടെകണ്ണികൾ' ),
);

/** Low Saxon (Netherlands) (Nedersaksies) */
$specialPageAliases['nds-nl'] = array(
	'DisambiguationPages' => array( 'Deurverwiesziejen' ),
	'DisambiguationPageLinks' => array( 'Deurverwieskoppelingen' ),
);

/** Dutch (Nederlands) */
$specialPageAliases['nl'] = array(
	'DisambiguationPages' => array( 'Doorverwijspaginas', 'Doorverwijspagina\'s' ),
	'DisambiguationPageLinks' => array( 'Doorverwijspaginakoppelingen' ),
);

/** Polish (polski) */
$specialPageAliases['pl'] = array(
	'DisambiguationPages' => array( 'Strony_ujednoznaczniające' ),
);

/** Portuguese (português) */
$specialPageAliases['pt'] = array(
	'DisambiguationPages' => array( 'Páginas_de_desambiguação' ),
	'DisambiguationPageLinks' => array( 'Links_para_páginas_de_desambiguação' ),
);

/** Swedish (svenska) */
$specialPageAliases['sv'] = array(
	'DisambiguationPages' => array( 'Förgreningssidor' ),
	'DisambiguationPageLinks' => array( 'Sidor_som_länkar_till_förgreningssidor' ),
);

/** Ukrainian (українська) */
$specialPageAliases['uk'] = array(
	'DisambiguationPages' => array( 'Сторінки_тлумачення_неоднозначності' ),
	'DisambiguationPageLinks' => array( 'Посилання_на_сторінки_тлумачення_неоднозначності' ),
);

/** vèneto (vèneto) */
$specialPageAliases['vec'] = array(
	'DisambiguationPages' => array( 'PagineDeDisambigua' ),
	'DisambiguationPageLinks' => array( 'PagineChePontaAPagineDeDisambigua' ),
);

/** Vietnamese (Tiếng Việt) */
$specialPageAliases['vi'] = array(
	'DisambiguationPages' => array( 'Trang_định_hướng' ),
	'DisambiguationPageLinks' => array( 'Liên_kết_đến_trang_định_hướng' ),
);

/** Simplified Chinese (中文（简体）‎) */
$specialPageAliases['zh-hans'] = array(
	'DisambiguationPages' => array( '消歧义页面' ),
	'DisambiguationPageLinks' => array( '链接到消歧义页的页面' ),
);

/** Traditional Chinese (中文（繁體）‎) */
$specialPageAliases['zh-hant'] = array(
	'DisambiguationPages' => array( '消歧義頁面' ),
	'DisambiguationPageLinks' => array( '消歧義頁面連結' ),
);