import fileinput as fi
import os.path as path
import gzip
import io
import sys
import cidr
import test

def hook_compressed(filename, mode):
    ext = path.splitext(filename)[1]
    if ext == '.gz':
        return io.TextIOWrapper(gzip.open(filename, 'r'), sys.getdefaultencoding())
    else:
        return open(filename, mode)

def get(vals, value):
    return vals[value].replace('\t',' ').strip() if value in vals else ''

cidrs = set()
ips = set()
partial = False
confs = test.getAllConfigs(test.META)
skipped = 0
total = 0
for line in fi.input(openhook = fi.hook_compressed):
    l = line.strip()
    if partial:
        if l == ')':
            total += 1
            ref = get(vals, 'REFERER')
            ua = get(vals, 'USER-AGENT')
            xff = [s.strip(' ') for s in get(vals, 'X-FORWARDED-FOR').split(',')]
            ip = xff[0]
            if len(xff) != 2:
                print("*** %s" % xff)
            if ref == '':
                # print('%s has no referer' % ip)
                skipped += 1
                continue
            if ip not in ips:
                ips.add(ip)
                res = cidr.findIp(confs, ip)
                opera = '(Opera Mini) ' if 'Opera Mini' in ua else ''
                if len(res) > 1:
                    print('%s found in %d ranges %s' % (ip, len(res), opera))
                    for r in res:
                        print('   %s / %s - %d' % (r[0], r[1], r[2]))
                elif len(res) == 1:
                    r = res[0]
                    print('%s %sfound in %s / %s - %d' % (ip, opera, r[0], r[1], r[2]))
                    if r[2] > 0 and r[2] < 3:
                        cidrs.add("%s - %d" % (r[0], r[2]))
                else:
                    skipped += 1
                    # print('%s %snot found' % (ip, opera))
            partial = False
            continue
        parts = line.split(' => ', 1)
        if len(parts) > 1:
            vals[parts[0].strip(' []')] = parts[1]
    else:
        vals = {}
        partial = True

print('\n\nSkipped %d out of %d' % (skipped, total))
print('CIDRs:')
print('\n'.join(cidrs))
