#! /bin/sh

export PATH=/bin:$PATH
rm caps/*
rm unified-caps/*
rm status
rm report.zip
curl https://zero.wikimedia.org/
echo "AUTOMATED TESTS STARTED"
casperjs zero_automated_tests.js --username=zerobdd --passwordfile=pw > 000log.txt 2>&1
echo "AUTOMATED TESTS FINISHED"
zip report.zip 000log.txt caps/* unified-caps/*
A=`date --rfc-3339=seconds`
CASPERSTATUS=`cat status`
EMAILMINOR=`cat emailminor`
EMAILTECH=`cat emailtech`
EMAILMAJOR=`cat emailmajor`
echo "Status: $CASPERSTATUS"
if [ $CASPERSTATUS = "okay" -a $1 = "minor" ]
then
	echo "Emailing okay minor"
	echo "W0 Banner Status: $CASPERSTATUS" | mailx -s "W0 Status Report $CASPERSTATUS for $A" $EMAILMINOR
elif [ $CASPERSTATUS = "UNKNOWN" -a $1 = "minor" ]
then
	echo "Emailing UNKNOWN minor"
	echo "W0 Banner Status: $CASPERSTATUS" | mailx -s "W0 Status Report $CASPERSTATUS for $A" $EMAILMINOR
elif [ $CASPERSTATUS = "okay" -a $1 = "tech" ]
then
	echo "Emailing okay tech"
	echo "W0 Banner Status: $CASPERSTATUS" | mailx -s "W0 Status Report $CASPERSTATUS for $A" $EMAILTECH
elif [ $CASPERSTATUS = "UNKNOWN" -a $1 = "tech" ]
then
	echo "Emailing UKNOWN tech"
	echo "W0 Banner Status: $CASPERSTATUS" | mailx -s "W0 Status Report $CASPERSTATUS for $A" $EMAILTECH
else
	echo "Emailing major"
	echo "WO Banner Status: $CASPERSTATUS - see attached for more." | mailx -s "W0 Status Report $CASPERSTATUS for $A" -a report.zip $EMAILMAJOR
fi
echo "DONE"