<?php

namespace ZeroPortal;

use FormatJson;
use UnlistedSpecialPage;
use ZeroBanner\ZeroConfig;

/**
 * Default startup page for ZeroPortal extension that shows the list of available languages.
 *
 * @file
 * @ingroup Extensions
 */
class PortalSpecialPage extends UnlistedSpecialPage {

	/**
	 * Constructor — set up the SpecialPage:PortalSpecialPage page
	 */
	public function __construct() {
		parent::__construct( 'ZeroPortal' );
	}

	/**
	 * Show the special page
	 *
	 * @param null|string $par parameter passed to the special page or null
	 */
	public function execute( $par ) {
		$out = $this->getOutput();

//		$out->addModules( 'zeroportal.special.scripts' );
//		$out->addModuleStyles( 'zeroportal.special.styles' );

		$user = $this->getUser();
		if ( !$user->isAnon() ) {
			// Include all zero-config ids if this is an admin
			$name = !$user->isAllowed( 'zero-edit' ) ? $user->getName() : true;
			$configs = array();
			ApiZeroPortal::iterateAllConfigs( false, function ( ZeroConfig $content, $title ) use ( $name, &$configs ) {
				if ( $name === true || in_array( $name, $content->admins() ) ) {
					$configs[] = $title;
				}
				return false;
			} );
			if ( !$configs ) {
				$configs = 'unlisted';
			}
		} else {
			$configs = 'anonymous';
		}
		$configs = self::encodeParameter( $configs );
		$state = self::encodeParameter( $this->getRequest()->getVal( 's' ) );
		$user = self::encodeParameter( $user->isAnon() ? false : $user->getName() );
		$out->addWikiText( "{{#invoke:Portal|main|$configs|$state|$user}}" );

		if ( $this->getRequest()->getCheck( 'raw' ) ) {
			// Output
			$text = html_entity_decode( $out->getHTML(), ENT_QUOTES | ENT_HTML5 );

			// Removing module invocation result wrapping:  <p>...\n</p>
			$prefix = "<p>";
			$suffix = "\n</p>";
			$prefixLen = strlen( $prefix );
			$suffixLen = strlen( $suffix );
			if ( $prefix === substr( $text, 0, $prefixLen ) &&
			     $suffix === substr( $text, - $suffixLen )
			) {
				$text = substr( $text, $prefixLen, - $suffixLen );
			}

			$out->disable();
			$req = $this->getRequest();
			$resp = $req->response();
			$resp->header( 'Content-Type: text/plain; charset=UTF-8' );
			$resp->header( 'Expires: ' . gmdate( 'D, d M Y H:i:s', 0 ) . ' GMT' );
			$resp->header( "Cache-Control: private, must-revalidate, max-age=0" );
			echo $text;
		}
//		$article = new \WikiPage( Title::newFromText( $title ) );
//		if ( $article->exists() ) {
//			$content = $article->getRevision()->getContent();
//			$out->addWikiText( $content->getNativeData() );
//		} else {
//			$out->addHTML( '<h1>Article ' . htmlspecialchars( $article->getTitle() ) . ' does not exist</h1>' );
//		}
	}

	private static function encodeParameter( $value ) {
		return str_replace( '|', '&#124;', htmlspecialchars( FormatJson::encode( $value ) ) );
	}
}
