<?php

namespace ZeroBanner;

use ApiBase;
use EventLogging;

/**
 * Logs MCC-MNC conveyed by apps.
 * http://lists.wikimedia.org/pipermail/wikimedia-l/2014-April/071131.html
 */
class MccMncLogging {

	/**
	 * APIAfterExecute hook handler. Logs MCC-MNC code to its own EventLogging store.
	 * @see: https://www.mediawiki.org/wiki/Manual:Hooks
	 * @param ApiBase $module
	 * @return bool
	 */
	public static function onAPIAfterExecute( ApiBase &$module ) {
		if ( is_callable( 'EventLogging::logEvent' ) ) {
			wfProfileIn( __METHOD__ );
			$req = $module->getRequest();
			$mccMnc = $req->getHeader( 'X-MCCMNC' );
			$matches = null;
			if ( $mccMnc && mt_rand( 1, 10 ) === 2 && preg_match( '/^(\d+-\d+),(\d+-\d+)$/', $mccMnc, $matches ) ) {
				$ip = $req->getIP();
				if ( $ip ) {
					EventLogging::logEvent( 'MobileWikiAppOperatorCode',
						// https://meta.wikimedia.org/w/index.php?title=Schema:MobileWikiAppOperatorCode&oldid=8983918
						// next code line is revid as part of EventLogging schema
						8983918,
						array(
							'ip' => $ip,
							'mccMncNetwork' => $matches[1],
							'mccMncSim' => $matches[2],
						)
					);
				}

			}
			wfProfileOut( __METHOD__ );
		}

		return true;
	}
}
