<?php
/**
 * Extension ZeroBanner — Zero Banners
 *
 * @file
 * @ingroup Extensions
 * @author Patrick Reilly
 * @author Yuri Astrakhan
 * @copyright © 2011 Patrick Reilly, 2013-2014 Yuri Astrakhan
 * @licence GNU General Public Licence 2.0 or later
 */

// Needs to be called within MediaWiki; not standalone
if ( !defined( 'MEDIAWIKI' ) ) {
	echo( "This is a MediaWiki extension and cannot run standalone.\n" );
	die( -1 );
}

// Extension credits that will show up on Special:Version
$wgExtensionCredits['other'][] = array(
	'path'  =>  __FILE__,
	'name'  =>  'ZeroBanner',
	'version'  =>  '1.0.0',
	'author' => array( 'Patrick Reilly', 'Yuri Astrakhan' ),
	'descriptionmsg'  =>  'zero-desc',
	'url'  =>  'https://www.mediawiki.org/wiki/Extension:ZeroBanner',
);

$cwd = __DIR__ . DIRECTORY_SEPARATOR;
$wgMessagesDirs['ZeroBanner'] = $cwd . 'i18n';
$wgExtensionMessagesFiles['ZeroBanner'] = $cwd . 'ZeroBanner.i18n.php';
$wgExtensionMessagesFiles['ZeroBannerAlias'] = $cwd . "ZeroBanner.alias.php";

$wgSpecialPages['ZeroRatedMobileAccess'] = 'ZeroBanner\ZeroSpecialPage';
$wgSpecialPageGroups['ZeroRatedMobileAccess'] = 'other';
$wgExtensionMessagesFiles['ZeroRatedMobileAccessAlias'] = $cwd . "ZeroBanner.alias.php";

// autoload extension classes
$cwd .= 'includes' . DIRECTORY_SEPARATOR;
$autoloadClasses = array (
	'ApiRawJsonPrinter' => 'ApiZeroBanner',
	'ApiZeroBanner' => 'ApiZeroBanner',
	'MccMncLogging' => 'MccMncLogging',
	'PageRendering' => 'PageRendering',
	'PageRenderingHooks' => 'PageRenderingHooks',
	'ZeroConfig' => 'ZeroConfig',
	'ZeroSpecialPage' => 'ZeroSpecialPage',
);
foreach ( $autoloadClasses as $className => $classFilename ) {
	$wgAutoloadClasses['ZeroBanner\\' . $className] = $cwd . $classFilename . '.php';
}

$localBasePath = __DIR__;
$remoteExtPath = 'ZeroBanner';

$wgResourceModules['zerobanner.styles'] = array(
	'localBasePath' => $localBasePath,
	'remoteExtPath' => $remoteExtPath,
	'targets' => 'mobile',
	'styles' => array( 'modules/banner.css', 'modules/redux.less' ),
);

// this resource is used by the ZeroPortal to display banners on the desktop site
$wgResourceModules['zerobanner.config.styles'] = array(
	'localBasePath' => $localBasePath,
	'remoteExtPath' => $remoteExtPath,
	'targets' => array( 'desktop', 'mobile' ),
	'styles' => 'modules/banner.css',
);

$wgResourceModules['zerobanner'] = array(
	'dependencies' => array( 'mobile.stable', 'mobile.templates', 'zerobanner.styles', 'mobile.overlays' ),
	'localBasePath' => $localBasePath,
	'remoteExtPath' => $remoteExtPath,
	'localTemplateBasePath' => $localBasePath . '/templates',
	'templates' => array( 'interstitial.hogan', 'zeroinfo.hogan' ),
	// Use Mantle Resource Loader module
	'class' => 'ResourceLoaderTemplateModule',
	'targets' => array( 'mobile' ),
	'scripts' => array( 'modules/ZeroOverlay.js', 'modules/banner.js', 'modules/ZeroInfo.js', 'modules/interstitial.js' ),
	'messages' => array(
		'zero-charge-auth',
		'zero-file-auth',
		'zero-accept',
		'zero-go-back',
		'zero-dont-ask',
		'ok',
		'zero-info-intro',
		'zero-info-url',
		'zero-info-url-free',
		'zero-info-url-not-free',
		'zero-info-langs',
		'zero-info-https',
		'zero-info-proxy',
		'zero-info-geek',
	)
);

$wgResourceModules['zerobanner.special.scripts'] = array(
	'localBasePath' => $localBasePath,
	'remoteExtPath' => $remoteExtPath,
	'targets' => array( 'mobile' ),
	'scripts' => array( 'modules/forms.js' ),
);

$wgResourceModules['zerobanner.special.styles'] = array(
	'localBasePath' => $localBasePath,
	'remoteExtPath' => $remoteExtPath,
	'targets' => array( 'mobile' ),
	'styles' => array( 'modules/forms.css' ),
);

/** @var false|string[] $wgZeroSiteOverride For testing, overrides $wgConf->siteFromDB( $wgDBname )
 * On a test wiki, set it to array( 'wikipedia', 'en' ) or similar.
 * ZeroBanner explicitly checks for the site to equal 'wikipedia' before enabling Zero.
 */
$wgZeroSiteOverride = false;

/** @var string $wgZeroBannerClusterDomain Temporary workaround - until I figure out how to calculate it */
$wgZeroBannerClusterDomain = 'org';

/** @var false|string $wgZeroBannerFontSize size of the font used for the image. When given, ignores *ImageSize vals */
$wgZeroBannerFontSize = false;

/** @var string $wgZeroBannerImageSize size of the image banner. A 3px border will be added */
$wgZeroBannerImageSize = '174x';

/** @var string $wgZeroBannerErrImageSize size of the error image, not including 3px border */
$wgZeroBannerErrImageSize = '194x';

/** @var string|false $wgZeroBannerFont use a specific font for image banners */
$wgZeroBannerFont = false;  // 'FreeSans' ?

$hook = 'ZeroBanner\\PageRenderingHooks::';
$wgHooks['BeforePageDisplayMobile'][] = $hook . 'onBeforePageDisplay';
$wgHooks['GetMobileUrl'][] = $hook . 'onGetMobileUrl';
$wgHooks['MinervaPreRender'][] = $hook . 'onMinervaPreRender';
$wgHooks['MobileFrontendBeforeDOM'][] = $hook . 'onMobileFrontendBeforeDOM';
$wgHooks['MakeGlobalVariablesScript'][] = $hook . 'onMakeGlobalVariablesScript';

$wgHooks['APIAfterExecute'][] = 'ZeroBanner\\MccMncLogging::onAPIAfterExecute';

$wgAPIModules['zeroconfig'] = 'ZeroBanner\ApiZeroBanner';

// Define constants but don't add them to the namespace list - they will be used for external access only
define( 'NS_ZERO', 480 );
define( 'NS_ZERO_TALK', 481 );


// ZeroPortal will further customize this by adding a 'view'
$wgJsonConfigModels['JsonZeroConfig'] = array( 'class' => 'ZeroBanner\ZeroConfig' );

// All wikis except for portal need further customization:
//    $wgJsonConfigs['JsonZeroConfig']['remote'] = array(
//			'url' => 'https://zero.wikimedia.org/w/api.php',
//			'username' => ...,
//			'password' => ...,
//    );
$wgJsonConfigs['JsonZeroConfig'] = array(
	'namespace' => NS_ZERO,
	'nsName' => 'Zero',
	'cacheKey' => '1', // update when breaking json config structure - to simplify rollbacks
);
