/**
 * @licence GNU GPL v2+
 * @author Jeroen De Dauw < jeroendedauw@gmail.com >
 */
( function( wb, vp, util ) {
	'use strict';

	var PARENT = vp.tests.ValueParserTest;

	/**
	 * Constructor for creating a test object holding tests for the EntityIdParser.
	 *
	 * @constructor
	 * @extends valueParsers.tests.ValueParserTest
	 * @since 0.1
	 */
	wb.tests.EntityIdParserTest = util.inherit( PARENT, {

		/**
		 * @see vp.tests.ValueParserTest.getObject
		 */
		getConstructor: function() {
			return wb.EntityIdParser;
		},

		/**
		 * @see vp.tests.ValueParserTest.getParseArguments
		 */
		getParseArguments: function() {
			// FIXME: right now encapsulation is broken since settings are pulled in server side
			// This can be fixed as soon as the parser gets implemented properly
			var validValues = {
				'Q1': ['item', 1],
				'P1': ['property', 1],
				'Q42': ['item', 42],
				'P42': ['property', 42]
			};

			var argLists = [];

			// build a list with arrays as entries, [0] is parser input, [1] expected output:
			for ( var rawValue in validValues ) {
				if ( validValues.hasOwnProperty( rawValue ) ) {
					argLists.push( [ rawValue, new wb.datamodel.EntityId( validValues[rawValue][0], validValues[rawValue][1] ) ] );
				}
			}

			return argLists;
		},

		getDefaultConstructorArgs: function() {
			return [{
				'prefixmap': {
					'Q': 'item',
					'P': 'property'
				}
			}];
		}

	} );

	var test = new wb.tests.EntityIdParserTest();

	test.runTests( 'wikibase.parsers.EntityIdParser' );

}( wikibase, valueParsers, util ) );
