/*!
 * VisualEditor DataModel MWTransclusionMetaItem class.
 *
 * @copyright 2011-2014 VisualEditor Team and others; see AUTHORS.txt
 * @license The MIT License (MIT); see LICENSE.txt
 */

/**
 * DataModel MW-specific meta item.
 *
 * @class
 * @abstract
 * @extends ve.dm.AlienMetaItem
 * @constructor
 * @param {Object} element Reference to element in meta-linmod
 */
ve.dm.MWTransclusionMetaItem = function VeDmMWTransclusionMetaItem( element ) {
	// Parent constructor
	ve.dm.AlienMetaItem.call( this, element );
};

/* Inheritance */

OO.inheritClass( ve.dm.MWTransclusionMetaItem, ve.dm.AlienMetaItem );

/* Static Properties */

ve.dm.MWTransclusionMetaItem.static.name = 'mwTransclusionMeta';

ve.dm.MWTransclusionMetaItem.static.matchTagNames = [];

// mwTransclusionMetaItems are generated by ve.dm.MWTransclusionNode#toDataElement when
// all of the transclusions contents are considered to be metadata or whitespace

/* Registration */

ve.dm.modelRegistry.register( ve.dm.MWTransclusionMetaItem );
