/*!
 * VisualEditor UserInterface MobileContext class.
 *
 * @copyright 2011-2014 VisualEditor Team and others; see AUTHORS.txt
 * @license The MIT License (MIT); see LICENSE.txt
 */

/**
 * UserInterface context that displays inspector full screen.
 *
 * @class
 * @extends ve.ui.Context
 *
 * @constructor
 * @param {ve.ui.Surface} surface
 * @param {Object} [config] Configuration options
 */
ve.ui.MobileContext = function VeUiMobileContext( surface, config ) {
	// Parent constructor
	ve.ui.MobileContext.super.call( this, surface, config );

	// Properties
	this.transitioning = null;

	// Events
	this.inspectors.connect( this, {
		setup: [ 'toggle', true ],
		teardown: [ 'toggle', false ]
	} );

	// Initialization
	this.$element
		.addClass( 've-ui-mobileContext' )
		.append( this.menu.$element );
	this.menu.$element.addClass( 've-ui-mobileContext-menu' );
	this.inspectors.$element.addClass( 've-ui-mobileContext-inspectors' );
	this.surface.getGlobalOverlay().$element.append( this.inspectors.$element );
};

/* Inheritance */

OO.inheritClass( ve.ui.MobileContext, ve.ui.Context );

/* Methods */

/**
 * @inheritdoc
 */
ve.ui.MobileContext.prototype.createInspectorWindowManager = function () {
	return new ve.ui.MobileWindowManager( {
		factory: ve.ui.windowFactory,
		overlay: this.surface.getGlobalOverlay(),
		isolate: true
	} );
};

/**
 * @inheritdoc
 */
ve.ui.MobileContext.prototype.toggle = function ( show ) {
	var deferred = $.Deferred();

	show = show === undefined ? !this.visible : !!show;
	if ( show !== this.visible ) {
		this.visible = show;
		this.$element.toggleClass( 've-ui-mobileContext-visible', show );
		setTimeout( function () {
			deferred.resolve();
		}, 300 );
	} else {
		deferred.resolve();
	}

	return deferred.promise();
};

/**
 * @inheritdoc
 */
ve.ui.MobileContext.prototype.getAvailableTools = function () {
	var tools = ve.ui.MobileContext.super.prototype.getAvailableTools.call( this );

	// Filter out tools not supported in mobile mode
	// FIXME: This is a temporary hack. Ideally, we don't want to load any code
	// that is not supported on a given platform. However, present implementation
	// of citation dialog forces us to load tools that we don't want on mobile.
	this.availableTools = tools.filter( function ( tool ) {
		return (
			tool.model instanceof ve.dm.MWInternalLinkAnnotation ||
			tool.model instanceof ve.dm.MWExternalLinkAnnotation ||
			( tool.model instanceof ve.dm.MWReferenceNode && tool.tool !== ve.ui.MWReferenceDialogTool )
		);
	} );

	return this.availableTools;
};
